% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{computePcaSample}
\alias{computePcaSample}
\title{Principal Components Analysis}
\usage{
computePcaSample(
  data.sample,
  pca.nb.dims = 0,
  selected.var = NULL,
  echo = F,
  prcomp.options = list(center = T, scale = T),
  pca.variance.cum.min = 0.95
)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{pca.nb.dims}{number of dimensions to keep after PCA. If pca.nb.dims=0 (default), this number is automatically computed.}

\item{selected.var}{vector of features names to consider for the PCA.}

\item{echo}{boolean: if FALSE (default), no description printed in the console.}

\item{prcomp.options}{list of default parameters values for the function prcomp.}

\item{pca.variance.cum.min}{minimal cumulative variance to retain in PCA.}
}
\value{
features list containing the results of PCA, returned by prcomp.
}
\description{
Perform Principal Components Analysis, dealing with the number of dimensions, automatically or not.
}
\details{
computePcaSample performs Principal Components Analysis, dealing with the number of dimensions, automatically or not
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf, dir.save=tempdir())

res <- computePcaSample(x, echo = TRUE)

plot(res$pca_full$x[,1], res$pca_full$x[,2], main="PCA", xlab="PC1", ylab="PC2")


}
\seealso{
\code{\link{computeSpectralEmbeddingSample}}
}
\keyword{internal}
