\name{instantiate.rhea}
\alias{instantiate.rhea}
\title{
Instantiate Rhea generic reaction
}
\description{
Generic reaction is a reaction with at least one compound class. This function gains instance reactions from given generic reaction
}
\usage{
instantiate.rhea(equation, chemical_table, id_col='chebi',
  parent_col='parent', formula_col='formula', smiles_col='smiles', 
  inchi_col='inchi', direction_type=c(' <\\\\?> ', ' <=> ', ' => '))
}
\arguments{
  \item{equation}{
Rhea generic reaction equation with ChEBI ID (not compound name)
}
  \item{chemical_table}{
Chemical table containing chebi, parent, formula, smiles and inchi columns. This table can be generated by get.chebi.all() function
}
  \item{id_col}{
In chemical table, choose the column name which contains chemical id (usually first column)
}
  \item{parent_col}{
In chemical table, choose the column name which contains parent compound ("TYPES" in MetaCyc)
}
  \item{formula_col}{
In chemical table, choose the column name which contains molecular formula
}
  \item{smiles_col}{
In chemical table, choose the column name which contains SMILES code
}
  \item{inchi_col}{
In chemical table, choose the column name which contains InChI code
}
  \item{direction_type}{
In reaction equation, provide reaction direction charaters. Default is c(' <\\\\?> ', ' <=> ', ' => ')
}
}
\value{
List object containing instance reactions
}
\references{
Rhea: http://www.ebi.ac.uk/rhea \cr
ChEBI: http://www.ebi.ac.uk/chebi \cr
Open babel: O'Boyle NM, Banck M, James CA, Morley C, Vandermeersch T, Hutchison GR. Open Babel: An open chemical toolbox. J Cheminform. 2011 Oct 7;3:33. doi: 10.1186/1758-2946-3-33. PubMed PMID: 21982300; PubMed Central PMCID: PMC3198950.
}
\author{
Byoungnam Min <mbnmbn00@gmail.com>, Byeonghyuk Park, Kyoung Heon Kim and In-Geol Choi 
}
\seealso{
\code{\link{get.chebi.all}}
}
\examples{
# You need to load 'ChemmineOB' package before running this function.

data(example) # Load example data

chebi = example$chebi # Sample ChEBI
Rg = example$rhea_generic$equationWithChebi # Sample Rhea generic reaction

## Instantiate: Not run
#instanceR = instantiate.rhea(Rg, chebi, id_col = "chebi", parent_col="parent",
#  formula_col="formula", smiles_col="smiles", inchi_col="inchi", 
#  direction_type=c(" <\\\\?> ", " <=> ", " => "))

#print(instanceR)
}
\keyword{ Rhea }
\keyword{ ChEBI }
