% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvi_write_template.R
\name{rvn_rvi_write_template}
\alias{rvn_rvi_write_template}
\title{Write Raven rvi file based on model configuration templates}
\usage{
rvn_rvi_write_template(
  template_name = "UBCWM",
  filename = NULL,
  overwrite = TRUE,
  writeheader = TRUE,
  filetype = "rvi ASCII Raven",
  author = "RavenR",
  description = NULL
)
}
\arguments{
\item{template_name}{name of the model template to be written (default 'UBCWM')}

\item{filename}{Name of the rvi file, with extension (optional)}

\item{overwrite}{boolean whether to overwrite file if it already exists (default \code{FALSE})}

\item{writeheader}{boolean whether to write a header to the rvi file (default \code{TRUE})}

\item{filetype}{File extension, Encoding, Raven version (e.g. "rvp ASCII Raven 2.9.1") (optional)}

\item{author}{Name of file author (optional)}

\item{description}{File Description for header (e.g., Basin or project information, R script name) (optional)}
}
\value{
\item{TRUE}{returns \code{TRUE} if executed successfully}
}
\description{
Writes a Raven rvi file based on one of several template model configurations.
}
\details{
Raven has the capability of emulating a number of existing model configurations, and a number of additional
novel model configurations are provided which may be helpful to the user. These can be written with this function
for ease of getting started with a model using Raven.

The template_name parameter should be one of "UBCWM", "HBV-EC", "HBV-Light", "GR4J",
 "CdnShield", "MOHYSE", "HMETS", "HYPR", or "HYMOD".

This function uses the same model template files that are provided in the Raven User's manual, Appendix D.

The \code{\link{rvn_write_Raven_newfile}} is used to write a header in the rvi file. Writing of a header
can be disabled with \code{writeheader=FALSE}.
}
\examples{

# write the Canadian Shield configuration to 'mymodel.rvi'
rvn_rvi_write_template(template_name="CdnShield",
   filename=file.path(tempdir(), "mymodel.rvi"))

# write the HMETS model with some additional details in the description
rvn_rvi_write_template(template_name="HMETS",
   filename=file.path(tempdir(), "mynewmodel.rvi"),
   author="Robert Chlumsky",
   description="RVI file for the HMETS model (Martel, 2017) created by RavenR")

}
