% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_stages.R
\name{standard_stages}
\alias{standard_stages}
\title{Identify stages corresponding to different parts of the reproductive life
cycle}
\usage{
standard_stages(matF, repro_stages, matrix_stages)
}
\arguments{
\item{matF}{The sexual component of a matrix population model (i.e. a square
projection matrix reflecting transitions only due to \emph{sexual} 
reproduction). It assumes that it has been rearranged so that 
non-reproductive stages are in the final rows/columns.}

\item{repro_stages}{Logical vector identifying which stages are reproductive.}

\item{matrix_stages}{(character) vector of stages, values are "prop"
(propagule), "active", and "dorm" (dormant).}
}
\value{
A list with four elements:
  \item{propStages}{Position of the propagule stages}
  \item{preRepStages}{Position of the pre-reproductive stages}
  \item{repStages}{Position of the reproductive stages}
  \item{postRepStages}{Position of the post-reproductive stages}
}
\description{
Identify the stages of a matrix population model that correspond to
different parts of the reproductive life cycle, namely propagule,
pre-reproductive, reproductive and post-reproductive. These classifications
are used to standardise matrices to allow comparisons across species with
different life cycle structures, see \code{\link{mpm_standardize}}.
}
\details{
Assumes that fecundity and mean fecundity matrices have been 
rearranged so that non-reproductive stages are in the final rows/columns.
Output indicates groupings to be used when collapsing the matrix model.
}
\note{
Dormant stages are not currently handled.
}
\examples{
matU <- rbind(c(0.1,   0,   0,   0,   0),
              c(0.5, 0.2, 0.1,   0,   0),
              c(  0, 0.3, 0.3, 0.1,   0),
              c(  0,   0, 0.4, 0.4, 0.1),
              c(  0,   0,   0, 0.1, 0.4))

matF <- rbind(c(  0, 1.1,   0, 1.6,   0),
              c(  0, 0.8,   0, 0.4,   0),
              c(  0,   0,   0,   0,   0),
              c(  0,   0,   0,   0,   0),
              c(  0,   0,   0,   0,   0))

repro_stages <- c(FALSE, TRUE, FALSE, TRUE, FALSE)
matrix_stages <- c('prop', 'active', 'active', 'active', 'active')

r <- mpm_rearrange(matU, matF, repro_stages = repro_stages,
                   matrix_stages = matrix_stages)

standard_stages(r$matF, r$repro_stages, r$matrix_stages)

}
\seealso{
\code{\link{mpm_standardize}}

Other transformation: 
\code{\link{mpm_collapse}()},
\code{\link{mpm_rearrange}()},
\code{\link{mpm_split}()},
\code{\link{mpm_standardize}()},
\code{\link{name_stages}()},
\code{\link{repro_stages}()}
}
\author{
Rob Salguero-Gomez <rob.salguero@zoo.ox.ac.uk>
}
\concept{transformation}
