% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.radviz.R
\name{do.radviz}
\alias{do.radviz}
\alias{do.radviz.default}
\title{Projects a Matrix or a Data Frame to a 2D space defined by Dimensional Anchors}
\usage{
do.radviz(
  x,
  springs,
  trans = do.L,
  label.color = "orangered4",
  label.size = NA,
  type = NULL,
  graph = NULL
)
}
\arguments{
\item{x}{a data.frame or matrix to be projected, with column names matching row names in springs}

\item{springs}{a matrix of 2D dimensional anchor coordinates, as returned by \code{\link{make.S}}}

\item{trans}{a transformation to be applied to the data before projection}

\item{label.color}{the color of springs for visualization}

\item{label.size}{the size of labels}

\item{type}{character string specifying the method used for obtaining the springs. 
Current methods are: Radviz, Freeviz and Graphviz. When not provided, \code{type} is 
derived from the other inputs}

\item{graph}{\code{igraph} object (only relevant for result obtained from \code{\link{do.optimGraphviz}} analysis)}
}
\value{
an object of class radviz with the following slots:
		\itemize{
				\item \code{proj}: a ggplot2 object with a single geom_text layer corresponding to springs.
           	the \code{data} slot of the ggplot2 corresponds to the input parameter \code{x}
           	with the following extra columns:
         		\itemize{
           			\item \code{rx} and \code{ry} the X and Y coordinates of the radviz projection of \code{x} over \code{springs}
           			\item \code{rvalid} an index of points corresponding to an invalid projection (any \code{rx} or \code{ry} is NA)
				}
				\item \code{type}: character string specifying the method used for obtaining the springs.
       \item \code{graphEdges}: when the input \code{graph} is provided (for a Graphviz analysis),
             this slot will contain a dataframe with the graph edges
}
}
\description{
do.radviz will return a projection of a multidimensional dataset onto a 2D space
defined by dimensional anchors that have been projected on the unit circle using
\code{\link{make.S}}
}
\details{
The function expects that at least some of the column names in df will be matched
           by row names in springs
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
summary(rv)
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
iris0 <- rbind(iris,c(rep(0,length(das)),NA))
S <- make.S(das)
rv0 <- do.radviz(iris0,S)

sum(!is.valid(rv0)) # should be 1

# to find which points where invalid in the data
which(!is.valid(rv0))

# to review the original data points
rv1 <- subset(rv0,is.valid(rv0))

summary(rv1)
}
\author{
Yann Abraham
}
