% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.radviz.R
\name{do.radviz}
\alias{do.radviz}
\alias{do.radviz.default}
\title{Projects a Matrix or a Data Frame to a 2D space defined by Dimensional Anchors}
\usage{
do.radviz(x, springs)
}
\arguments{
\item{x}{a data.frame or matrix to be projected, with column names matching row names in springs}

\item{springs}{A matrix of 2D dimensional anchor coordinates, as returned by \code{\link{make.S}}}
}
\value{
An object of class radviz with the following slots:
         \itemize{
           \item \code{data} the original data (\code{x})
           \item \code{springs} the original \code{springs}
           \item \code{projected} the projection of \code{x} on \code{springs},
                   a matrix of 2D coordinates for every line in df
           \item \code{valid} a logical vector 
         }
}
\description{
do.radviz will return a projection of a multidimensional dataset onto a 2D space
defined by dimensional anchors that have been projected on the unit circle using
\code{\link{make.S}}
}
\details{
The function expects that at least some of the column names in df will be matched
           by row names in springs
}
\examples{
# the first example generates a simple Radviz object
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
summary(rv)

# in case a point cannot be projected, a warning will be raise
iris0 <- rbind(iris,c(rep(0,length(das)),NA))
rv0 <- do.radviz(iris0,S)

# to find out how many points could not be projected:
with(rv0,sum(!valid))

# to find which points where invalid in the data
with(rv0,which(!valid))

# to review the original data points
with(rv0,subset(data,!valid))

}
\author{
Yann Abraham
}

