% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funmaintext.R
\name{funmaintext}
\alias{funmaintext}
\alias{funmaintex}
\alias{funheadermd}
\alias{funheadertex}
\alias{funfootertex}
\title{Modify the Main Text and the Markdown Header in p_text Function}
\usage{
funmaintext(pkg, sep1, sep2, eol, crandb, repos)

funmaintex(pkg, sep1, sep2, eol, crandb, repos)

funheadermd(title = "TITLE", author = "AUTHOR", date = Sys.Date(),
  keep_tex = "false", toc = "false", number_sections = "true",
  fontsize = "10pt", papersize = "a4paper", margin = "1in")

funheadertex(fontsize = "10pt", papersize = "a4paper", margin = "1in")

funfootertex()
}
\arguments{
\item{pkg}{character. The package name.}

\item{sep1}{character. The symbols written just before each package name.}

\item{sep2}{character. The symbols written just after each package name.}

\item{eol}{character. The end of line for the main text (but not for the
header and the footer). \code{"\\n"} for text, \code{"  \\n"}
for rmarkdown, \code{" \\\\ \\n"} for latex.}

\item{crandb}{data.frame \code{crandb}. The data.frame of CRAN packages.}

\item{repos}{character. The address of your local CRAN.}

\item{title}{character. The title of the .md document (and then in the .pdf file).}

\item{author}{character. The author of the .md document.}

\item{date}{character. The date of the document. Any text format is accepted.}

\item{keep_tex}{character. "true" or "false".}

\item{toc}{character. "true" or "false".}

\item{number_sections}{character. "true" or "false".}

\item{fontsize}{character. Usually "10pt", "11pt", "12pt.}

\item{papersize}{character. The usual tex format. Example: "a4paper".}

\item{margin}{character. In inches, cm or mm. Example: "0.5in", "1.5cm", "25mm".}
}
\description{
Use \code{funmaintext} or \code{funmaintext2} to select the function that displays
the main text. Usage is \code{f\_maintext = funmaintext} (without curly braces).

Use \code{funheadermd} to insert markdown header in function \code{sep1 = funheadermd()}
(with curly braces).

See the example in \code{p\_text}. To create you own functions, use these functions
as a pattern. The five parameters in \code{f\_maintext, funmaintext} are mandatory.
\code{funheadermd} can be freely modified.
}
