% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cranmirrors.R
\name{cranmirrors}
\alias{cranmirrors}
\alias{cranmirrors_down}
\title{CRAN archive (CRAN-archive.html + archivedb)}
\usage{
cranmirrors_down(filename = "CRAN-mirrors1.csv", dir = ".",
  columns = c(1, 3, 7), save = FALSE,
  url = "https://cran.r-project.org/CRAN_mirrors.csv")
}
\arguments{
\item{filename}{character. The path to file "CRAN-mirrors1.csv" (or equivalent).}

\item{dir}{character. The directory where \code{filename} is saved.
Default value \code{"."} is the current directory.}

\item{columns}{a vector of integers or a vector of names. 
The column numbers or the column names. Allowed numbers 
are within 1:9. Allowed names are: "Name", "Country",
"City", "URL", "Host", "Maintainer", "OK", "CountryCode" 
and "Comment".}

\item{save}{logical. Save the file. If \code{FALSE}, the default, the 
file is just loaded in .GlobalEnv and a subset is printed
in the console.}

\item{url}{character. The url address of the CRAN csv file.}
}
\description{
\code{cranmirrors_down} downloads the csv file of CRAN mirrors, modifies the 
"Maintainer" and "Host" columns, eventually saves the modified data.frame on 
the disk, loads this data.frame in .GlobalEnv and prints in the console a 
subset of the data.frame made of the selected columns.
}
\examples{
cranmirrors_down(dir = tempdir(), save = TRUE)

}
