/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.Loader;
import weka.core.converters.URLSourcedLoader;
import weka.gui.ConverterFileChooser;
import weka.gui.InstancesSummaryPanel;

public class SetInstancesPanel
extends JPanel {
    private static final long serialVersionUID = -384804041420453735L;
    protected JButton m_OpenFileBut = new JButton("Open file...");
    protected JButton m_OpenURLBut = new JButton("Open URL...");
    protected JButton m_CloseBut = new JButton("Close");
    protected InstancesSummaryPanel m_Summary = new InstancesSummaryPanel();
    protected ConverterFileChooser m_FileChooser = new ConverterFileChooser(new File(System.getProperty("user.dir")));
    protected String m_LastURL = "http://";
    protected Thread m_IOThread;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Instances m_Instances;
    protected Loader m_Loader;
    protected JFrame m_ParentFrame = null;
    protected JPanel m_CloseButPanel = null;
    protected boolean m_readIncrementally = true;

    public SetInstancesPanel() {
        this.m_OpenFileBut.setToolTipText("Open a set of instances from a file");
        this.m_OpenURLBut.setToolTipText("Open a set of instances from a URL");
        this.m_CloseBut.setToolTipText("Closes the dialog");
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_OpenURLBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetInstancesPanel.this.setInstancesFromURLQ();
            }
        });
        this.m_OpenFileBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetInstancesPanel.this.setInstancesFromFileQ();
            }
        });
        this.m_CloseBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetInstancesPanel.this.closeFrame();
            }
        });
        this.m_Summary.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(this.m_OpenFileBut);
        jPanel.add(this.m_OpenURLBut);
        this.m_CloseButPanel = new JPanel();
        this.m_CloseButPanel.setLayout(new FlowLayout(2));
        this.m_CloseButPanel.add(this.m_CloseBut);
        this.m_CloseButPanel.setVisible(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.m_CloseButPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Summary, "Center");
        this.add((Component)jPanel2, "South");
    }

    public void setParentFrame(JFrame jFrame) {
        this.m_ParentFrame = jFrame;
        this.m_CloseButPanel.setVisible(this.m_ParentFrame != null);
    }

    public JFrame getParentFrame() {
        return this.m_ParentFrame;
    }

    public void closeFrame() {
        if (this.m_ParentFrame != null) {
            this.m_ParentFrame.setVisible(false);
        }
    }

    public void setInstancesFromFileQ() {
        if (this.m_IOThread == null) {
            int n = this.m_FileChooser.showOpenDialog(this);
            if (n == 0) {
                final File file = this.m_FileChooser.getSelectedFile();
                this.m_IOThread = new Thread(){

                    public void run() {
                        SetInstancesPanel.this.setInstancesFromFile(file);
                        SetInstancesPanel.this.m_IOThread = null;
                    }
                };
                this.m_IOThread.setPriority(1);
                this.m_IOThread.start();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURLQ() {
        if (this.m_IOThread == null) {
            try {
                String string = (String)JOptionPane.showInputDialog(this, "Enter the source URL", "Load Instances", 3, null, null, this.m_LastURL);
                if (string != null) {
                    this.m_LastURL = string;
                    final URL uRL = new URL(string);
                    this.m_IOThread = new Thread(){

                        public void run() {
                            SetInstancesPanel.this.setInstancesFromURL(uRL);
                            SetInstancesPanel.this.m_IOThread = null;
                        }
                    };
                    this.m_IOThread.setPriority(1);
                    this.m_IOThread.start();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Problem with URL:\n" + exception.getMessage(), "Load Instances", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    protected void setInstancesFromFile(File file) {
        boolean bl = this.m_readIncrementally;
        try {
            this.m_Loader = ConverterUtils.getLoaderForFile(file);
            if (this.m_Loader == null) {
                throw new Exception("No suitable FileSourcedConverter found for file!\n" + file);
            }
            if (!(this.m_Loader instanceof IncrementalConverter)) {
                bl = false;
            }
            ((FileSourcedConverter)((Object)this.m_Loader)).setFile(file);
            if (bl) {
                this.setInstances(this.m_Loader.getStructure());
            } else {
                this.setInstances(this.m_Loader.getDataSet());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Couldn't read from file:\n" + file.getName(), "Load Instances", 0);
        }
    }

    protected void setInstancesFromURL(URL uRL) {
        boolean bl = this.m_readIncrementally;
        try {
            this.m_Loader = ConverterUtils.getURLLoaderForFile(uRL.toString());
            if (this.m_Loader == null) {
                throw new Exception("No suitable URLSourcedLoader found for URL!\n" + uRL);
            }
            if (!(this.m_Loader instanceof IncrementalConverter)) {
                bl = false;
            }
            ((URLSourcedLoader)((Object)this.m_Loader)).setURL(uRL.toString());
            if (bl) {
                this.setInstances(this.m_Loader.getStructure());
            } else {
                this.setInstances(this.m_Loader.getDataSet());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Couldn't read from URL:\n" + uRL, "Load Instances", 0);
        }
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        this.m_Summary.setInstances(this.m_Instances);
        this.m_Support.firePropertyChange("", null, null);
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public Loader getLoader() {
        return this.m_Loader;
    }

    public InstancesSummaryPanel getSummary() {
        return this.m_Summary;
    }

    public void setReadIncrementally(boolean bl) {
        this.m_readIncrementally = bl;
    }

    public boolean getReadIncrementally() {
        return this.m_readIncrementally;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.removePropertyChangeListener(propertyChangeListener);
    }
}

