/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Random;
import java.util.StringTokenizer;
import weka.core.AttributeExpression;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Matrix;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class CostMatrix
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -1973792250544554965L;
    private int m_size;
    protected Object[][] m_matrix;
    public static String FILE_EXTENSION = ".cost";

    public CostMatrix(int n) {
        this.m_size = n;
        this.initialize();
    }

    public CostMatrix(CostMatrix costMatrix) {
        this(costMatrix.size());
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.setCell(i, j, costMatrix.getCell(i, j));
            }
        }
    }

    public void initialize() {
        this.m_matrix = new Object[this.m_size][this.m_size];
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.setCell(i, j, i == j ? new Double(0.0) : new Double(1.0));
            }
        }
    }

    public int size() {
        return this.m_size;
    }

    public int numColumns() {
        return this.size();
    }

    public int numRows() {
        return this.size();
    }

    private boolean replaceStrings() throws Exception {
        boolean bl = false;
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                if (this.getCell(i, j) instanceof String) {
                    AttributeExpression attributeExpression = new AttributeExpression();
                    attributeExpression.convertInfixToPostfix((String)this.getCell(i, j));
                    this.setCell(i, j, attributeExpression);
                    bl = true;
                    continue;
                }
                if (!(this.getCell(i, j) instanceof AttributeExpression)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public Instances applyCostMatrix(Instances instances, Random random) throws Exception {
        int n;
        int n2;
        double d = 0.0;
        if (instances.classIndex() < 0) {
            throw new Exception("Class index is not set!");
        }
        if (this.size() != instances.numClasses()) {
            throw new Exception("Misclassification cost matrix has wrong format!");
        }
        if (this.replaceStrings()) {
            if (instances.classAttribute().numValues() > 2) {
                throw new Exception("Can't resample/reweight instances using non-fixed cost values when there are more than two classes!");
            }
            double[] dArray = new double[instances.numInstances()];
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                int n3 = (int)instance.classValue();
                double d2 = 1.0;
                Object object = n3 == 0 ? this.getCell(n3, 1) : this.getCell(n3, 0);
                d2 = object instanceof Double ? ((Double)object).doubleValue() : ((AttributeExpression)object).evaluateExpression(instance);
                dArray[i] = instance.weight() * d2;
            }
            if (random != null) {
                return instances.resampleWithWeights(random, dArray);
            }
            Instances instances2 = new Instances(instances);
            for (int i = 0; i < instances.numInstances(); ++i) {
                instances2.instance(i).setWeight(dArray[i]);
            }
            return instances2;
        }
        double[] dArray = new double[instances.numClasses()];
        double[] dArray2 = new double[instances.numClasses()];
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            int n4 = (int)instances.instance(n2).classValue();
            dArray2[n4] = dArray2[n4] + instances.instance(n2).weight();
        }
        double d3 = Utils.sum(dArray2);
        for (n2 = 0; n2 < this.m_size; ++n2) {
            if (Utils.eq((Double)this.getCell(n2, n2), 0.0)) continue;
            CostMatrix costMatrix = new CostMatrix(this);
            costMatrix.normalize();
            return costMatrix.applyCostMatrix(instances, random);
        }
        for (n2 = 0; n2 < instances.numClasses(); ++n2) {
            double d4 = 0.0;
            for (n = 0; n < instances.numClasses(); ++n) {
                if (Utils.sm((Double)this.getCell(n2, n), 0.0)) {
                    throw new Exception("Neg. weights in misclassification cost matrix!");
                }
                d4 += ((Double)this.getCell(n2, n)).doubleValue();
            }
            dArray[n2] = d4 * d3;
            d += d4 * dArray2[n2];
        }
        n2 = 0;
        while (n2 < instances.numClasses()) {
            int n5 = n2++;
            dArray[n5] = dArray[n5] / d;
        }
        double[] dArray3 = new double[instances.numInstances()];
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            dArray3[n2] = instances.instance(n2).weight() * dArray[(int)instances.instance(n2).classValue()];
        }
        if (random != null) {
            return instances.resampleWithWeights(random, dArray3);
        }
        Instances instances3 = new Instances(instances);
        for (n = 0; n < instances.numInstances(); ++n) {
            instances3.instance(n).setWeight(dArray3[n]);
        }
        return instances3;
    }

    public double[] expectedCosts(double[] dArray) throws Exception {
        if (dArray.length != this.m_size) {
            throw new Exception("Length of probability estimates don't match cost matrix");
        }
        double[] dArray2 = new double[this.m_size];
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                Object object = this.getCell(j, i);
                if (!(object instanceof Double)) {
                    throw new Exception("Can't use non-fixed costs in computing expected costs.");
                }
                int n = i;
                dArray2[n] = dArray2[n] + dArray[j] * (Double)object;
            }
        }
        return dArray2;
    }

    public double[] expectedCosts(double[] dArray, Instance instance) throws Exception {
        if (dArray.length != this.m_size) {
            throw new Exception("Length of probability estimates don't match cost matrix");
        }
        if (!this.replaceStrings()) {
            return this.expectedCosts(dArray);
        }
        double[] dArray2 = new double[this.m_size];
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                Object object = this.getCell(j, i);
                double d = !(object instanceof Double) ? ((AttributeExpression)object).evaluateExpression(instance) : ((Double)object).doubleValue();
                int n = i;
                dArray2[n] = dArray2[n] + dArray[j] * d;
            }
        }
        return dArray2;
    }

    public double getMaxCost(int n) throws Exception {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.m_size; ++i) {
            Object object = this.getCell(n, i);
            if (!(object instanceof Double)) {
                throw new Exception("Can't use non-fixed costs when getting max cost.");
            }
            double d2 = (Double)object;
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMaxCost(int n, Instance instance) throws Exception {
        if (!this.replaceStrings()) {
            return this.getMaxCost(n);
        }
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.m_size; ++i) {
            Object object = this.getCell(n, i);
            double d2 = !(object instanceof Double) ? ((AttributeExpression)object).evaluateExpression(instance) : ((Double)object).doubleValue();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public void normalize() {
        for (int i = 0; i < this.m_size; ++i) {
            double d = (Double)this.getCell(i, i);
            for (int j = 0; j < this.m_size; ++j) {
                this.setCell(j, i, new Double((Double)this.getCell(j, i) - d));
            }
        }
    }

    public void readOldFormat(Reader reader) throws Exception {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        this.initialize();
        streamTokenizer.commentChar(37);
        streamTokenizer.eolIsSignificant(true);
        while (-1 != (n = streamTokenizer.nextToken())) {
            if (n == 10) continue;
            if (n != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double d = streamTokenizer.nval;
            if (!Utils.eq((int)d, d)) {
                throw new Exception("First number in line has to be index of a class!");
            }
            if ((int)d >= this.size()) {
                throw new Exception("Class index out of range!");
            }
            n = streamTokenizer.nextToken();
            if (-1 == n) {
                throw new Exception("Premature end of file!");
            }
            if (n == 10) {
                throw new Exception("Premature end of line!");
            }
            if (n != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double d2 = streamTokenizer.nval;
            if (!Utils.eq((int)d2, d2)) {
                throw new Exception("Second number in line has to be index of a class!");
            }
            if ((int)d2 >= this.size()) {
                throw new Exception("Class index out of range!");
            }
            if ((int)d2 == (int)d) {
                throw new Exception("Diagonal of cost matrix non-zero!");
            }
            n = streamTokenizer.nextToken();
            if (-1 == n) {
                throw new Exception("Premature end of file!");
            }
            if (n == 10) {
                throw new Exception("Premature end of line!");
            }
            if (n != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double d3 = streamTokenizer.nval;
            if (!Utils.gr(d3, 0.0)) {
                throw new Exception("Only positive weights allowed!");
            }
            this.setCell((int)d, (int)d2, new Double(d3));
        }
    }

    public CostMatrix(Reader reader) throws Exception {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        int n = -1;
        while ((string = lineNumberReader.readLine()) != null) {
            int n2;
            StringTokenizer stringTokenizer;
            if (string.startsWith("%") || !(stringTokenizer = new StringTokenizer(string)).hasMoreTokens()) continue;
            if (n < 0) {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new Exception("Line " + lineNumberReader.getLineNumber() + ": expected number of columns");
                }
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 != n3) {
                    throw new Exception("Trying to create a non-square cost matrix");
                }
                this.m_size = n2;
                this.initialize();
                ++n;
                continue;
            }
            if (n == this.m_size) {
                throw new Exception("Line " + lineNumberReader.getLineNumber() + ": too many rows provided");
            }
            for (n2 = 0; n2 < this.m_size; ++n2) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new Exception("Line " + lineNumberReader.getLineNumber() + ": too few matrix elements provided");
                }
                String string2 = stringTokenizer.nextToken();
                Double d = null;
                try {
                    d = new Double(string2);
                    double d2 = d;
                }
                catch (Exception exception) {
                    d = null;
                }
                if (d == null) {
                    this.setCell(n, n2, string2);
                    continue;
                }
                this.setCell(n, n2, d);
            }
            ++n;
        }
        if (n == -1) {
            throw new Exception("Line " + lineNumberReader.getLineNumber() + ": expected number of rows");
        }
        if (n != this.m_size) {
            throw new Exception("Line " + lineNumberReader.getLineNumber() + ": too few rows provided");
        }
    }

    public void write(Writer writer) throws Exception {
        writer.write("% Rows\tColumns\n");
        writer.write("" + this.m_size + "\t" + this.m_size + "\n");
        writer.write("% Matrix elements\n");
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                writer.write("" + this.getCell(i, j) + "\t");
            }
            writer.write("\n");
        }
        writer.flush();
    }

    public String toMatlab() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.m_size; ++i) {
            if (i > 0) {
                stringBuffer.append("; ");
            }
            for (int j = 0; j < this.m_size; ++j) {
                if (j > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.getCell(i, j));
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final void setCell(int n, int n2, Object object) {
        this.m_matrix[n][n2] = object;
    }

    public final Object getCell(int n, int n2) {
        return this.m_matrix[n][n2];
    }

    public final double getElement(int n, int n2) throws Exception {
        if (!(this.m_matrix[n][n2] instanceof Double)) {
            throw new Exception("Cost matrix contains non-fixed costs!");
        }
        return (Double)this.m_matrix[n][n2];
    }

    public final double getElement(int n, int n2, Instance instance) throws Exception {
        if (this.m_matrix[n][n2] instanceof Double) {
            return (Double)this.m_matrix[n][n2];
        }
        if (this.m_matrix[n][n2] instanceof String) {
            this.replaceStrings();
        }
        return ((AttributeExpression)this.m_matrix[n][n2]).evaluateExpression(instance);
    }

    public final void setElement(int n, int n2, double d) {
        this.m_matrix[n][n2] = new Double(d);
    }

    public static Matrix parseMatlab(String string) throws Exception {
        return Matrix.parseMatlab(string);
    }

    public String toString() {
        int n;
        double d = 0.0;
        boolean bl = false;
        Object object = null;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.size(); ++n) {
            for (int i = 0; i < this.size(); ++i) {
                object = this.getCell(n, i);
                if (object instanceof Double) {
                    double d2 = (Double)object;
                    if (d2 < 0.0) {
                        d2 *= -11.0;
                    }
                    if (d2 > d) {
                        d = d2;
                    }
                    double d3 = Math.abs(d2 - Math.rint(d2));
                    if (bl || !(Math.log(d3) / Math.log(10.0) >= -2.0)) continue;
                    bl = true;
                    continue;
                }
                if (object.toString().length() <= n3) continue;
                n3 = object.toString().length();
            }
        }
        if (d > 0.0) {
            n2 = (int)(Math.log(d) / Math.log(10.0) + (double)(bl ? 4 : 1));
        }
        n = n2 > n3 ? n2 : n3;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                object = this.getCell(i, j);
                if (object instanceof Double) {
                    stringBuffer.append(" ").append(Utils.doubleToString((Double)object, n, bl ? 2 : 0));
                    continue;
                }
                int n4 = n - object.toString().length();
                if (n4 > 0) {
                    int n5 = n4 % 2;
                    String string = Utils.padLeft(object.toString(), object.toString().length() + (n5 += n4 / 2));
                    string = Utils.padRight(string, n);
                    stringBuffer.append(" ").append(string);
                    continue;
                }
                stringBuffer.append(" ").append(object.toString());
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.17 $");
    }
}

