/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.DatabaseConnection;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.IncrementalConverter;

public class DatabaseLoader
extends AbstractLoader
implements BatchConverter,
IncrementalConverter,
DatabaseConverter,
OptionHandler {
    static final long serialVersionUID = -7936159015338318659L;
    protected Instances m_structure;
    private Instances m_datasetPseudoInc;
    private Instances m_oldStructure;
    private DatabaseConnection m_DataBaseConnection;
    private String m_query = "Select * from Results0";
    private boolean m_pseudoIncremental;
    private boolean m_checkForTable;
    private int m_nominalToStringLimit;
    private int m_rowCount;
    private int m_counter;
    private int m_choice;
    private boolean m_firstTime;
    private boolean m_inc;
    private FastVector m_orderBy;
    private Hashtable[] m_nominalIndexes;
    private FastVector[] m_nominalStrings;
    private String m_idColumn;
    protected static String PROPERTY_FILE = "weka/experiment/DatabaseUtils.props";
    protected static Properties PROPERTIES;
    protected String m_URL = null;
    protected String m_User = null;
    protected String m_Password = null;
    protected String m_Keys = null;

    public DatabaseLoader() throws Exception {
        this.reset();
        this.m_pseudoIncremental = false;
        this.m_checkForTable = true;
        String string = PROPERTIES.getProperty("nominalToStringLimit");
        this.m_nominalToStringLimit = Integer.parseInt(string);
        this.m_idColumn = PROPERTIES.getProperty("idColumn");
        if (PROPERTIES.getProperty("checkForTable", "").equalsIgnoreCase("FALSE")) {
            this.m_checkForTable = false;
        }
    }

    public String globalInfo() {
        return "Reads Instances from a Database. Can read a database in batch or incremental mode.\nIn inremental mode MySQL and HSQLDB are supported.\nFor all other DBMS set a pseudoincremental mode is used:\nIn pseudo incremental mode the instances are read into main memory all at once and then incrementally provided to the user.\nFor incremental loading the rows in the database table have to be ordered uniquely.\nThe reason for this is that every time only a single row is fetched by extending the user query by a LIMIT clause.\nIf this extension is impossible instances will be loaded pseudoincrementally. To ensure that every row is fetched exaclty once, they have to ordered.\nTherefore a (primary) key is necessary.This approach is chosen, instead of using JDBC driver facilities, because the latter one differ betweeen different drivers.\nIf you use the DatabaseSaver and save instances by generating automatically a primary key (its name is defined in DtabaseUtils), this primary key will be used for ordering but will not be part of the output. The user defined SQL query to extract the instances should not contain LIMIT and ORDER BY clauses (see -Q option).\nIn addition, for incremental loading,  you can define in the DatabaseUtils file how many distinct values a nominal attribute is allowed to have. If this number is exceeded, the column will become a string attribute.\nIn batch mode no string attributes will be created.";
    }

    public void reset() throws Exception {
        this.resetStructure();
        if (this.m_DataBaseConnection != null && this.m_DataBaseConnection.isConnected()) {
            this.m_DataBaseConnection.disconnectFromDatabase();
        }
        this.m_DataBaseConnection = new DatabaseConnection();
        if (this.m_URL != null) {
            this.m_DataBaseConnection.setDatabaseURL(this.m_URL);
        }
        if (this.m_User != null) {
            this.m_DataBaseConnection.setUsername(this.m_User);
        }
        if (this.m_Password != null) {
            this.m_DataBaseConnection.setPassword(this.m_Password);
        }
        this.m_orderBy = new FastVector();
        if (this.m_Keys != null) {
            this.setKeys(this.m_Keys);
        }
        this.m_inc = false;
    }

    public void resetStructure() {
        this.m_structure = null;
        this.m_datasetPseudoInc = null;
        this.m_oldStructure = null;
        this.m_rowCount = 0;
        this.m_counter = 0;
        this.m_choice = 0;
        this.m_firstTime = true;
        this.setRetrieval(0);
    }

    public void setQuery(String string) {
        string = string.replaceAll("[fF][rR][oO][mM]", "FROM");
        this.m_query = string = string.replaceFirst("[sS][eE][lL][eE][cC][tT]", "SELECT");
    }

    public String getQuery() {
        return this.m_query;
    }

    public String queryTipText() {
        return "The query that should load the instances.\n The query has to be of the form SELECT <column-list>|* FROM <table> [WHERE <conditions>]";
    }

    public void setKeys(String string) {
        this.m_Keys = string;
        this.m_orderBy.removeAllElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.replaceAll(" ", "");
            this.m_orderBy.addElement(string2);
        }
    }

    public String getKeys() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_orderBy.size(); ++i) {
            stringBuffer.append((String)this.m_orderBy.elementAt(i));
            if (i == this.m_orderBy.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String keysTipText() {
        return "For incremental loading a unique identiefer has to be specified.\nIf the query includes all columns of a table (SELECT *...) a primary key\ncan be detected automatically depending on the JDBC driver. If that is not possible\nspecify the key columns here in a comma separated list.";
    }

    public void setUrl(String string) {
        this.m_URL = string;
        this.m_DataBaseConnection.setDatabaseURL(string);
    }

    public String getUrl() {
        return this.m_DataBaseConnection.getDatabaseURL();
    }

    public String urlTipText() {
        return "The URL of the database";
    }

    public void setUser(String string) {
        this.m_User = string;
        this.m_DataBaseConnection.setUsername(string);
    }

    public String getUser() {
        return this.m_DataBaseConnection.getUsername();
    }

    public String userTipText() {
        return "The user name for the database";
    }

    public void setPassword(String string) {
        this.m_Password = string;
        this.m_DataBaseConnection.setPassword(string);
    }

    public String getPassword() {
        return this.m_DataBaseConnection.getPassword();
    }

    public String passwordTipText() {
        return "The database password";
    }

    public void setSource(String string, String string2, String string3) {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
            this.setUrl(string);
            this.setUser(string2);
            this.setPassword(string3);
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    public void setSource(String string) {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
            this.setUrl(string);
            this.m_User = this.m_DataBaseConnection.getUsername();
            this.m_Password = this.m_DataBaseConnection.getPassword();
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    public void setSource() throws Exception {
        this.m_DataBaseConnection = new DatabaseConnection();
        this.m_URL = this.m_DataBaseConnection.getDatabaseURL();
        this.m_User = this.m_DataBaseConnection.getUsername();
        this.m_Password = this.m_DataBaseConnection.getPassword();
    }

    public void connectToDatabase() {
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.connectToDatabase();
            }
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    private String endOfQuery(boolean bl) {
        int n = this.m_query.indexOf("FROM ") + 5;
        while (this.m_query.charAt(n) == ' ') {
            ++n;
        }
        int n2 = this.m_query.indexOf(" ", n);
        String string = n2 != -1 && bl ? this.m_query.substring(n, n2) : this.m_query.substring(n);
        if (this.m_DataBaseConnection.getUpperCase()) {
            string = string.toUpperCase();
        }
        return string;
    }

    private boolean checkForKey() throws Exception {
        String string = this.m_query;
        if (!(string = string.replaceAll(" +", " ")).startsWith("SELECT *")) {
            return false;
        }
        this.m_orderBy.removeAllElements();
        if (!this.m_DataBaseConnection.isConnected()) {
            this.m_DataBaseConnection.connectToDatabase();
        }
        DatabaseMetaData databaseMetaData = this.m_DataBaseConnection.getMetaData();
        String string2 = this.endOfQuery(true);
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, string2);
        while (resultSet.next()) {
            this.m_orderBy.addElement(resultSet.getString(4));
        }
        resultSet.close();
        if (this.m_orderBy.size() != 0) {
            return true;
        }
        resultSet = databaseMetaData.getBestRowIdentifier(null, null, string2, 2, false);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 0;
        while (resultSet.next()) {
            this.m_orderBy.addElement(resultSet.getString(2));
            ++n;
        }
        resultSet.close();
        if (n == resultSetMetaData.getColumnCount()) {
            this.m_orderBy.removeAllElements();
        }
        return this.m_orderBy.size() != 0;
    }

    private void stringToNominal(ResultSet resultSet, int n) throws Exception {
        while (resultSet.next()) {
            Double d;
            String string = resultSet.getString(1);
            if (resultSet.wasNull() || (d = (Double)this.m_nominalIndexes[n - 1].get(string)) != null) continue;
            d = new Double(this.m_nominalStrings[n - 1].size());
            this.m_nominalIndexes[n - 1].put(string, d);
            this.m_nominalStrings[n - 1].addElement(string);
        }
    }

    private String limitQuery(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (this.m_orderBy.size() != 0) {
            stringBuffer.append(" ORDER BY ");
            for (int i = 0; i < this.m_orderBy.size() - 1; ++i) {
                if (this.m_DataBaseConnection.getUpperCase()) {
                    stringBuffer.append(((String)this.m_orderBy.elementAt(i)).toUpperCase());
                } else {
                    stringBuffer.append((String)this.m_orderBy.elementAt(i));
                }
                stringBuffer.append(", ");
            }
            if (this.m_DataBaseConnection.getUpperCase()) {
                stringBuffer.append(((String)this.m_orderBy.elementAt(this.m_orderBy.size() - 1)).toUpperCase());
            } else {
                stringBuffer.append((String)this.m_orderBy.elementAt(this.m_orderBy.size() - 1));
            }
            string2 = stringBuffer.toString();
        }
        if (n2 == 0) {
            String string3 = string.replaceFirst("SELECT", "SELECT LIMIT " + n + " 1");
            string3 = string3.concat(string2);
            return string3;
        }
        if (n2 == 1) {
            String string4 = string.concat(string2 + " LIMIT 1 OFFSET " + n);
            return string4;
        }
        String string5 = string.concat(string2 + " LIMIT " + n + ", 1");
        return string5;
    }

    private int getRowCount() throws Exception {
        String string = "SELECT COUNT(*) FROM " + this.endOfQuery(false);
        if (!this.m_DataBaseConnection.execute(string)) {
            throw new Exception("Cannot count results tuples.");
        }
        ResultSet resultSet = this.m_DataBaseConnection.getResultSet();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    public Instances getStructure() throws IOException {
        block44: {
            if (this.m_DataBaseConnection == null) {
                throw new IOException("No source database has been specified");
            }
            this.connectToDatabase();
            try {
                if (this.m_pseudoIncremental && this.m_structure == null) {
                    if (this.getRetrieval() == 1) {
                        throw new IOException("Cannot mix getting instances in both incremental and batch modes");
                    }
                    this.setRetrieval(0);
                    this.m_datasetPseudoInc = this.getDataSet();
                    this.m_structure = new Instances(this.m_datasetPseudoInc, 0);
                    this.setRetrieval(0);
                    return this.m_structure;
                }
                if (this.m_structure == null) {
                    int n;
                    Object object;
                    String string;
                    if (this.m_checkForTable && !this.m_DataBaseConnection.tableExists(this.endOfQuery(true))) {
                        throw new IOException("Table does not exist according to metadata from JDBC driver. If you are convinced the table exists, set 'checkForTable' to 'False' in your DatabaseUtils.props file and try again.");
                    }
                    int n2 = 0;
                    boolean bl = false;
                    while (!bl) {
                        try {
                            if (!this.m_DataBaseConnection.execute(this.limitQuery(this.m_query, 0, n2))) {
                                throw new IOException("Query didn't produce results");
                            }
                            this.m_choice = n2;
                            bl = true;
                        }
                        catch (SQLException sQLException) {
                            if (++n2 != 3) continue;
                            System.out.println("Incremental loading not supported for that DBMS. Pseudoincremental mode is used if you use incremental loading.\nAll rows are loaded into memory once and retrieved incrementally from memory instead of from the database.");
                            this.m_pseudoIncremental = true;
                            break block44;
                        }
                    }
                    String string2 = this.endOfQuery(false);
                    ResultSet resultSet = this.m_DataBaseConnection.getResultSet();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    resultSet.close();
                    int n3 = resultSetMetaData.getColumnCount();
                    int[] nArray = new int[n3];
                    this.m_nominalIndexes = new Hashtable[n3];
                    this.m_nominalStrings = new FastVector[n3];
                    block24: for (int i = 1; i <= n3; ++i) {
                        switch (this.m_DataBaseConnection.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                            case 0: {
                                ResultSet resultSet2;
                                string = resultSetMetaData.getColumnName(i);
                                if (this.m_DataBaseConnection.getUpperCase()) {
                                    string = string.toUpperCase();
                                }
                                this.m_nominalIndexes[i - 1] = new Hashtable();
                                this.m_nominalStrings[i - 1] = new FastVector();
                                object = "SELECT COUNT(DISTINCT( " + string + " )) FROM " + string2;
                                if (this.m_DataBaseConnection.execute((String)object)) {
                                    resultSet2 = this.m_DataBaseConnection.getResultSet();
                                    resultSet2.next();
                                    n = resultSet2.getInt(1);
                                    resultSet2.close();
                                    if (n > this.m_nominalToStringLimit || !this.m_DataBaseConnection.execute("SELECT DISTINCT ( " + string + " ) FROM " + string2 + " ORDER BY " + string)) {
                                        nArray[i - 1] = 2;
                                        continue block24;
                                    }
                                } else {
                                    nArray[i - 1] = 2;
                                    continue block24;
                                }
                                resultSet2 = this.m_DataBaseConnection.getResultSet();
                                nArray[i - 1] = 1;
                                this.stringToNominal(resultSet2, i);
                                resultSet2.close();
                                continue block24;
                            }
                            case 9: {
                                ResultSet resultSet2;
                                string = resultSetMetaData.getColumnName(i);
                                if (this.m_DataBaseConnection.getUpperCase()) {
                                    string = string.toUpperCase();
                                }
                                this.m_nominalIndexes[i - 1] = new Hashtable();
                                this.m_nominalStrings[i - 1] = new FastVector();
                                object = "SELECT COUNT(DISTINCT( " + string + " )) FROM " + string2;
                                if (this.m_DataBaseConnection.execute((String)object)) {
                                    resultSet2 = this.m_DataBaseConnection.getResultSet();
                                    this.stringToNominal(resultSet2, i);
                                    resultSet2.close();
                                }
                                nArray[i - 1] = 2;
                                continue block24;
                            }
                            case 1: {
                                nArray[i - 1] = 1;
                                this.m_nominalIndexes[i - 1] = new Hashtable();
                                this.m_nominalIndexes[i - 1].put("false", new Double(0.0));
                                this.m_nominalIndexes[i - 1].put("true", new Double(1.0));
                                this.m_nominalStrings[i - 1] = new FastVector();
                                this.m_nominalStrings[i - 1].addElement("false");
                                this.m_nominalStrings[i - 1].addElement("true");
                                continue block24;
                            }
                            case 2: {
                                nArray[i - 1] = 0;
                                continue block24;
                            }
                            case 3: {
                                nArray[i - 1] = 0;
                                continue block24;
                            }
                            case 4: {
                                nArray[i - 1] = 0;
                                continue block24;
                            }
                            case 5: {
                                nArray[i - 1] = 0;
                                continue block24;
                            }
                            case 6: {
                                nArray[i - 1] = 0;
                                continue block24;
                            }
                            case 7: {
                                nArray[i - 1] = 0;
                                continue block24;
                            }
                            case 8: {
                                nArray[i - 1] = 3;
                                continue block24;
                            }
                            case 10: {
                                nArray[i - 1] = 3;
                                continue block24;
                            }
                            default: {
                                nArray[i - 1] = 2;
                            }
                        }
                    }
                    FastVector fastVector = new FastVector();
                    block25: for (int i = 0; i < n3; ++i) {
                        string = resultSetMetaData.getColumnName(i + 1);
                        switch (nArray[i]) {
                            case 1: {
                                fastVector.addElement(new Attribute(string, this.m_nominalStrings[i]));
                                continue block25;
                            }
                            case 0: {
                                fastVector.addElement(new Attribute(string));
                                continue block25;
                            }
                            case 2: {
                                object = new Attribute(string, (FastVector)null);
                                for (n = 0; n < this.m_nominalStrings[i].size(); ++n) {
                                    ((Attribute)object).addStringValue((String)this.m_nominalStrings[i].elementAt(n));
                                }
                                fastVector.addElement(object);
                                continue block25;
                            }
                            case 3: {
                                fastVector.addElement(new Attribute(string, (String)null));
                                continue block25;
                            }
                            default: {
                                throw new IOException("Unknown attribute type");
                            }
                        }
                    }
                    this.m_structure = new Instances(this.endOfQuery(true), fastVector, 0);
                    if (this.m_DataBaseConnection.getUpperCase()) {
                        this.m_idColumn = this.m_idColumn.toUpperCase();
                    }
                    if (this.m_structure.attribute(0).name().equals(this.m_idColumn)) {
                        this.m_oldStructure = new Instances(this.m_structure, 0);
                        this.m_oldStructure.deleteAttributeAt(0);
                    } else {
                        this.m_oldStructure = new Instances(this.m_structure, 0);
                    }
                } else if (this.m_oldStructure == null) {
                    this.m_oldStructure = new Instances(this.m_structure, 0);
                }
                this.m_DataBaseConnection.disconnectFromDatabase();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.printException(exception);
            }
        }
        return this.m_oldStructure;
    }

    public Instances getDataSet() throws IOException {
        Instances instances;
        block63: {
            if (this.m_DataBaseConnection == null) {
                throw new IOException("No source database has been specified");
            }
            if (this.getRetrieval() == 2) {
                throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
            }
            this.setRetrieval(1);
            this.connectToDatabase();
            instances = null;
            try {
                int n;
                Object object;
                String string;
                Object object2;
                if (!this.m_DataBaseConnection.execute(this.m_query)) {
                    throw new Exception("Query didn't produce results");
                }
                ResultSet resultSet = this.m_DataBaseConnection.getResultSet();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                int[] nArray = new int[n2];
                this.m_nominalIndexes = new Hashtable[n2];
                this.m_nominalStrings = new FastVector[n2];
                block34: for (int i = 1; i <= n2; ++i) {
                    switch (this.m_DataBaseConnection.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                        case 0: {
                            object2 = resultSetMetaData.getColumnName(i);
                            if (this.m_DataBaseConnection.getUpperCase()) {
                                object2 = ((String)object2).toUpperCase();
                            }
                            string = this.endOfQuery(false);
                            this.m_nominalIndexes[i - 1] = new Hashtable();
                            this.m_nominalStrings[i - 1] = new FastVector();
                            if (!this.m_DataBaseConnection.execute("SELECT DISTINCT ( " + (String)object2 + " ) FROM " + string + " ORDER BY " + (String)object2)) {
                                throw new Exception("Nominal values cannot be retrieved");
                            }
                            object = this.m_DataBaseConnection.getResultSet();
                            nArray[i - 1] = 1;
                            this.stringToNominal((ResultSet)object, i);
                            object.close();
                            continue block34;
                        }
                        case 9: {
                            object2 = resultSetMetaData.getColumnName(i);
                            if (this.m_DataBaseConnection.getUpperCase()) {
                                object2 = ((String)object2).toUpperCase();
                            }
                            string = this.endOfQuery(false);
                            this.m_nominalIndexes[i - 1] = new Hashtable();
                            this.m_nominalStrings[i - 1] = new FastVector();
                            if (!this.m_DataBaseConnection.execute("SELECT DISTINCT ( " + (String)object2 + " ) FROM " + string)) {
                                throw new Exception("Nominal values cannot be retrieved");
                            }
                            object = this.m_DataBaseConnection.getResultSet();
                            nArray[i - 1] = 2;
                            this.stringToNominal((ResultSet)object, i);
                            object.close();
                            continue block34;
                        }
                        case 1: {
                            nArray[i - 1] = 1;
                            this.m_nominalIndexes[i - 1] = new Hashtable();
                            this.m_nominalIndexes[i - 1].put("false", new Double(0.0));
                            this.m_nominalIndexes[i - 1].put("true", new Double(1.0));
                            this.m_nominalStrings[i - 1] = new FastVector();
                            this.m_nominalStrings[i - 1].addElement("false");
                            this.m_nominalStrings[i - 1].addElement("true");
                            continue block34;
                        }
                        case 2: {
                            nArray[i - 1] = 0;
                            continue block34;
                        }
                        case 3: {
                            nArray[i - 1] = 0;
                            continue block34;
                        }
                        case 4: {
                            nArray[i - 1] = 0;
                            continue block34;
                        }
                        case 5: {
                            nArray[i - 1] = 0;
                            continue block34;
                        }
                        case 6: {
                            nArray[i - 1] = 0;
                            continue block34;
                        }
                        case 7: {
                            nArray[i - 1] = 0;
                            continue block34;
                        }
                        case 8: {
                            nArray[i - 1] = 3;
                            continue block34;
                        }
                        case 10: {
                            nArray[i - 1] = 3;
                            continue block34;
                        }
                        default: {
                            nArray[i - 1] = 2;
                        }
                    }
                }
                FastVector fastVector = new FastVector();
                while (resultSet.next()) {
                    object = new double[n2];
                    block36: for (int i = 1; i <= n2; ++i) {
                        switch (this.m_DataBaseConnection.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                            case 0: {
                                string = resultSet.getString(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                Double d = (Double)this.m_nominalIndexes[i - 1].get(string);
                                if (d == null) {
                                    d = new Double(this.m_structure.attribute(i - 1).addStringValue(string));
                                }
                                object[i - 1] = d;
                                continue block36;
                            }
                            case 9: {
                                string = resultSet.getString(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                Double d = (Double)this.m_nominalIndexes[i - 1].get(string);
                                if (d == null) {
                                    d = new Double(this.m_structure.attribute(i - 1).addStringValue(string));
                                }
                                object[i - 1] = d;
                                continue block36;
                            }
                            case 1: {
                                boolean bl = resultSet.getBoolean(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                object[i - 1] = bl ? 1.0 : 0.0;
                                continue block36;
                            }
                            case 2: {
                                double d = resultSet.getDouble(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                object[i - 1] = d;
                                continue block36;
                            }
                            case 3: {
                                byte by = resultSet.getByte(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                object[i - 1] = (double)by;
                                continue block36;
                            }
                            case 4: {
                                short s = resultSet.getShort(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                object[i - 1] = (double)s;
                                continue block36;
                            }
                            case 5: {
                                int n3 = resultSet.getInt(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                object[i - 1] = (double)n3;
                                continue block36;
                            }
                            case 6: {
                                long l = resultSet.getLong(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                object[i - 1] = (double)l;
                                continue block36;
                            }
                            case 7: {
                                float f = resultSet.getFloat(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                object[i - 1] = (double)f;
                                continue block36;
                            }
                            case 8: {
                                Date date = resultSet.getDate(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                object[i - 1] = (double)date.getTime();
                                continue block36;
                            }
                            case 10: {
                                Time time = resultSet.getTime(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block36;
                                }
                                object[i - 1] = (double)time.getTime();
                                continue block36;
                            }
                            default: {
                                object[i - 1] = Instance.missingValue();
                            }
                        }
                    }
                    object2 = new Instance(1.0, (double[])object);
                    fastVector.addElement(object2);
                }
                object = new FastVector();
                block37: for (n = 0; n < n2; ++n) {
                    string = resultSetMetaData.getColumnName(n + 1);
                    switch (nArray[n]) {
                        case 1: {
                            ((FastVector)object).addElement(new Attribute(string, this.m_nominalStrings[n]));
                            continue block37;
                        }
                        case 0: {
                            ((FastVector)object).addElement(new Attribute(string));
                            continue block37;
                        }
                        case 2: {
                            Attribute attribute = new Attribute(string, (FastVector)null);
                            ((FastVector)object).addElement(attribute);
                            for (int i = 0; i < this.m_nominalStrings[n].size(); ++i) {
                                attribute.addStringValue((String)this.m_nominalStrings[n].elementAt(i));
                            }
                            continue block37;
                        }
                        case 3: {
                            ((FastVector)object).addElement(new Attribute(string, (String)null));
                            continue block37;
                        }
                        default: {
                            throw new IOException("Unknown attribute type");
                        }
                    }
                }
                instances = new Instances(this.endOfQuery(true), (FastVector)object, fastVector.size());
                for (n = 0; n < fastVector.size(); ++n) {
                    instances.add((Instance)fastVector.elementAt(n));
                }
                resultSet.close();
                this.m_DataBaseConnection.disconnectFromDatabase();
                if (this.m_DataBaseConnection.getUpperCase()) {
                    this.m_idColumn = this.m_idColumn.toUpperCase();
                }
                if (instances.attribute(0).name().equals(this.m_idColumn)) {
                    instances.deleteAttributeAt(0);
                }
                this.m_structure = new Instances(instances, 0);
            }
            catch (Exception exception) {
                this.printException(exception);
                StringBuffer stringBuffer = new StringBuffer();
                if (!this.m_query.equals("Select * from Results0")) break block63;
                stringBuffer.append("\n\nDatabaseLoader options:\n");
                Enumeration enumeration = this.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    stringBuffer.append(option.synopsis() + '\n');
                    stringBuffer.append(option.description() + '\n');
                }
                System.out.println(stringBuffer);
            }
        }
        return instances;
    }

    private Instance readInstance(ResultSet resultSet) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        double[] dArray = new double[n];
        this.m_structure.delete();
        block13: for (int i = 1; i <= n; ++i) {
            switch (this.m_DataBaseConnection.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                case 0: {
                    String string = resultSet.getString(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    Double d = (Double)this.m_nominalIndexes[i - 1].get(string);
                    if (d == null) {
                        d = new Double(this.m_structure.attribute(i - 1).addStringValue(string));
                    }
                    dArray[i - 1] = d;
                    continue block13;
                }
                case 9: {
                    String string = resultSet.getString(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    Double d = (Double)this.m_nominalIndexes[i - 1].get(string);
                    if (d == null) {
                        d = new Double(this.m_structure.attribute(i - 1).addStringValue(string));
                    }
                    dArray[i - 1] = d;
                    continue block13;
                }
                case 1: {
                    boolean bl = resultSet.getBoolean(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    dArray[i - 1] = bl ? 1.0 : 0.0;
                    continue block13;
                }
                case 2: {
                    double d = resultSet.getDouble(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    dArray[i - 1] = d;
                    continue block13;
                }
                case 3: {
                    byte by = resultSet.getByte(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    dArray[i - 1] = by;
                    continue block13;
                }
                case 4: {
                    short s = resultSet.getShort(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    dArray[i - 1] = s;
                    continue block13;
                }
                case 5: {
                    int n2 = resultSet.getInt(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    dArray[i - 1] = n2;
                    continue block13;
                }
                case 6: {
                    long l = resultSet.getLong(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    dArray[i - 1] = l;
                    continue block13;
                }
                case 7: {
                    float f = resultSet.getFloat(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    dArray[i - 1] = f;
                    continue block13;
                }
                case 8: {
                    Date date = resultSet.getDate(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    dArray[i - 1] = date.getTime();
                    continue block13;
                }
                case 10: {
                    Time time = resultSet.getTime(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block13;
                    }
                    dArray[i - 1] = time.getTime();
                    continue block13;
                }
                default: {
                    dArray[i - 1] = Instance.missingValue();
                }
            }
        }
        Instance instance = new Instance(1.0, dArray);
        if (this.m_DataBaseConnection.getUpperCase()) {
            this.m_idColumn = this.m_idColumn.toUpperCase();
        }
        if (this.m_structure.attribute(0).name().equals(this.m_idColumn)) {
            instance.deleteAttributeAt(0);
            this.m_oldStructure.add(instance);
            instance = this.m_oldStructure.instance(0);
            this.m_oldStructure.delete(0);
        } else {
            this.m_structure.add(instance);
            instance = this.m_structure.instance(0);
            this.m_structure.delete(0);
        }
        return instance;
    }

    public Instance getNextInstance(Instances instances) throws IOException {
        this.m_structure = instances;
        if (this.m_DataBaseConnection == null) {
            throw new IOException("No source database has been specified");
        }
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        if (this.m_pseudoIncremental) {
            this.setRetrieval(2);
            if (this.m_datasetPseudoInc.numInstances() > 0) {
                Instance instance = this.m_datasetPseudoInc.instance(0);
                this.m_datasetPseudoInc.delete(0);
                return instance;
            }
            this.resetStructure();
            return null;
        }
        this.setRetrieval(2);
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.connectToDatabase();
            }
            if (this.m_firstTime && this.m_orderBy.size() == 0 && !this.checkForKey()) {
                throw new Exception("A unique order cannot be detected automatically.\nYou have to use SELECT * in your query to enable this feature.\nMaybe JDBC driver is not able to detect key.\nDefine primary key in your database or use -P option (command line) or enter key columns in the GUI.");
            }
            if (this.m_firstTime) {
                this.m_firstTime = false;
                this.m_rowCount = this.getRowCount();
            }
            if (this.m_counter < this.m_rowCount) {
                if (!this.m_DataBaseConnection.execute(this.limitQuery(this.m_query, this.m_counter, this.m_choice))) {
                    throw new Exception("Tuple could not be retrieved.");
                }
                ++this.m_counter;
                ResultSet resultSet = this.m_DataBaseConnection.getResultSet();
                resultSet.next();
                Instance instance = this.readInstance(resultSet);
                resultSet.close();
                return instance;
            }
            this.m_DataBaseConnection.disconnectFromDatabase();
            this.resetStructure();
            return null;
        }
        catch (Exception exception) {
            this.printException(exception);
            return null;
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getUrl() != null && this.getUrl().length() != 0) {
            vector.add("-url");
            vector.add(this.getUrl());
        }
        if (this.getUser() != null && this.getUser().length() != 0) {
            vector.add("-user");
            vector.add(this.getUser());
        }
        if (this.getPassword() != null && this.getPassword().length() != 0) {
            vector.add("-password");
            vector.add(this.getPassword());
        }
        vector.add("-Q");
        vector.add(this.getQuery());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_orderBy.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)this.m_orderBy.elementAt(i));
        }
        vector.add("-P");
        vector.add(stringBuffer.toString());
        if (this.m_inc) {
            vector.add("-I");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Enumeration listOptions() {
        FastVector fastVector = new FastVector();
        fastVector.addElement(new Option("\tThe JDBC URL to connect to.\n\t(default: from DatabaseUtils.props file)", "url", 1, "-url <JDBC URL>"));
        fastVector.addElement(new Option("\tThe user to connect with to the database.\n\t(default: none)", "user", 1, "-user <name>"));
        fastVector.addElement(new Option("\tThe password to connect with to the database.\n\t(default: none)", "password", 1, "-password <password>"));
        fastVector.addElement(new Option("\tSQL query of the form\n\t\tSELECT <list of columns>|* FROM <table> [WHERE]\n\tto execute.\n\t(default: Select * From Results0)", "Q", 1, "-Q <query>"));
        fastVector.addElement(new Option("\tList of column names uniquely defining a DB row\n\t(separated by ', ').\n\tUsed for incremental loading.\n\tIf not specified, the key will be determined automatically,\n\tif possible with the used JDBC driver.\n\tThe auto ID column created by the DatabaseSaver won't be loaded.", "P", 1, "-P <list of column names>"));
        fastVector.addElement(new Option("\tSets incremental loading", "I", 0, "-I"));
        return fastVector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('Q', stringArray);
        String string2 = Utils.getOption('P', stringArray);
        this.reset();
        String string3 = Utils.getOption("url", stringArray);
        if (string3.length() != 0) {
            this.setUrl(string3);
        }
        if ((string3 = Utils.getOption("user", stringArray)).length() != 0) {
            this.setUser(string3);
        }
        if ((string3 = Utils.getOption("password", stringArray)).length() != 0) {
            this.setPassword(string3);
        }
        if (string.length() != 0) {
            this.setQuery(string);
        }
        this.m_orderBy.removeAllElements();
        this.m_inc = Utils.getFlag('I', stringArray);
        if (this.m_inc) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                string4 = string4.replaceAll(" ", "");
                this.m_orderBy.addElement(string4);
            }
        }
    }

    private void printException(Exception exception) {
        System.out.println("\n--- Exception caught ---\n");
        while (exception != null) {
            System.out.println("Message:   " + exception.getMessage());
            if (exception instanceof SQLException) {
                System.out.println("SQLState:  " + ((SQLException)exception).getSQLState());
                System.out.println("ErrorCode: " + ((SQLException)exception).getErrorCode());
                exception = ((SQLException)exception).getNextException();
            } else {
                exception = null;
            }
            System.out.println("");
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.16 $");
    }

    public static void main(String[] stringArray) {
        try {
            DatabaseLoader databaseLoader = new DatabaseLoader();
            databaseLoader.setOptions(stringArray);
            databaseLoader.setSource(databaseLoader.getUrl(), databaseLoader.getUser(), databaseLoader.getPassword());
            if (!databaseLoader.m_inc) {
                System.out.println(databaseLoader.getDataSet());
            } else {
                Instance instance;
                Instances instances = databaseLoader.getStructure();
                System.out.println(instances);
                do {
                    if ((instance = databaseLoader.getNextInstance(instances)) == null) continue;
                    System.out.println(instance);
                } while (instance != null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\n" + exception.getMessage());
        }
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception exception) {
            System.err.println("Problem reading properties. Fix before continuing.");
            System.err.println(exception);
        }
    }
}

