/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class StringKernel
extends Kernel
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -4902954211202690123L;
    private int m_cacheSize = 250007;
    private int m_internalCacheSize = 200003;
    private int m_strAttr;
    private double[] m_storage;
    private long[] m_keys;
    private int m_kernelEvals;
    private int m_numInsts;
    public static final int PRUNING_NONE = 0;
    public static final int PRUNING_LAMBDA = 1;
    public static final Tag[] TAGS_PRUNING = new Tag[]{new Tag(0, "No pruning"), new Tag(1, "Lambda pruning")};
    protected int m_PruningMethod = 0;
    protected double m_lambda = 0.5;
    private int m_subsequenceLength = 3;
    private int m_maxSubsequenceLength = 9;
    protected static final int MAX_POWER_OF_LAMBDA = 10000;
    protected double[] m_powersOflambda = null;
    private boolean m_normalize = false;
    private int maxCache;
    private double[] cachekh;
    private int[] cachekhK;
    private double[] cachekh2;
    private int[] cachekh2K;
    private int m_multX;
    private int m_multY;
    private int m_multZ;
    private int m_multZZ;
    private boolean m_useRecursionCache = true;

    public StringKernel() {
    }

    public StringKernel(Instances instances, int n, int n2, double d, boolean bl) throws Exception {
        this.setDebug(bl);
        this.setCacheSize(n);
        this.setInternalCacheSize(200003);
        this.setSubsequenceLength(n2);
        this.setMaxSubsequenceLength(-1);
        this.setLambda(d);
        this.buildKernel(instances);
    }

    public String globalInfo() {
        return "Implementation of the subsequence kernel (SSK) as described in [1] and of the subsequence kernel with lambda pruning (SSK-LP) as described in [2].\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Huma Lodhi and Craig Saunders and John Shawe-Taylor and Nello Cristianini and Christopher J. C. H. Watkins");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2002");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Text Classification using String Kernels");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Journal of Machine Learning Research");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "2");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "419-444");
        technicalInformation.setValue(TechnicalInformation.Field.HTTP, "http://www.jmlr.org/papers/v2/lodhi02a.html");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.TECHREPORT);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "F. Kleedorfer and A. Seewald");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Implementation of a String Kernel for WEKA");
        technicalInformation2.setValue(TechnicalInformation.Field.INSTITUTION, "Oesterreichisches Forschungsinstitut fuer Artificial Intelligence");
        technicalInformation2.setValue(TechnicalInformation.Field.ADDRESS, "Wien, Austria");
        technicalInformation2.setValue(TechnicalInformation.Field.NUMBER, "TR-2005-13");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        String string = "";
        String string2 = "";
        for (int i = 0; i < TAGS_PRUNING.length; ++i) {
            if (i > 0) {
                string2 = string2 + "|";
            }
            SelectedTag selectedTag = new SelectedTag(TAGS_PRUNING[i].getID(), TAGS_PRUNING);
            string2 = string2 + "" + selectedTag.getSelectedTag().getID();
            string = string + "\t" + selectedTag.getSelectedTag().getID() + " = " + selectedTag.getSelectedTag().getReadable() + "\n";
        }
        vector.addElement(new Option("\tThe pruning method to use:\n" + string + "\t(default: " + 0 + ")", "P", 1, "-P <" + string2 + ">"));
        vector.addElement(new Option("\tThe size of the cache (a prime number).\n\t(default: 250007)", "C", 1, "-C <num>"));
        vector.addElement(new Option("\tThe size of the internal cache (a prime number).\n\t(default: 200003)", "IC", 1, "-IC <num>"));
        vector.addElement(new Option("\tThe lambda constant. Penalizes non-continuous subsequence\n\tmatches. Must be in (0,1).\n\t(default: 0.5)", "L", 1, "-L <num>"));
        vector.addElement(new Option("\tThe length of the subsequence.\n\t(default: 3)", "ssl", 1, "-ssl <num>"));
        vector.addElement(new Option("\tThe maximum length of the subsequence.\n\t(default: 9)", "ssl-max", 1, "-ssl-max <num>"));
        vector.addElement(new Option("\tUse normalization.\n\t(default: no)", "N", 0, "-N"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setPruningMethod(new SelectedTag(Integer.parseInt(string), TAGS_PRUNING));
        } else {
            this.setPruningMethod(new SelectedTag(0, TAGS_PRUNING));
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setCacheSize(Integer.parseInt(string));
        } else {
            this.setCacheSize(250007);
        }
        string = Utils.getOption("IC", stringArray);
        if (string.length() != 0) {
            this.setInternalCacheSize(Integer.parseInt(string));
        } else {
            this.setInternalCacheSize(200003);
        }
        string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setLambda(Double.parseDouble(string));
        } else {
            this.setLambda(0.5);
        }
        string = Utils.getOption("ssl", stringArray);
        if (string.length() != 0) {
            this.setSubsequenceLength(Integer.parseInt(string));
        } else {
            this.setSubsequenceLength(3);
        }
        string = Utils.getOption("ssl-max", stringArray);
        if (string.length() != 0) {
            this.setMaxSubsequenceLength(Integer.parseInt(string));
        } else {
            this.setMaxSubsequenceLength(9);
        }
        this.setUseNormalization(Utils.getFlag('N', stringArray));
        if (this.getMaxSubsequenceLength() < 2 * this.getSubsequenceLength()) {
            throw new IllegalArgumentException("Lambda Pruning forbids even contiguous substring matches! Use a bigger value for ssl-max (at least 2*ssl).");
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-P");
        vector.add("" + this.m_PruningMethod);
        vector.add("-C");
        vector.add("" + this.getCacheSize());
        vector.add("-IC");
        vector.add("" + this.getInternalCacheSize());
        vector.add("-L");
        vector.add("" + this.getLambda());
        vector.add("-ssl");
        vector.add("" + this.getSubsequenceLength());
        vector.add("-ssl-max");
        vector.add("" + this.getMaxSubsequenceLength());
        if (this.getUseNormalization()) {
            vector.add("-L");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String pruningMethodTipText() {
        return "The pruning method.";
    }

    public void setPruningMethod(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_PRUNING) {
            this.m_PruningMethod = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getPruningMethod() {
        return new SelectedTag(this.m_PruningMethod, TAGS_PRUNING);
    }

    public void setCacheSize(int n) {
        if (n >= 0) {
            this.m_cacheSize = n;
            this.clean();
        } else {
            System.out.println("Cache size cannot be smaller than 0 (provided: " + n + ")!");
        }
    }

    public int getCacheSize() {
        return this.m_cacheSize;
    }

    public String cacheSizeTipText() {
        return "The size of the cache (a prime number).";
    }

    public void setInternalCacheSize(int n) {
        if (n >= 0) {
            this.m_internalCacheSize = n;
            this.clean();
        } else {
            System.out.println("Cache size cannot be smaller than 0 (provided: " + n + ")!");
        }
    }

    public int getInternalCacheSize() {
        return this.m_internalCacheSize;
    }

    public String internalCacheSizeTipText() {
        return "The size of the internal cache (a prime number).";
    }

    public void setSubsequenceLength(int n) {
        this.m_subsequenceLength = n;
    }

    public int getSubsequenceLength() {
        return this.m_subsequenceLength;
    }

    public String subsequenceLengthTipText() {
        return "The subsequence length.";
    }

    public void setMaxSubsequenceLength(int n) {
        this.m_maxSubsequenceLength = n;
    }

    public int getMaxSubsequenceLength() {
        return this.m_maxSubsequenceLength;
    }

    public String maxSubsequenceLengthTipText() {
        return "The maximum subsequence length (theta in the paper)";
    }

    public void setLambda(double d) {
        this.m_lambda = d;
    }

    public double getLambda() {
        return this.m_lambda;
    }

    public String lambdaTipText() {
        return "Penalizes non-continuous subsequence matches, from (0,1)";
    }

    public void setUseNormalization(boolean bl) {
        if (bl != this.m_normalize) {
            this.clean();
        }
        this.m_normalize = bl;
    }

    public boolean getUseNormalization() {
        return this.m_normalize;
    }

    public String useNormalizationTipText() {
        return "Whether to use normalization.";
    }

    public double eval(int n, int n2, Instance instance) throws Exception {
        if (this.m_Debug && n > -1 && n2 > -1) {
            System.err.println("\nEvaluation of string kernel for");
            System.err.println(this.m_data.instance(n).stringValue(this.m_strAttr));
            System.err.println("and");
            System.err.println(this.m_data.instance(n2).stringValue(this.m_strAttr));
        }
        if (n == n2 && this.m_normalize) {
            return 1.0;
        }
        double d = 0.0;
        long l = -1L;
        int n3 = -1;
        if (n >= 0 && this.m_keys != null) {
            l = n > n2 ? (long)n * (long)this.m_numInsts + (long)n2 : (long)n2 * (long)this.m_numInsts + (long)n;
            if (l < 0L) {
                throw new Exception("Cache overflow detected!");
            }
            n3 = (int)(l % (long)this.m_keys.length);
            if (this.m_keys[n3] == l + 1L) {
                if (this.m_Debug) {
                    System.err.println("result (cached): " + this.m_storage[n3]);
                }
                return this.m_storage[n3];
            }
        }
        ++this.m_kernelEvals;
        long l2 = System.currentTimeMillis();
        Instance instance2 = this.m_data.instance(n2);
        char[] cArray = instance.stringValue(this.m_strAttr).toCharArray();
        char[] cArray2 = instance2.stringValue(this.m_strAttr).toCharArray();
        if (cArray.length == 0 || cArray2.length == 0) {
            return 0.0;
        }
        d = this.m_normalize ? this.normalizedKernel(cArray, cArray2) : this.unnormalizedKernel(cArray, cArray2);
        if (this.m_Debug) {
            long l3 = System.currentTimeMillis() - l2;
            System.err.println("result: " + d);
            System.err.println("evaluation time:" + l3 + "\n");
        }
        if (l != -1L) {
            this.m_storage[n3] = d;
            this.m_keys[n3] = l + 1L;
        }
        return d;
    }

    public void clean() {
        this.m_storage = null;
        this.m_keys = null;
    }

    public int numEvals() {
        return this.m_kernelEvals;
    }

    public int numCacheHits() {
        return -1;
    }

    public double normalizedKernel(char[] cArray, char[] cArray2) {
        double d = this.unnormalizedKernel(cArray, cArray);
        double d2 = this.unnormalizedKernel(cArray2, cArray2);
        double d3 = Math.sqrt(d * d2);
        return this.unnormalizedKernel(cArray, cArray2) / d3;
    }

    public double unnormalizedKernel(char[] cArray, char[] cArray2) {
        if (cArray2.length > cArray.length) {
            char[] cArray3 = cArray;
            cArray = cArray2;
            cArray2 = cArray3;
        }
        if (this.m_PruningMethod == 0) {
            this.m_multX = (cArray.length + 1) * (cArray2.length + 1);
            this.m_multY = cArray2.length + 1;
            this.m_multZ = 1;
            this.maxCache = this.m_internalCacheSize;
            if (this.maxCache == 0) {
                this.maxCache = (this.m_subsequenceLength + 1) * this.m_multX;
            } else if ((this.m_subsequenceLength + 1) * this.m_multX < this.maxCache) {
                this.maxCache = (this.m_subsequenceLength + 1) * this.m_multX;
            }
            this.m_useRecursionCache = true;
            this.cachekhK = new int[this.maxCache];
            this.cachekh2K = new int[this.maxCache];
            this.cachekh = new double[this.maxCache];
            this.cachekh2 = new double[this.maxCache];
        } else if (this.m_PruningMethod == 1) {
            this.maxCache = 0;
            this.m_useRecursionCache = false;
        }
        double d = this.m_PruningMethod == 1 ? this.kernelLP(this.m_subsequenceLength, cArray, cArray.length - 1, cArray2, cArray2.length - 1, this.m_maxSubsequenceLength) : this.kernel(this.m_subsequenceLength, cArray, cArray.length - 1, cArray2, cArray2.length - 1);
        this.cachekh = null;
        this.cachekhK = null;
        this.cachekh2 = null;
        this.cachekh2K = null;
        return d;
    }

    protected double getReturnValue(int n) {
        if (n == 0) {
            return 1.0;
        }
        return 0.0;
    }

    protected double kernel(int n, char[] cArray, int n2, char[] cArray2, int n3) {
        if (Math.min(n2 + 1, n3 + 1) < n) {
            return this.getReturnValue(n);
        }
        double d = 0.0;
        for (int i = n2; i > n - 2; --i) {
            double d2 = 0.0;
            char c = cArray[i];
            for (int j = 0; j <= n3; ++j) {
                if (cArray2[j] != c) continue;
                d2 += this.kernelHelper(n - 1, cArray, i - 1, cArray2, j - 1);
            }
            d += d2 * this.m_powersOflambda[2];
        }
        return d;
    }

    protected double kernelHelper(int n, char[] cArray, int n2, char[] cArray2, int n3) {
        if (n <= 0) {
            return this.getReturnValue(n);
        }
        if (Math.min(n2 + 1, n3 + 1) < n) {
            return this.getReturnValue(n);
        }
        int n4 = 0;
        if (this.m_useRecursionCache && this.cachekhK[(n4 = this.m_multX * n + this.m_multY * n2 + this.m_multZ * n3) % this.maxCache] == n4 + 1) {
            return this.cachekh[n4 % this.maxCache];
        }
        double d = 0.0;
        d = this.m_lambda * this.kernelHelper(n, cArray, n2 - 1, cArray2, n3) + this.kernelHelper2(n, cArray, n2, cArray2, n3);
        if (this.m_useRecursionCache) {
            this.cachekhK[n4 % this.maxCache] = n4 + 1;
            this.cachekh[n4 % this.maxCache] = d;
        }
        return d;
    }

    protected double kernelHelper2(int n, char[] cArray, int n2, char[] cArray2, int n3) {
        if (n2 < 0 || n3 < 0) {
            return this.getReturnValue(n);
        }
        int n4 = 0;
        if (this.m_useRecursionCache && this.cachekh2K[(n4 = this.m_multX * n + this.m_multY * n2 + this.m_multZ * n3) % this.maxCache] == n4 + 1) {
            return this.cachekh2[n4 % this.maxCache];
        }
        char c = cArray[n2];
        if (c == cArray2[n3]) {
            double d = this.m_lambda * (this.kernelHelper2(n, cArray, n2, cArray2, n3 - 1) + this.m_lambda * this.kernelHelper(n - 1, cArray, n2 - 1, cArray2, n3 - 1));
            if (this.m_useRecursionCache) {
                this.cachekh2K[n4 % this.maxCache] = n4 + 1;
                this.cachekh2[n4 % this.maxCache] = d;
            }
            return d;
        }
        double d = this.m_lambda * this.kernelHelper2(n, cArray, n2, cArray2, n3 - 1);
        if (this.m_useRecursionCache) {
            this.cachekh2K[n4 % this.maxCache] = n4 + 1;
            this.cachekh2[n4 % this.maxCache] = d;
        }
        return d;
    }

    protected double kernelLP(int n, char[] cArray, int n2, char[] cArray2, int n3, int n4) {
        if (Math.min(n2 + 1, n3 + 1) < n) {
            return this.getReturnValue(n);
        }
        if (n4 == 0) {
            return this.getReturnValue(n);
        }
        double d = 0.0;
        for (int i = n2; i > n - 2; --i) {
            double d2 = 0.0;
            char c = cArray[i];
            for (int j = 0; j <= n3; ++j) {
                if (cArray2[j] != c) continue;
                d2 += this.kernelHelperLP(n - 1, cArray, i - 1, cArray2, j - 1, n4 - 2);
            }
            d += d2 * this.m_powersOflambda[2];
        }
        return d;
    }

    protected double kernelHelperLP(int n, char[] cArray, int n2, char[] cArray2, int n3, int n4) {
        if (n == 0) {
            return this.getReturnValue(n);
        }
        if (Math.min(n2 + 1, n3 + 1) < n) {
            return this.getReturnValue(n);
        }
        if (n4 < 2 * n) {
            return this.getReturnValue(n);
        }
        int n5 = 0;
        if (this.m_useRecursionCache && this.cachekh2K[(n5 = this.m_multX * n + this.m_multY * n2 + this.m_multZ * n3 + this.m_multZZ * n4) % this.maxCache] == n5 + 1) {
            return this.cachekh2[n5 % this.maxCache];
        }
        int n6 = 0;
        double d = 0.0;
        for (int i = n2 - n4; i <= n2; ++i) {
            d *= this.m_lambda;
            d += this.kernelHelper2LP(n, cArray, i, cArray2, n3, n6++);
        }
        if (this.m_useRecursionCache && n2 >= 0 && n3 >= 0 && n >= 0) {
            this.cachekhK[n5 % this.maxCache] = n5 + 1;
            this.cachekh[n5 % this.maxCache] = d;
        }
        return d;
    }

    protected double kernelHelper2LP(int n, char[] cArray, int n2, char[] cArray2, int n3, int n4) {
        if (n4 < 2 * n) {
            return this.getReturnValue(n);
        }
        if (n2 < 0 || n3 < 0) {
            return this.getReturnValue(n);
        }
        int n5 = 0;
        if (this.m_useRecursionCache && this.cachekh2K[(n5 = this.m_multX * n + this.m_multY * n2 + this.m_multZ * n3 + this.m_multZZ * n4) % this.maxCache] == n5 + 1) {
            return this.cachekh2[n5 % this.maxCache];
        }
        char c = cArray[n2];
        if (c == cArray2[n3]) {
            double d = this.m_lambda * (this.kernelHelper2LP(n, cArray, n2, cArray2, n3 - 1, n4 - 1) + this.m_lambda * this.kernelHelperLP(n - 1, cArray, n2 - 1, cArray2, n3 - 1, n4 - 2));
            if (this.m_useRecursionCache && n2 >= 0 && n3 >= 0 && n >= 0) {
                this.cachekh2K[n5 % this.maxCache] = n5 + 1;
                this.cachekh2[n5 % this.maxCache] = d;
            }
            return d;
        }
        int n6 = n3 - n4;
        if (n6 < 0) {
            n6 = 0;
        }
        for (int i = n3; i >= n6; --i) {
            if (c != cArray2[i]) continue;
            int n7 = n3 - i;
            double d = this.getPowerOfLambda(n7) * this.kernelHelper2LP(n, cArray, n2, cArray2, i, n4 - n7);
            if (this.m_useRecursionCache && n2 >= 0 && n3 >= 0 && n >= 0) {
                this.cachekh2K[n5 % this.maxCache] = n5 + 1;
                this.cachekh2[n5 % this.maxCache] = d;
            }
            return d;
        }
        double d = this.getReturnValue(n);
        if (this.m_useRecursionCache && n2 >= 0 && n3 >= 0 && n >= 0) {
            this.cachekh2K[n5 % this.maxCache] = n5 + 1;
            this.cachekh2[n5 % this.maxCache] = d;
        }
        return d;
    }

    private double[] calculatePowersOfLambda() {
        double[] dArray = new double[10001];
        dArray[0] = 1.0;
        double d = 1.0;
        for (int i = 1; i <= 10000; ++i) {
            dArray[i] = d *= this.m_lambda;
        }
        return dArray;
    }

    private double getPowerOfLambda(int n) {
        if (n > 10000) {
            return Math.pow(this.m_lambda, n);
        }
        if (n < 0) {
            throw new IllegalArgumentException("only positive powers of lambda may be computed");
        }
        return this.m_powersOflambda[n];
    }

    protected void initVars(Instances instances) {
        super.initVars(instances);
        this.m_kernelEvals = 0;
        this.m_strAttr = -1;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex() || instances.attribute(i).type() != 2) continue;
            this.m_strAttr = i;
            break;
        }
        this.m_numInsts = this.m_data.numInstances();
        this.m_storage = new double[this.m_cacheSize];
        this.m_keys = new long[this.m_cacheSize];
        this.m_powersOflambda = this.calculatePowersOfLambda();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildKernel(Instances instances) throws Exception {
        super.buildKernel(instances);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4557 $");
    }
}

