/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.RevisionUtils;
import weka.estimators.ConditionalEstimator;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;

public class DDConditionalEstimator
implements ConditionalEstimator {
    private DiscreteEstimator[] m_Estimators;

    public DDConditionalEstimator(int n, int n2, boolean bl) {
        this.m_Estimators = new DiscreteEstimator[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_Estimators[i] = new DiscreteEstimator(n, bl);
        }
    }

    public void addValue(double d, double d2, double d3) {
        this.m_Estimators[(int)d2].addValue(d, d3);
    }

    public Estimator getEstimator(double d) {
        return this.m_Estimators[(int)d];
    }

    public double getProbability(double d, double d2) {
        return this.getEstimator(d2).getProbability(d);
    }

    public String toString() {
        String string = "DD Conditional Estimator. " + this.m_Estimators.length + " sub-estimators:\n";
        for (int i = 0; i < this.m_Estimators.length; ++i) {
            string = string + "Sub-estimator " + i + ": " + this.m_Estimators[i];
        }
        return string;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            if (stringArray.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int n3 = n2 = Integer.parseInt(stringArray[0]);
            int n4 = n = Integer.parseInt(stringArray[1]);
            for (int i = 2; i < stringArray.length - 1; i += 2) {
                n2 = Integer.parseInt(stringArray[i]);
                n = Integer.parseInt(stringArray[i + 1]);
                if (n2 > n3) {
                    n3 = n2;
                }
                if (n <= n4) continue;
                n4 = n;
            }
            DDConditionalEstimator dDConditionalEstimator = new DDConditionalEstimator(n3 + 1, n4 + 1, true);
            for (int i = 0; i < stringArray.length - 1; i += 2) {
                n2 = Integer.parseInt(stringArray[i]);
                n = Integer.parseInt(stringArray[i + 1]);
                System.out.println(dDConditionalEstimator);
                System.out.println("Prediction for " + n2 + '|' + n + " = " + dDConditionalEstimator.getProbability(n2, n));
                dDConditionalEstimator.addValue(n2, n, 1.0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

