/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallTreeConstructor;

public class BottomUpConstructor
extends BallTreeConstructor
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5864250777657707687L;

    public String globalInfo() {
        return "The class that constructs a ball tree bottom up.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Stephen M. Omohundro");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1989");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Five Balltree Construction Algorithms");
        technicalInformation.setValue(TechnicalInformation.Field.MONTH, "December");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "TR-89-063");
        technicalInformation.setValue(TechnicalInformation.Field.INSTITUTION, "International Computer Science Institute");
        return technicalInformation;
    }

    public BallNode buildTree() throws Exception {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < this.m_InstList.length; ++i) {
            TempNode tempNode = new TempNode();
            tempNode.points = new int[1];
            tempNode.points[0] = this.m_InstList[i];
            tempNode.anchor = this.m_Instances.instance(this.m_InstList[i]);
            tempNode.radius = 0.0;
            fastVector.addElement(tempNode);
        }
        return this.mergeNodes(fastVector, 0, this.m_InstList.length - 1, this.m_InstList);
    }

    protected BallNode mergeNodes(FastVector fastVector, int n, int n2, int[] nArray) throws Exception {
        double d;
        RevisionHandler revisionHandler;
        double d2 = Double.POSITIVE_INFINITY;
        Instance instance = null;
        int n3 = -1;
        int n4 = -1;
        int[] nArray2 = null;
        int n5 = 1;
        while (fastVector.size() > 1) {
            System.err.print("merge step: " + n5++ + "               \r");
            d2 = Double.POSITIVE_INFINITY;
            n3 = -1;
            n4 = -1;
            for (int i = 0; i < fastVector.size(); ++i) {
                revisionHandler = (TempNode)fastVector.elementAt(i);
                for (int j = i + 1; j < fastVector.size(); ++j) {
                    TempNode tempNode = (TempNode)fastVector.elementAt(j);
                    Instance instance2 = this.calcPivot((TempNode)revisionHandler, tempNode, this.m_Instances);
                    d = this.calcRadius((TempNode)revisionHandler, tempNode);
                    if (!(d < d2)) continue;
                    d2 = d;
                    n3 = i;
                    n4 = j;
                    instance = instance2;
                }
            }
            TempNode tempNode = new TempNode();
            tempNode.left = (TempNode)fastVector.elementAt(n3);
            tempNode.right = (TempNode)fastVector.elementAt(n4);
            nArray2 = new int[tempNode.left.points.length + tempNode.right.points.length];
            System.arraycopy(tempNode.left.points, 0, nArray2, 0, tempNode.left.points.length);
            System.arraycopy(tempNode.right.points, 0, nArray2, tempNode.left.points.length, tempNode.right.points.length);
            tempNode.points = nArray2;
            tempNode.anchor = instance;
            tempNode.radius = BallNode.calcRadius(tempNode.points, this.m_Instances, instance, this.m_DistanceFunction);
            fastVector.removeElementAt(n3);
            fastVector.removeElementAt(n4 - 1);
            fastVector.addElement(tempNode);
        }
        System.err.println("");
        TempNode tempNode = (TempNode)fastVector.elementAt(0);
        if (this.m_InstList.length != tempNode.points.length) {
            throw new Exception("Root nodes instance list is of irregular length. Please check code.");
        }
        System.arraycopy(tempNode.points, 0, this.m_InstList, 0, tempNode.points.length);
        this.m_NumLeaves = 0;
        this.m_MaxDepth = 0;
        this.m_NumNodes = 0;
        d = BallNode.calcRadius(nArray, this.m_Instances, tempNode.anchor, this.m_DistanceFunction);
        revisionHandler = this.makeBallTree(tempNode, n, n2, nArray, 0, d);
        return revisionHandler;
    }

    protected BallNode makeBallTree(TempNode tempNode, int n, int n2, int[] nArray, int n3, double d) throws Exception {
        BallNode ballNode = null;
        if (this.m_MaxDepth < n3) {
            this.m_MaxDepth = n3;
        }
        if (tempNode.points.length > this.m_MaxInstancesInLeaf && d != 0.0 && tempNode.radius / d >= this.m_MaxRelLeafRadius && tempNode.left != null && tempNode.right != null) {
            Instance instance = BallNode.calcCentroidPivot(n, n2, nArray, this.m_Instances);
            ballNode = new BallNode(n, n2, this.m_NumNodes, instance, BallNode.calcRadius(n, n2, nArray, this.m_Instances, instance, this.m_DistanceFunction));
            ++this.m_NumNodes;
            ballNode.m_Left = this.makeBallTree(tempNode.left, n, n + tempNode.left.points.length - 1, nArray, n3 + 1, d);
            ballNode.m_Right = this.makeBallTree(tempNode.right, n + tempNode.left.points.length, n2, nArray, n3 + 1, d);
        } else {
            Instance instance = BallNode.calcCentroidPivot(n, n2, nArray, this.m_Instances);
            ballNode = new BallNode(n, n2, this.m_NumNodes, instance, BallNode.calcRadius(n, n2, nArray, this.m_Instances, instance, this.m_DistanceFunction));
            ++this.m_NumNodes;
            ++this.m_NumLeaves;
        }
        return ballNode;
    }

    public int[] addInstance(BallNode ballNode, Instance instance) throws Exception {
        throw new Exception("BottomUpConstruction method does not allow addition of new Instances.");
    }

    public Instance calcPivot(TempNode tempNode, TempNode tempNode2, Instances instances) throws Exception {
        int n;
        int n2 = this.m_Instances.classIndex();
        double[] dArray = new double[instances.numAttributes()];
        double d = (double)tempNode.points.length / (double)(tempNode.points.length + tempNode2.points.length);
        double d2 = (double)tempNode2.points.length / (double)(tempNode.points.length + tempNode2.points.length);
        for (n = 0; n < tempNode.anchor.numValues(); ++n) {
            if (tempNode.anchor.index(n) == n2) continue;
            int n3 = n;
            dArray[n3] = dArray[n3] + tempNode.anchor.valueSparse(n) * d;
        }
        for (n = 0; n < tempNode2.anchor.numValues(); ++n) {
            if (tempNode2.anchor.index(n) == n2) continue;
            int n4 = n;
            dArray[n4] = dArray[n4] + tempNode2.anchor.valueSparse(n) * d2;
        }
        Instance instance = new Instance(1.0, dArray);
        return instance;
    }

    public double calcRadius(TempNode tempNode, TempNode tempNode2) throws Exception {
        Instance instance = tempNode.anchor;
        Instance instance2 = tempNode2.anchor;
        double d = tempNode.radius + this.m_DistanceFunction.distance(instance, instance2) + tempNode2.radius;
        return d / 2.0;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }

    protected class TempNode
    implements RevisionHandler {
        Instance anchor;
        double radius;
        int[] points;
        TempNode left = null;
        TempNode right = null;

        protected TempNode() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("p: ");
            for (int i = 0; i < this.points.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", " + this.points[i]);
                    continue;
                }
                stringBuffer.append("" + this.points[i]);
            }
            return stringBuffer.toString();
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.3 $");
        }
    }
}

