/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.RandomizableClusterer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class FarthestFirst
extends RandomizableClusterer
implements TechnicalInformationHandler {
    static final long serialVersionUID = 7499838100631329509L;
    protected Instances m_instances;
    protected ReplaceMissingValues m_ReplaceMissingFilter;
    protected int m_NumClusters = 2;
    protected Instances m_ClusterCentroids;
    private double[] m_Min;
    private double[] m_Max;

    public String globalInfo() {
        return "Cluster data using the FarthestFirst algorithm.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "Notes:\n" + "- works as a fast simple approximate clusterer\n" + "- modelled after SimpleKMeans, might be a useful initializer for it";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Hochbaum and Shmoys");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1985");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A best possible heuristic for the k-center problem");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Mathematics of Operations Research");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "10");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "2");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "180-184");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Sanjoy Dasgupta");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Performance Guarantees for Hierarchical Clustering");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "15th Annual Conference on Computational Learning Theory");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2002");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "351-363");
        technicalInformation2.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        return capabilities;
    }

    public void buildClusterer(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        this.m_ReplaceMissingFilter.setInputFormat(instances);
        this.m_instances = Filter.useFilter(instances, this.m_ReplaceMissingFilter);
        this.initMinMax(this.m_instances);
        this.m_ClusterCentroids = new Instances(this.m_instances, this.m_NumClusters);
        int n2 = this.m_instances.numInstances();
        Random random = new Random(this.getSeed());
        boolean[] blArray = new boolean[n2];
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = Double.MAX_VALUE;
        }
        n = random.nextInt(n2);
        this.m_ClusterCentroids.add(this.m_instances.instance(n));
        blArray[n] = true;
        this.updateMinDistance(dArray, blArray, this.m_instances, this.m_instances.instance(n));
        if (this.m_NumClusters > n2) {
            this.m_NumClusters = n2;
        }
        for (int i = 1; i < this.m_NumClusters; ++i) {
            int n3 = this.farthestAway(dArray, blArray);
            this.m_ClusterCentroids.add(this.m_instances.instance(n3));
            blArray[n3] = true;
            this.updateMinDistance(dArray, blArray, this.m_instances, this.m_instances.instance(n3));
        }
        this.m_instances = new Instances(this.m_instances, 0);
    }

    protected void updateMinDistance(double[] dArray, boolean[] blArray, Instances instances, Instance instance) {
        for (int i = 0; i < blArray.length; ++i) {
            double d;
            if (blArray[i] || !((d = this.distance(instance, instances.instance(i))) < dArray[i])) continue;
            dArray[i] = d;
        }
    }

    protected int farthestAway(double[] dArray, boolean[] blArray) {
        double d = -1.0;
        int n = -1;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] || !(d < dArray[i])) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    protected void initMinMax(Instances instances) {
        int n;
        this.m_Min = new double[instances.numAttributes()];
        this.m_Max = new double[instances.numAttributes()];
        for (n = 0; n < instances.numAttributes(); ++n) {
            this.m_Max[n] = Double.NaN;
            this.m_Min[n] = Double.NaN;
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            this.updateMinMax(instances.instance(n));
        }
    }

    private void updateMinMax(Instance instance) {
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (Double.isNaN(this.m_Min[i])) {
                this.m_Min[i] = instance.value(i);
                this.m_Max[i] = instance.value(i);
                continue;
            }
            if (instance.value(i) < this.m_Min[i]) {
                this.m_Min[i] = instance.value(i);
                continue;
            }
            if (!(instance.value(i) > this.m_Max[i])) continue;
            this.m_Max[i] = instance.value(i);
        }
    }

    protected int clusterProcessedInstance(Instance instance) {
        double d = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            double d2 = this.distance(instance, this.m_ClusterCentroids.instance(i));
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public int clusterInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingFilter.input(instance);
        this.m_ReplaceMissingFilter.batchFinished();
        Instance instance2 = this.m_ReplaceMissingFilter.output();
        return this.clusterProcessedInstance(instance2);
    }

    protected double distance(Instance instance, Instance instance2) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n < instance.numValues() || n2 < instance2.numValues()) {
            double d2;
            int n3 = n >= instance.numValues() ? this.m_instances.numAttributes() : instance.index(n);
            int n4 = n2 >= instance2.numValues() ? this.m_instances.numAttributes() : instance2.index(n2);
            if (n3 == this.m_instances.classIndex()) {
                ++n;
                continue;
            }
            if (n4 == this.m_instances.classIndex()) {
                ++n2;
                continue;
            }
            if (n3 == n4) {
                d2 = this.difference(n3, instance.valueSparse(n), instance2.valueSparse(n2));
                ++n;
                ++n2;
            } else if (n3 > n4) {
                d2 = this.difference(n4, 0.0, instance2.valueSparse(n2));
                ++n2;
            } else {
                d2 = this.difference(n3, instance.valueSparse(n), 0.0);
                ++n;
            }
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)this.m_instances.numAttributes());
    }

    protected double difference(int n, double d, double d2) {
        switch (this.m_instances.attribute(n).type()) {
            case 1: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2) || (int)d != (int)d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2)) {
                    if (Instance.isMissingValue(d) && Instance.isMissingValue(d2)) {
                        return 1.0;
                    }
                    double d3 = Instance.isMissingValue(d2) ? this.norm(d, n) : this.norm(d2, n);
                    if (d3 < 0.5) {
                        d3 = 1.0 - d3;
                    }
                    return d3;
                }
                return this.norm(d, n) - this.norm(d2, n);
            }
        }
        return 0.0;
    }

    protected double norm(double d, int n) {
        if (Double.isNaN(this.m_Min[n]) || Utils.eq(this.m_Max[n], this.m_Min[n])) {
            return 0.0;
        }
        return (d - this.m_Min[n]) / (this.m_Max[n] - this.m_Min[n]);
    }

    public int numberOfClusters() throws Exception {
        return this.m_NumClusters;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tnumber of clusters. (default = 2).", "N", 1, "-N <num>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public String numClustersTipText() {
        return "set number of clusters";
    }

    public void setNumClusters(int n) throws Exception {
        if (n < 0) {
            throw new Exception("Number of clusters must be > 0");
        }
        this.m_NumClusters = n;
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumClusters(Integer.parseInt(string));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-N");
        vector.add("" + this.getNumClusters());
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n FarthestFirst\n==============\n");
        stringBuffer.append("\nCluster centroids:\n");
        for (int i = 0; i < this.m_NumClusters; ++i) {
            stringBuffer.append("\nCluster " + i + "\n\t");
            for (int j = 0; j < this.m_ClusterCentroids.numAttributes(); ++j) {
                if (this.m_ClusterCentroids.attribute(j).isNominal()) {
                    stringBuffer.append(" " + this.m_ClusterCentroids.attribute(j).value((int)this.m_ClusterCentroids.instance(i).value(j)));
                    continue;
                }
                stringBuffer.append(" " + this.m_ClusterCentroids.instance(i).value(j));
            }
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }

    public static void main(String[] stringArray) {
        FarthestFirst.runClusterer(new FarthestFirst(), stringArray);
    }
}

