/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Instance;
import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.PerformanceStats;

public class EuclideanDistance
extends NormalizableDistance
implements Cloneable,
TechnicalInformationHandler {
    private static final long serialVersionUID = 1068606253458807903L;

    public EuclideanDistance() {
    }

    public EuclideanDistance(Instances instances) {
        super(instances);
    }

    public String globalInfo() {
        return "Implementing Euclidean distance (or similarity) function.\n\nOne object defines not one distance but the data model in which the distances between objects of that data model can be computed.\n\nAttention: For efficiency reasons the use of consistency checks (like are the data models of the two instances exactly the same), is low.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MISC);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Euclidean distance");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Euclidean_distance");
        return technicalInformation;
    }

    public double distance(Instance instance, Instance instance2) {
        return Math.sqrt(this.distance(instance, instance2, Double.POSITIVE_INFINITY));
    }

    public double distance(Instance instance, Instance instance2, PerformanceStats performanceStats) {
        return Math.sqrt(this.distance(instance, instance2, Double.POSITIVE_INFINITY, performanceStats));
    }

    protected double updateDistance(double d, double d2) {
        double d3 = d;
        return d3 += d2 * d2;
    }

    public void postProcessDistances(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.sqrt(dArray[i]);
        }
    }

    public double sqDifference(int n, double d, double d2) {
        double d3 = this.difference(n, d, d2);
        return d3 * d3;
    }

    public double getMiddle(double[] dArray) {
        double d = dArray[0] + dArray[2] * 0.5;
        return d;
    }

    public int closestPoint(Instance instance, Instances instances, int[] nArray) throws Exception {
        double d = 2.147483647E9;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            double d2 = this.distance(instance, instances.instance(nArray[i]), Double.POSITIVE_INFINITY);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return nArray[n];
    }

    public boolean valueIsSmallerEqual(Instance instance, int n, double d) {
        return instance.value(n) <= d;
    }
}

