/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.io.Serializable;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class PreConstructedLinearModel
extends Classifier
implements Serializable {
    static final long serialVersionUID = 2030974097051713247L;
    private double[] m_coefficients;
    private double m_intercept;
    private Instances m_instancesHeader;
    private int m_numParameters;

    public PreConstructedLinearModel(double[] dArray, double d) {
        this.m_coefficients = dArray;
        this.m_intercept = d;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            ++n;
        }
        this.m_numParameters = n;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.m_instancesHeader = new Instances(instances, 0);
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = 0.0;
        for (int i = 0; i < this.m_coefficients.length; ++i) {
            if (i == instance.classIndex() || instance.isMissing(i)) continue;
            d += this.m_coefficients[i] * instance.value(i);
        }
        return d += this.m_intercept;
    }

    public int numParameters() {
        return this.m_numParameters;
    }

    public double[] coefficients() {
        return this.m_coefficients;
    }

    public double intercept() {
        return this.m_intercept;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n" + this.m_instancesHeader.classAttribute().name() + " = ");
        boolean bl = true;
        for (int i = 0; i < this.m_coefficients.length; ++i) {
            if (this.m_coefficients[i] == 0.0) continue;
            double d = this.m_coefficients[i];
            if (bl) {
                stringBuffer.append("\n\t" + Utils.doubleToString(d, 12, 4).trim() + " * " + this.m_instancesHeader.attribute(i).name() + " ");
                bl = false;
                continue;
            }
            stringBuffer.append("\n\t" + (this.m_coefficients[i] < 0.0 ? "- " + Utils.doubleToString(Math.abs(d), 12, 4).trim() : "+ " + Utils.doubleToString(Math.abs(d), 12, 4).trim()) + " * " + this.m_instancesHeader.attribute(i).name() + " ");
        }
        stringBuffer.append("\n\t" + (this.m_intercept < 0.0 ? "- " : "+ ") + Utils.doubleToString(Math.abs(this.m_intercept), 12, 4).trim());
        return stringBuffer.toString();
    }
}

