/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import weka.core.Attribute;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.UnassignedClassException;
import weka.core.UnassignedDatasetException;
import weka.core.Utils;

public class Instance
implements Copyable,
Serializable {
    protected static final double MISSING_VALUE = Double.NaN;
    protected Instances m_Dataset;
    protected double[] m_AttValues;
    protected double m_Weight;

    protected Instance(Instance instance) {
        this.m_AttValues = instance.m_AttValues;
        this.m_Weight = instance.m_Weight;
        this.m_Dataset = null;
    }

    public Instance(double d, double[] dArray) {
        this.m_AttValues = dArray;
        this.m_Weight = d;
        this.m_Dataset = null;
    }

    public Instance(int n) {
        this.m_AttValues = new double[n];
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            this.m_AttValues[i] = Double.NaN;
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    public Attribute attribute(int n) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(n);
    }

    public Attribute attributeSparse(int n) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(n);
    }

    public Attribute classAttribute() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classAttribute();
    }

    public int classIndex() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classIndex();
    }

    public boolean classIsMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.isMissing(this.classIndex());
    }

    public double classValue() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.value(this.classIndex());
    }

    public Object copy() {
        Instance instance = new Instance(this);
        instance.m_Dataset = this.m_Dataset;
        return instance;
    }

    public Instances dataset() {
        return this.m_Dataset;
    }

    public void deleteAttributeAt(int n) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has access to a dataset!");
        }
        this.forceDeleteAttributeAt(n);
    }

    public Enumeration enumerateAttributes() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.enumerateAttributes();
    }

    public boolean equalHeaders(Instance instance) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeaders(instance.m_Dataset);
    }

    public boolean hasMissingValue() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (i == this.classIndex() || !this.isMissing(i)) continue;
            return true;
        }
        return false;
    }

    public int index(int n) {
        return n;
    }

    public void insertAttributeAt(int n) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has accesss to a dataset!");
        }
        if (n < 0 || n > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        this.forceInsertAttributeAt(n);
    }

    public boolean isMissing(int n) {
        return Double.isNaN(this.m_AttValues[n]);
    }

    public boolean isMissingSparse(int n) {
        return Double.isNaN(this.m_AttValues[n]);
    }

    public boolean isMissing(Attribute attribute) {
        return this.isMissing(attribute.index());
    }

    public static boolean isMissingValue(double d) {
        return Double.isNaN(d);
    }

    public Instance mergeInstance(Instance instance) {
        int n = 0;
        double[] dArray = new double[this.numAttributes() + instance.numAttributes()];
        int n2 = 0;
        while (n2 < this.numAttributes()) {
            dArray[n] = this.value(n2);
            ++n2;
            ++n;
        }
        n2 = 0;
        while (n2 < instance.numAttributes()) {
            dArray[n] = instance.value(n2);
            ++n2;
            ++n;
        }
        return new Instance(1.0, dArray);
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public int numAttributes() {
        return this.m_AttValues.length;
    }

    public int numClasses() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.numClasses();
    }

    public int numValues() {
        return this.m_AttValues.length;
    }

    public void replaceMissingValues(double[] dArray) {
        if (dArray == null || dArray.length != this.m_AttValues.length) {
            throw new IllegalArgumentException("Unequal number of attributes!");
        }
        this.freshAttributeVector();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (!this.isMissing(i)) continue;
            this.m_AttValues[i] = dArray[i];
        }
    }

    public void setClassMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setMissing(this.classIndex());
    }

    public void setClassValue(double d) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), d);
    }

    public final void setClassValue(String string) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), string);
    }

    public final void setDataset(Instances instances) {
        this.m_Dataset = instances;
    }

    public final void setMissing(int n) {
        this.setValue(n, Double.NaN);
    }

    public final void setMissing(Attribute attribute) {
        this.setMissing(attribute.index());
    }

    public void setValue(int n, double d) {
        this.freshAttributeVector();
        this.m_AttValues[n] = d;
    }

    public void setValueSparse(int n, double d) {
        this.freshAttributeVector();
        this.m_AttValues[n] = d;
    }

    public final void setValue(int n, String string) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        if (!this.attribute(n).isNominal() && !this.attribute(n).isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int n2 = this.attribute(n).indexOfValue(string);
        if (n2 == -1) {
            if (this.attribute(n).isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            this.attribute(n).forceAddValue(string);
            n2 = this.attribute(n).indexOfValue(string);
        }
        this.setValue(n, (double)n2);
    }

    public final void setValue(Attribute attribute, double d) {
        this.setValue(attribute.index(), d);
    }

    public final void setValue(Attribute attribute, String string) {
        if (!attribute.isNominal() && !attribute.isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int n = attribute.indexOfValue(string);
        if (n == -1) {
            if (attribute.isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            attribute.forceAddValue(string);
            n = attribute.indexOfValue(string);
        }
        this.setValue(attribute.index(), (double)n);
    }

    public final void setWeight(double d) {
        this.m_Weight = d;
    }

    public final Instances relationalValue(int n) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.relationalValue(this.m_Dataset.attribute(n));
    }

    public final Instances relationalValue(Attribute attribute) {
        int n = attribute.index();
        if (attribute.isRelationValued()) {
            return attribute.relation((int)this.value(n));
        }
        throw new IllegalArgumentException("Attribute isn't relation-valued!");
    }

    public final String stringValue(int n) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.stringValue(this.m_Dataset.attribute(n));
    }

    public final String stringValue(Attribute attribute) {
        int n = attribute.index();
        switch (attribute.type()) {
            case 1: 
            case 2: {
                return attribute.value((int)this.value(n));
            }
            case 3: {
                return attribute.formatDate(this.value(n));
            }
            case 4: {
                return attribute.relation((int)this.value(n)).stringWithoutHeader();
            }
        }
        throw new IllegalArgumentException("Attribute isn't nominal, string or date!");
    }

    public double[] toDoubleArray() {
        double[] dArray = new double[this.m_AttValues.length];
        System.arraycopy(this.m_AttValues, 0, dArray, 0, this.m_AttValues.length);
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.toString(i));
        }
        return stringBuffer.toString();
    }

    public final String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isMissing(n)) {
            stringBuffer.append("?");
        } else if (this.m_Dataset == null) {
            stringBuffer.append(Utils.doubleToString(this.m_AttValues[n], 6));
        } else {
            switch (this.m_Dataset.attribute(n).type()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    stringBuffer.append(Utils.quote(this.stringValue(n)));
                    break;
                }
                case 0: {
                    stringBuffer.append(Utils.doubleToString(this.value(n), 6));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown attribute type");
                }
            }
        }
        return stringBuffer.toString();
    }

    public final String toString(Attribute attribute) {
        return this.toString(attribute.index());
    }

    public double value(int n) {
        return this.m_AttValues[n];
    }

    public double valueSparse(int n) {
        return this.m_AttValues[n];
    }

    public double value(Attribute attribute) {
        return this.value(attribute.index());
    }

    public final double weight() {
        return this.m_Weight;
    }

    void forceDeleteAttributeAt(int n) {
        double[] dArray = new double[this.m_AttValues.length - 1];
        System.arraycopy(this.m_AttValues, 0, dArray, 0, n);
        if (n < this.m_AttValues.length - 1) {
            System.arraycopy(this.m_AttValues, n + 1, dArray, n, this.m_AttValues.length - (n + 1));
        }
        this.m_AttValues = dArray;
    }

    void forceInsertAttributeAt(int n) {
        double[] dArray = new double[this.m_AttValues.length + 1];
        System.arraycopy(this.m_AttValues, 0, dArray, 0, n);
        dArray[n] = Double.NaN;
        System.arraycopy(this.m_AttValues, n, dArray, n + 1, this.m_AttValues.length - n);
        this.m_AttValues = dArray;
    }

    protected Instance() {
    }

    private void freshAttributeVector() {
        this.m_AttValues = this.toDoubleArray();
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Attribute attribute = new Attribute("length");
            Attribute attribute2 = new Attribute("weight");
            FastVector fastVector = new FastVector(3);
            fastVector.addElement("first");
            fastVector.addElement("second");
            fastVector.addElement("third");
            Attribute attribute3 = new Attribute("position", fastVector);
            FastVector fastVector2 = new FastVector(3);
            fastVector2.addElement(attribute);
            fastVector2.addElement(attribute2);
            fastVector2.addElement(attribute3);
            Instances instances = new Instances("race", fastVector2, 0);
            instances.setClassIndex(attribute3.index());
            Instance instance = new Instance(3);
            instance.setValue(attribute, 5.3);
            instance.setValue(attribute2, 300.0);
            instance.setValue(attribute3, "first");
            instance.setDataset(instances);
            System.out.println("The instance: " + instance);
            System.out.println("First attribute: " + instance.attribute(0));
            System.out.println("Class attribute: " + instance.classAttribute());
            System.out.println("Class index: " + instance.classIndex());
            System.out.println("Class is missing: " + instance.classIsMissing());
            System.out.println("Class value (internal format): " + instance.classValue());
            Instance instance2 = (Instance)instance.copy();
            System.out.println("Shallow copy: " + instance2);
            instance2.setDataset(instance.dataset());
            System.out.println("Shallow copy with dataset set: " + instance2);
            instance2.setDataset(null);
            instance2.deleteAttributeAt(0);
            instance2.insertAttributeAt(0);
            instance2.setDataset(instance.dataset());
            System.out.println("Copy with first attribute deleted and inserted: " + instance2);
            System.out.println("Enumerating attributes (leaving out class):");
            Enumeration enumeration = instance.enumerateAttributes();
            while (enumeration.hasMoreElements()) {
                object = (Attribute)enumeration.nextElement();
                System.out.println(object);
            }
            System.out.println("Header of original and copy equivalent: " + instance.equalHeaders(instance2));
            System.out.println("Length of copy missing: " + instance2.isMissing(attribute));
            System.out.println("Weight of copy missing: " + instance2.isMissing(attribute2.index()));
            System.out.println("Length of copy missing: " + Instance.isMissingValue(instance2.value(attribute)));
            System.out.println("Missing value coded as: " + Instance.missingValue());
            System.out.println("Number of attributes: " + instance2.numAttributes());
            System.out.println("Number of classes: " + instance2.numClasses());
            object = new double[]{2.0, 3.0, 0.0};
            instance2.replaceMissingValues((double[])object);
            System.out.println("Copy with missing value replaced: " + instance2);
            instance2.setClassMissing();
            System.out.println("Copy with missing class: " + instance2);
            instance2.setClassValue(0.0);
            System.out.println("Copy with class value set to first value: " + instance2);
            instance2.setClassValue("third");
            System.out.println("Copy with class value set to \"third\": " + instance2);
            instance2.setMissing(1);
            System.out.println("Copy with second attribute set to be missing: " + instance2);
            instance2.setMissing(attribute);
            System.out.println("Copy with length set to be missing: " + instance2);
            instance2.setValue(0, 0.0);
            System.out.println("Copy with first attribute set to 0: " + instance2);
            instance2.setValue(attribute2, 1.0);
            System.out.println("Copy with weight attribute set to 1: " + instance2);
            instance2.setValue(attribute3, "second");
            System.out.println("Copy with position set to \"second\": " + instance2);
            instance2.setValue(2, "first");
            System.out.println("Copy with last attribute set to \"first\": " + instance2);
            System.out.println("Current weight of instance copy: " + instance2.weight());
            instance2.setWeight(2.0);
            System.out.println("Current weight of instance copy (set to 2): " + instance2.weight());
            System.out.println("Last value of copy: " + instance2.toString(2));
            System.out.println("Value of position for copy: " + instance2.toString(attribute3));
            System.out.println("Last value of copy (internal format): " + instance2.value(2));
            System.out.println("Value of position for copy (internal format): " + instance2.value(attribute3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

