/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import java.util.Arrays;
import weka.classifiers.functions.pace.FlexibleDecimalFormat;

public class IntVector
implements Cloneable {
    int[] V;
    private int sizeOfVector;

    public IntVector() {
        this.V = new int[0];
        this.setSize(0);
    }

    public IntVector(int n) {
        this.V = new int[n];
        this.setSize(n);
    }

    public IntVector(int n, int n2) {
        this(n);
        this.set(n2);
    }

    public IntVector(int[] nArray) {
        if (nArray == null) {
            this.V = new int[0];
            this.setSize(0);
        } else {
            this.V = new int[nArray.length];
            this.setSize(nArray.length);
            this.set(0, this.size() - 1, nArray, 0);
        }
    }

    public int size() {
        return this.sizeOfVector;
    }

    public void setSize(int n) {
        if (n > this.capacity()) {
            throw new IllegalArgumentException("insufficient capacity");
        }
        this.sizeOfVector = n;
    }

    public void set(int n) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, n);
        }
    }

    public void set(int n, int n2, int[] nArray, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.set(i, nArray[n3 + i - n]);
        }
    }

    public void set(int n, int n2, IntVector intVector, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.set(i, intVector.get(n3 + i - n));
        }
    }

    public void set(IntVector intVector) {
        this.set(0, intVector.size() - 1, intVector, 0);
    }

    public static IntVector seq(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("i1 < i0 ");
        }
        IntVector intVector = new IntVector(n2 - n + 1);
        for (int i = 0; i < n2 - n + 1; ++i) {
            intVector.set(i, i + n);
        }
        return intVector;
    }

    protected int[] getArray() {
        return this.V;
    }

    protected void setArray(int[] nArray) {
        this.V = nArray;
    }

    public void sort() {
        Arrays.sort(this.V, 0, this.size());
    }

    public int[] getArrayCopy() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i <= this.size() - 1; ++i) {
            nArray[i] = this.V[i];
        }
        return nArray;
    }

    public int capacity() {
        return this.V.length;
    }

    public void setCapacity(int n) {
        if (n == this.capacity()) {
            return;
        }
        int[] nArray = this.V;
        int n2 = Math.min(n, this.size());
        this.V = new int[n];
        this.setSize(n);
        this.set(0, n2 - 1, nArray, 0);
    }

    public void set(int n, int n2) {
        this.V[n] = n2;
    }

    public int get(int n) {
        return this.V[n];
    }

    public IntVector copy() {
        return (IntVector)this.clone();
    }

    public Object clone() {
        IntVector intVector = new IntVector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            intVector.V[i] = this.V[i];
        }
        return intVector;
    }

    public IntVector subvector(int n, int n2) {
        IntVector intVector = new IntVector(n2 - n + 1);
        intVector.set(0, n2 - n, this, n);
        return intVector;
    }

    public IntVector subvector(IntVector intVector) {
        IntVector intVector2 = new IntVector(intVector.size());
        for (int i = 0; i < intVector.size(); ++i) {
            intVector2.V[i] = this.V[intVector.V[i]];
        }
        return intVector2;
    }

    public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, n3);
    }

    public void shift(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n < n2) {
            int n3 = this.V[n];
            for (int i = n; i <= n2 - 1; ++i) {
                this.V[i] = this.V[i + 1];
            }
            this.V[n2] = n3;
        } else {
            this.shift(n2, n);
        }
    }

    public void shiftToEnd(int n) {
        this.shift(n, this.size() - 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.toString(5, false);
    }

    public String toString(int n, boolean bl) {
        int n2;
        if (this.isEmpty()) {
            return "null vector";
        }
        StringBuffer stringBuffer = new StringBuffer();
        FlexibleDecimalFormat flexibleDecimalFormat = new FlexibleDecimalFormat(n, bl);
        flexibleDecimalFormat.grouping(true);
        for (n2 = 0; n2 < this.size(); ++n2) {
            flexibleDecimalFormat.update(this.get(n2));
        }
        n2 = 0;
        int n3 = 80;
        for (int i = 0; i < this.size(); ++i) {
            String string = flexibleDecimalFormat.format(this.get(i));
            if ((n2 += 1 + string.length()) > n3 - 1) {
                stringBuffer.append('\n');
                n2 = 1 + string.length();
            }
            stringBuffer.append(" " + string);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        IntVector intVector = new IntVector();
        System.out.println(intVector);
        IntVector intVector2 = IntVector.seq(10, 25);
        System.out.println(intVector2);
        IntVector intVector3 = IntVector.seq(25, 10);
        System.out.println(intVector3);
    }
}

