% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rw_scen_gen_names.R
\name{rw_scen_gen_names}
\alias{rw_scen_gen_names}
\alias{makeAllScenNames}
\title{Create a vector of scenarios from different dimensions}
\usage{
rw_scen_gen_names(dim1, dim2, ..., sep = ",")

makeAllScenNames(dim1, dim2, ..., sep = ",")
}
\arguments{
\item{dim1}{A character vector with all of the first dimension's names.}

\item{dim2}{A character vector with all of the second dimension's names.}

\item{...}{As many individual character vectors as necessary for the
remaining dimension's names.}

\item{sep}{The character used to separate the different dimension names.
Defaults to\code{","}.}
}
\value{
A character vector of all possible combinations of the dimensions.
}
\description{
\code{rw_scen_gen_names()} creates a vector of full scenario names by combining
multiple dimensions together.
}
\details{
Many RiverWare runs are specified by multiple dimensions (or assumptions),
and RiverSMART creates folder names by combining the dimension names together
for a full scenario name. \code{rw_scen_gen_names()} makes it quick to create all
of the full scenario names by passing in the names of the individual
dimensions and creating all possible combinations of all dimensions.

For example, the RiverWare run might consist of a supply dimension and a
demand dimension, each consisting of two scenarios. This would result in four
total scenarios.

The function will work with two or more dimensions, as there is no need for
this function if there is only one dimension.
}
\section{Functions}{
\itemize{
\item \code{makeAllScenNames}: Deprecated version of \code{rw_scen_gen_names()}
}}

\examples{
rw_scen_gen_names("DNF", "CT", c("IG", "NA"), c("MTOM", "24-MS"))
rw_scen_gen_names("DNF", "CT", c("IG", "NA"), sep = "_")

}
