% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.TTC.R
\name{duration.TTC}
\alias{duration.TTC}
\title{Duration - Data Weighting and "TTC" Calculation}
\usage{
duration.TTC(lstCnt,lstFirmYears)
}
\arguments{
\item{lstCnt}{off-diagonal transition counts (matrix) for each time-step}

\item{lstFirmYears}{firm years each time-step}
}
\value{
\item{CLW}{\emph{Count Level Weighting} - Construct TTC transition matrix from aggregate scaled and weighted counts data (transitions and 'firm-years').}

\item{PTMLW}{\emph{Periodic Transition Matrix Level Weighting} - Construct TTC transition matrix using the average of the weighted transition matrices from each time-step (Scaling is performed at the transition matrix level for each time-step).}

\item{PGMLW}{\emph{Periodic Generator Matrix Level Weighting} - Construct TTC transition matrix using the average of the weighted Generator matices from each time-step (Scaling is performed at the generator matrix level for each time-step).}

\item{UUPTM}{\emph{Unscaled and UnWeighted Periodic Transition Matrices} - Construction of unscaled and unweighted periodic transition matrices from unscaled and unweighted generator matrices for each time-step .}

\item{WGM}{\emph{Weighted Generator Matrix} - Average generator matrix from each time-step.}

\item{SWT}{\emph{Scaled and Weighted Transitions} - aggregate scaled and weighted transitions}

\item{SWFY}{\emph{Scaled and Weighted Firm Years} - aggregate scaled and weighted firm years}
}
\description{
Calculating \emph{Through-the-Cycle} generator matrix and transition counts using \emph{duration method}
}
\details{
Given data representing \emph{x} off-diagonal transition counts for each time-step, this function combines those data to obtain average counts for each time-step,
in such a way as to preserve the information while implementing a weighting scheme that would allow for the weighting of the historical experiences.

Let \eqn{T(m,y)} and \eqn{F(m,y)} represent the off-diagonal transition matrix and 'firm-years' vector, for month = \eqn{m} and year = \eqn{y},
respectively. Then,
\deqn{T(m,y) = \{T_{ij}(m,y)\}_{i,j\,=\,1,\ldots,K}}
\deqn{F(m,y) =  \{F_{i}(m,y)\}_{i\,=\,1,\ldots,K}}

Many credit risk models require a \emph{long-run average} PD estimate. This has been interpreted as meaning the data from multiple years should be
combined and in a method capable of supporting some form of weighting of samples.
The three methods of weighting considered for data generated via the \emph{duration method} are:
\enumerate{
	\item Scale the number of transitions and firm counts/years using the a single year count to preserve dynamics, then average transitions and firms
	counts/years separately to create a generator matrix.
	\item Estimate the single-year quantities \emph{(generator matrices for each time-step)}, then average across years
	\item Average transition matrices from each time-step
}
The Markov property allows for direct weighting as each year can be regarded as distinct.
}
\examples{
\dontrun{

#Set parameters
startDate  <- "2000-01-01"
endDate    <- "2005-01-01"
method       <- "duration"   
snapshots <- 4
interval <-  0
Example1<-getPIT(data,startDate, endDate,method, snapshots, interval)

ExampleTTC1<-duration.TTC(Example1$lstCntMat,Example1$lstInitVec)

}
}
\author{
Abdoulaye (Ab) N'Diaye
}
