% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.xmlRead.R
\name{xmlRead.default}
\alias{xmlRead.default}
\title{General import function to reads XML data of different types}
\usage{
xmlRead.default(xmlItem)
}
\arguments{
\item{xmlItem}{(\code{XMLNode}) Object of class \code{XMLNode} that defines the
a list object and fullfills XSD definition 'xmlReadData_list'.}
}
\value{
(\code{data.frame}) or (\code{variable}) or (\code{vector}) or a named list of
  all imported input datasets.
}
\description{
This function controls the import of input data set.
}
\details{
Based on the tag name of the input data definition in the XML file, the corresponding
\code{readXMLData_*} function is called, whereby \code{*} is a placeholder for the data type
definition in the XML scheme. For example, for XML definitions following the \code{data.frame}
specification, a function \code{readXMLData_data.frame <- function(xmlDataItem)} is expected,
which implements the XML parser for \code{data.frame}s and returns the data as R object.
}
\examples{
data <- '<text type="character">My text is awesome</text>'
item <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))
value <- RTest::xmlRead.default(item)
stopifnot(value=="My text is awesome")

data <- '<list><data.frame><col-defs>
<coldef name="Column1" type="character"/>
<coldef name="Column2" type="numeric"/>
</col-defs>
<row name="1"><cell>ID1</cell><cell>1</cell></row>
<row name="2"><cell>ID2</cell><cell>2.1</cell></row>
<row name="3"><cell>ID3</cell><cell>3.1</cell></row>
</data.frame></list>'
item <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))
value <- RTest::xmlRead.default(item)
stopifnot(dim(value)[1]==3)
stopifnot(dim(value)[2]==2)

data <- '<variable type="character" value="My text is awesome"/>'
item <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))
value <- RTest::xmlRead.default(item)
stopifnot(value=="My text is awesome")
}
\seealso{
\code{\link[XML]{XMLNode-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
