% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_zscore.R
\name{chart_zscore}
\alias{chart_zscore}
\title{\code{chart_zscore}}
\usage{
chart_zscore(
  df = df,
  title = "NG Storage Z Score",
  per = "yearweek",
  output = "zscore",
  chart = "seasons"
)
}
\arguments{
\item{df}{Long data frame with columns series, date and value}

\item{title}{Your chart title}

\item{per}{Frequency of seasonality "yearweek" (DEFAULT). "yearmonth", "yearquarter"}

\item{output}{"stl" for STL decomposition chart,
"stats" for STL statistical test results.
"zscore" for residuals Z-score,
"seasonal" for standard seasonal chart.}

\item{chart}{"seasons" for feasts::gg_season() (DEFAULT)
"series" for feasts::gg_subseries()}
}
\value{
Time series of STL decomposition residuals Z-Scores, or
standard seasonal chart with feast package.
}
\description{
Supports analytics and display of seasonal data. Z-Score is
computed on residuals conditional on their seasonal period.
Beware that most seasonal charts in industry e.g. (NG Storage)
is not detrended so results once you apply an STL decompostion
will vary from the unajusted seasonal plot.
}
\examples{
chart_zscore(df = ng_storage, title = "NG Storage Z Score",
per = "yearweek", output = "stl", chart = "seasons")
chart_zscore(df = ng_storage, title = "NG Storage Z Score",
per = "yearweek", output = "stats", chart = "seasons")
chart_zscore(df = ng_storage, title = "NG Storage Z Score",
per = "yearweek", output = "zscore", chart = "seasons")
chart_zscore(df = ng_storage, title = "NG Storage Z Score",
per = "yearweek", output = "seasonal", chart = "seasons")
}
\author{
Philippe Cote
}
