% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_api_repo.R
\name{repo_mng_list}
\alias{repo_mng_list}
\title{Retrieve the list of available packages in the repository.}
\usage{
repo_mng_list(repo_manager, pkg_type = .Platform$pkgType, no.cache = FALSE)
}
\arguments{
\item{repo_manager}{repo manager to retrieve package list from.
(type: rsuite_repo_manager)}

\item{pkg_type}{type of packages to retrieve list of.
(type: character, default to platform default package type)}

\item{no.cache}{it TRUE will delete cached list before retrieving.
(type: logical(1), default: FALSE)}
}
\value{
data.frame of the same structure as available.packages returns.
}
\description{
Retrieve the list of available packages in the repository.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # set it to use in project repository and CRAN
  prj_config_set_repo_adapters(c("Dir", "CRAN"), prj = prj)

  # start managing in project repository
  rmgr <- repo_mng_start("Dir", prj = prj, ix = 1)

  # upload logging package from CRAN into the repository
  repo_upload_ext_packages(rmgr, pkgs = "logging", prj = prj)

  # list available packages
  repo_mng_list(rmgr)

  # stop repository management
  repo_mng_stop(rmgr)
}

}
\seealso{
Other in repository management: \code{\link{repo_mng_init}},
  \code{\link{repo_mng_remove}},
  \code{\link{repo_mng_start}},
  \code{\link{repo_mng_stop}},
  \code{\link{repo_upload_ext_packages}},
  \code{\link{repo_upload_github_package}},
  \code{\link{repo_upload_package_files}},
  \code{\link{repo_upload_pkgzip}},
  \code{\link{repo_upload_prj_packages}}
}
