% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueueDataWarehouse.R
\name{QueueDataWarehouse}
\alias{QueueDataWarehouse}
\title{Queue a DataWarehouse Report}
\usage{
QueueDataWarehouse(reportsuite.id, date.from, date.to, metrics, elements,
  date.granularity = "day", segment.id = "", data.current = TRUE,
  expedite = FALSE, interval.seconds = 5, max.attempts = 120,
  validate = TRUE, enqueueOnly = TRUE, ftp = ftp)
}
\arguments{
\item{reportsuite.id}{Report suite id}

\item{date.from}{Start date for the report (YYYY-MM-DD)}

\item{date.to}{End date for the report (YYYY-MM-DD)}

\item{metrics}{List of metrics to include in the report}

\item{elements}{List of elements to include in the report}

\item{date.granularity}{Time granularity of the report (year/month/week/day/hour), default to 'day'}

\item{segment.id}{Id of Adobe Analytics segment to retrieve the report for}

\item{data.current}{TRUE or FALSE - whether to include current data for reports that include today's date}

\item{expedite}{Set to TRUE to expedite the processing of this report}

\item{interval.seconds}{How long to wait between attempts}

\item{max.attempts}{Number of API attempts before stopping}

\item{validate}{Weather to submit report definition for validation before requesting the data.}

\item{enqueueOnly}{only enqueue the report, don't get the data. returns report id, which you can later use to get the data}

\item{ftp}{FTP client parameters, only used if enqueueOnly=TRUE. Double check ftp parameters before requesting
a long report.}
}
\value{
Data frame or report id, if enqueueOnly is TRUE
}
\description{
A QueueDataWarehouse report is a report where metrics are
retrieved, broken down by an unlimited number of elements such as page, eVar, prop, etc, and
with or without temporal aggregation. Due API limitations, only one segment can be used if needed.
}
\details{
The QueueDataWarehouse function allows to access to Data WareHouse data
and returns either a json or send a csv to a ftp server.

Because of the Reporting API structure, this function requests the
report, then, if \code{enqueueOnly=FALSE}, checks the reporting queue to see if the report is completed,
and when the report returns as "done" pulls the report from the API (if ftp is not defined).
This checking process will occur up to the specified number of times (default 120),
with a delay between status checks (default 10 seconds). If the report does not
return as "done" or a "delivery_complete" after the number of tries have completed, the function will return
an error message. When \code{enqueueOnly=TRUE} and no ftp server is set, the report can be retrieved with Report.Get
using the reportId returned by the QueueDataWarehouse function.

API limitations:
A single segment is supported. Multiple segments are not supported.
The following element properties are not supported in Data Warehouse reports:
    - selected
    - search
    - top
    - startingWith
    - sortBy
Calculated metrics are not supported.
Results for data warehouse reports can be accessed in two ways: directly through the API and
through FTP delivery. Email delivery is not supported.
All data warehouse results are paged in chunks of 20 MB. Add "page": to \code{Report.Get} 
to determine the page returned. If no page is specified then the first page is returned.
}
\examples{
\dontrun{
report.data <- QueueDataWarehouse("your_report_suite",
                            "2014-01-01",
                            "2014-01-07",
                            c("visits", "pageviews","event10"),
                            c("page","geoCountry","geoCity"),
                            enqueueOnly=TRUE,
                            ftp = list(host = "myftpserver.com",
                                       port = "21",
                                       directory = "/fromDW/",
                                       username = "memyselfandirene",
                                       password = "valkilmer",
                                       filename = "myreport.csv")
                            )
}
}

