% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempStorageMethods.R
\name{getStoredFiles}
\alias{getStoredFiles}
\title{Get Stored Files}
\usage{
getStoredFiles(account, username = Sys.getenv("SLUSER"), ...)
}
\arguments{
\item{account}{An object of class "account". An account object see \code{\link{account}}.}

\item{username}{SauceLabs username}

\item{...}{Additonal function arguments - Currently unused.}
}
\description{
Check which files are in your temporary storage
}
\examples{
\dontrun{
myAcc <- account()
# create a temporary file
myTempFile <- file.path(tempdir(), "notsecret.html")
write("SUPER SECRET STUFF", myTempFile)
# check stored files
myStoredFiles <- getStoredFiles(myAcc)

# upload new file
res <- uploadFile(myAcc, file = myTempFile)
#> res
#$username
#[1] "seleniumPipes"
#
#$size
#[1] 19
#
#$md5
#[1] "e459fe3803b78d64cc5c2998804909a9"
#
#$filename
#[1] "notsecret.html"

#> digest::digest(file = myTempFile, algo = "md5")
#[1] "e459fe3803b78d64cc5c2998804909a9"

myStoredFiles <- getStoredFiles(myAcc)

#> rbindlist(myStoredFiles$files)
#size      mtime           name                              md5
#1:   19 1472401537 notsecret.html e459fe3803b78d64cc5c2998804909a9
#2:   14 1472350499      testDoc.R adfc8afc373f0b3fd6f93c3891bdd11b

}
}
\seealso{
Other tempStorageMethods: \code{\link{uploadFile}}
}

