% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reg_class.R
\name{normTrainingAndTestSet}
\alias{normTrainingAndTestSet}
\title{Function to normalize training and test set}
\usage{
normTrainingAndTestSet(x, dontNormTargets = TRUE, type = "norm")
}
\arguments{
\item{x}{a list containing training and test data. Usually the output of \code{\link{splitForTrainingAndTest}}.}

\item{dontNormTargets}{should the target values also be normalized?}

\item{type}{type of the normalization. This parameter is passed to \code{\link{normalizeData}}.}
}
\value{
a named list with the same elements as \code{\link{splitForTrainingAndTest}}, but with normalized values.
The normalization parameters are appended to each member of the list as attributes, as in \code{\link{normalizeData}}.
}
\description{
Normalize training and test set as obtained by \code{\link{splitForTrainingAndTest}} in the following way:
The \code{inputsTrain} member is normalized using \code{\link{normalizeData}} with the parameters given in \code{type}.
The normalization parameters obtained during this normalization are then used to normalize the \code{inputsTest} member.
if \code{dontNormTargets} is not set, then the targets are normalized in the same way. In classification problems,
normalizing the targets normally makes no sense. For regression, normalizing also the targets is usually a good idea.
}
\examples{
data(iris)
#shuffle the vector
iris <- iris[sample(1:nrow(iris),length(1:nrow(iris))),1:ncol(iris)]

irisValues <- iris[,1:4]
irisTargets <- decodeClassLabels(iris[,5])

iris <- splitForTrainingAndTest(irisValues, irisTargets, ratio=0.15)
normTrainingAndTestSet(iris)
}
\seealso{
\code{\link{splitForTrainingAndTest}}, \code{\link{normalizeData}}, \code{\link{denormalizeData}},
\code{\link{getNormParameters}}
}

