\name{normalizeData}
\alias{normalizeData}
\title{Data normalization}
\usage{
  normalizeData(x, type = "norm")
}
\arguments{
  \item{x}{input data}

  \item{type}{\describe{

  \item{either}{type string specifying the type of
  normalization. Implemented are "0_1", "center", and
  "norm"}

  \item{or}{attribute list of a former call to this method
  to apply e.g. normalization of the training data to the
  test data}

  }}
}
\value{
  column-wise normalized input. The normalization
  parameters that were used for the normalization are
  present as attributes of the output. They can be obtained
  with \code{\link{getNormParameters}}.
}
\description{
  The input matrix is column-wise normalized.
}
\details{
  The parameter \code{type} specifies, how normalization
  takes place: \describe{ \item{0_1}{values are normalized
  to the [0,1]-interval. The minimum in the data is mapped
  to zero, the maximum to one.} \item{center}{the data is
  centered, i.e. the mean is substracted} \item{norm}{the
  data is normalized to mean zero, variance one} }
}
\seealso{
  \code{\link{denormalizeData}},
  \code{\link{getNormParameters}}
}

