/************************************************************************************

   This file is part of SnnsCLib, a fork of the kernel and parts of the gui of 
   the Stuttgart Neural Network Simulator (SNNS), version 4.3.

   The file's original version is part of SNNS 4.3. It's source code can be found at

   http://www.ra.cs.uni-tuebingen.de/SNNS/

   SNNS 4.3 is under the license LGPL v2. We note that source code files of SNNS 4.3 
   state as version "4.2". Base of this fork is SNNS 4.3 with a reverse-applied 
   python patch (see http://developer.berlios.de/projects/snns-dev/).

   SnnsCLib was developed in 2010 by Christoph Bergmeir under supervision of 
   José M. Benítez, both affiliated to DiCITS Lab, Sci2s group, DECSAI, 
   University of Granada

   Changes done to the original code were performed with the objective to
   port it from C to C++ and to encapsulate all code in one class named SnnsCLib.

   Changes in header files mainly include:
   * removed all static keywords
   * moved initializations of variables to the constructor of SnnsCLib

   Changes in cpp code files mainly include:
   * changed file ending from .c to .cpp
   * removed all SNNS internal includes and only include SnnsCLib   
   * static variables within functions were turned into member variables of SnnsCLib
   * function declarations were changed to method declarations, i.e. "SnnsCLib::.."
     was added
   * calls to the function table are now "C++-style", using the "this"-pointer

   License of SnnsCLib:
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

************************************************************************************/


/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /projects/higgs1/SNNS/CVS/SNNS/kernel/sources/kr_pat_scan.c,v 2.7 1998/04/08 09:16:54 vogtm Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

#include "SnnsCLibGeneric_util.h"

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#define YY_NO_UNPUT
#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 29
#define YY_END_OF_BUFFER 30
static yyconst short int yy_accept[284] =
    {   0,
        2,    2,   30,   27,    2,    5,    4,    6,    1,   27,
       27,   10,   27,   27,   27,   27,   27,   27,    7,    8,
       27,   27,   28,   27,    2,    3,    1,    1,   27,   10,
       13,   12,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   12,   27,   27,   11,   27,   27,   27,   27,   27,
       27,   27,   27,   13,   27,   27,   12,   27,   27,    0,
       27,   27,    9,   27,   27,   12,   27,   27,    0,   27,
        0,    9,   27,    0,   27,    0,    0,    0,    9,    9,
        9,    9,   27,    0,   27,    0,    0,    0,    0,   27,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

       27,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   27,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   15,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       15,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   23,    0,    0,    0,
        0,    0,   25,    0,    0,    0,    0,    0,    0,    0,
        0,   16,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,   26,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   17,    0,    0,
        0,    0,    0,    0,    0,    0,   18,    0,    0,    0,
        0,   24,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   21,    0,    0,    0,    0,    0,   22,
        0,    0,    0,    0,    0,    0,    0,    0,   14,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   19,    0,
        0,   20,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    5,    1,    1,    1,    1,
        1,    6,    1,    1,    7,    1,    1,    1,    1,    1,
        1,    1,    8,    1,    9,   10,    1,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   12,    1,    1,
        1,    1,    1,    1,    1,    1,   13,    1,   14,    1,
        1,    1,    1,    1,    1,    1,   15,   16,    1,    1,
        1,   17,   18,    1,    1,   19,    1,    1,    1,    1,
       20,    1,   21,    1,    1,    1,   22,   23,   24,   25,

       26,   27,   28,    1,   29,    1,    1,   30,   31,   32,
       33,   34,    1,   35,   36,   37,   38,   39,    1,   40,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[41] =
    {   0,
        1,    2,    3,    4,    5,    2,    6,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    7,
        7,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1
    } ;

static yyconst short int yy_base[294] =
    {   0,
        0,    0,  633,   37,   40,  634,  629,  634,   41,   44,
       49,   67,   59,   78,   87,   91,   99,  108,    0,    0,
      113,  118,  628,    0,   66,  634,  110,    0,  126,    0,
      131,  136,  145,  150,  155,  163,  168,  174,  182,  187,
      195,  200,  214,  206,  219,  224,  232,  238,  243,  245,
      256,  262,  264,  269,  283,  275,  288,  293,  301,  597,
      307,  314,  325,  312,  332,  334,  343,  345,  602,  356,
      594,  370,  370,  592,  375,  620,   25,  603,  391,    0,
      398,   90,  399,  598,  416,  399,  585,  600,  584,  429,
      595,   57,  589,  586,  579,  594,  593,  582,  578,  575,

      434,  582,  578,  571,  586,  573,  569,  568,  569,  579,
      580,  575,  440,  564,  563,  559,  559,  552,  555,  551,
      554,  544,  545,  540,  552,  532,  529,  528,  525,  523,
      518,  529,  532,  524,  526,  516,  509,  507,  502,  497,
      507,  526,  492,  493,  503,  492,  486,  512,    0,  486,
      504,  470,  466,  461,  488,  459,  456,  451,  452,  450,
        0,  447,  442,  452,  225,  417,  409,  401,  408,  275,
      394,  398,  383,  391,  392,  294,  634,  387,  383,  429,
      408,  450,  634,  372,  380,  368,  372,  370,  357,  359,
      451,  634,  134,  459,  358,  350,  352,  344,  337,  331,

      333,  326,  462,  634,  331,  328,  320,  324,  467,  301,
      297,  293,  287,  281,  274,  276,  470,  634,  475,  267,
      250,  231,  478,  233,  215,  483,  634,  210,  203,  210,
      486,  634,  203,  189,  209,  175,  174,  170,  158,  162,
      180,  151,  144,  143,  141,  143,  152,  491,  115,  118,
      119,  116,  494,  634,  499,  112,  104,  104,  502,  634,
       94,   95,   81,   70,   72,   77,   66,   48,  634,   50,
       47,   43,   40,   31,   18,  507,   13,  510,  634,  515,
      518,  634,  634,  530,  537,  543,  550,  557,  564,  571,
      578,  585,  592

    } ;

static yyconst short int yy_def[294] =
    {   0,
      283,    1,  283,  284,  283,  283,  285,  283,  286,  284,
      284,  284,  284,  284,  284,   12,   12,   12,  287,  287,
       12,   12,  285,  287,  283,  283,  286,  288,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,  283,
       12,   12,   12,   12,   12,   12,   12,   12,  283,   12,
      283,  289,   12,  283,   12,  283,  283,  283,  289,  290,
      291,  292,   12,  283,   12,  283,  283,  283,  283,   12,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,

       12,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,   12,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  293,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      293,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,

      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,    0,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283

    } ;

static yyconst short int yy_nxt[675] =
    {   0,
        4,    5,    6,    7,    8,    5,    9,   10,   10,   11,
       12,    4,   13,    4,   14,   15,   16,   17,   18,   19,
       20,    4,    4,    4,    4,    4,    4,   21,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,   18,    4,
       23,   25,   28,   23,   23,   25,   28,   23,  280,  277,
       23,   87,   23,   29,   30,   23,   24,   24,   88,   31,
       28,   28,   23,   24,   24,   23,  276,   25,   24,   24,
       23,   25,  275,   23,  274,  273,   32,   30,   24,   24,
       33,   23,  272,  271,   23,  103,   24,   24,   34,  104,
       23,   80,   33,   23,  270,   80,   80,   24,   24,   35,

       22,   22,  269,  268,   22,  267,   24,   24,   22,   22,
      266,   28,   22,   23,   38,   28,   37,   22,   39,   36,
      265,   22,   22,   22,   22,  264,   22,   22,   22,   28,
       28,   22,  263,   22,  262,   22,   31,  261,   40,   22,
       22,   31,  258,   22,   41,   22,   42,  257,  256,   43,
      255,   22,   44,   44,   22,   45,   41,  252,   22,   22,
       22,   43,  201,   22,   22,   22,  202,  251,   22,  250,
       22,   46,   48,   22,  249,   22,   22,   22,   22,  248,
       22,   22,  247,   22,   22,  246,  245,   22,   22,   50,
      244,   51,   39,   22,   47,   22,   22,   22,   49,   22,

       22,  243,   53,   53,   22,   54,  242,   22,   22,   22,
       42,  241,   22,   55,  240,   22,   45,  239,   52,   22,
       22,   56,   56,   22,   57,   55,  176,   22,   22,   45,
      176,   22,   22,   22,   22,  238,  177,   22,  237,   22,
      236,   22,   22,   60,   22,   22,  235,   22,   22,   22,
      234,   22,   22,   22,   22,   22,   22,   22,   22,   58,
       59,  233,   62,   22,   61,   22,   63,  230,   22,   22,
       22,   22,   22,   22,   54,   22,  182,   22,   22,   54,
      182,   22,   22,  229,   22,   57,  183,   64,   22,   22,
       65,   65,   22,   66,   22,  176,   22,   22,   57,  176,

       22,   22,   22,   22,  228,  177,   22,  225,   22,  224,
       22,   22,  223,   22,   22,  222,   22,   22,   22,   71,
       22,   22,   22,   22,   22,   22,   22,   22,   67,  221,
      220,   68,   22,   72,   22,   63,  219,   22,   22,   22,
       70,   22,   66,   22,   66,   22,   73,   22,   74,  216,
       22,  215,   22,   22,   22,   22,   22,   22,   22,   22,
      214,   77,  213,  212,  211,   22,   22,  210,   22,   22,
       22,   80,  209,   23,  208,   80,   81,  207,  206,   22,
       22,   22,   75,   22,   22,   22,  205,  200,   22,   82,
       82,   83,   80,  199,   23,   22,   80,   81,  198,   80,

       22,   23,  197,   80,  196,   85,  195,  194,   22,   22,
       82,   82,   22,  193,  190,  189,  188,   80,   80,  187,
      186,   92,   93,  185,   22,   22,   22,   94,  184,   22,
      191,   95,   96,  181,  191,   90,  180,   97,   22,   22,
      192,   22,   22,   22,   22,  125,  179,   22,  178,   22,
       22,  182,  191,   22,  101,  182,  191,  175,  113,   22,
      203,  183,  192,  203,  203,   22,  174,  203,  217,  173,
      204,  217,  217,  204,  172,  217,  226,  171,  218,  231,
      226,  218,  170,  231,  226,  169,  227,  231,  226,  232,
      168,  231,  253,  167,  227,  253,  253,  232,  166,  253,

      259,  165,  254,  259,  259,  254,  164,  259,  278,  163,
      260,  278,  278,  260,  162,  278,  281,  160,  279,  281,
      281,  279,  159,  281,  158,  157,  282,  156,  155,  282,
       22,  154,  153,   22,  152,   22,   22,   23,  151,   23,
       23,  150,   23,   27,   27,  149,   27,  148,   27,   27,
       24,  147,  146,  145,  144,  143,   24,   28,   28,  142,
      141,  140,   28,   28,   79,   79,  139,   79,  138,   79,
       79,   80,   80,  137,  136,  135,   80,   80,   81,   81,
      134,   81,  133,   81,   81,   82,   82,  132,  131,  130,
       82,   82,  161,  161,  129,  128,  127,  161,  161,  126,

      124,  123,  122,  121,  120,  119,  118,  117,  116,  115,
      114,  112,  111,  110,  109,  108,  107,  106,  105,  102,
      100,   99,   98,   91,   89,   86,   84,   78,   76,   69,
      283,   26,  283,    3,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283
    } ;

static yyconst short int yy_chk[675] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        4,    5,    9,    4,    9,    5,    9,   10,  277,  275,
       10,   77,   11,   10,   10,   11,    4,    4,   77,   11,
        9,    9,   13,   10,   10,   13,  274,   25,   11,   11,
       12,   25,  273,   12,  272,  271,   12,   12,   13,   13,
       12,   14,  270,  268,   14,   92,   12,   12,   13,   92,
       15,   82,   12,   15,  267,   82,   82,   14,   14,   14,

       16,   16,  266,  265,   16,  264,   15,   15,   17,   17,
      263,   27,   17,   27,   17,   27,   16,   18,   18,   15,
      262,   18,   21,   21,   17,  261,   21,   22,   22,   27,
       27,   22,  258,   18,  257,   29,   29,  256,   21,   29,
       31,   31,  252,   22,   31,   32,   32,  251,  250,   32,
      249,   29,   33,   33,   33,   33,   31,  247,   33,   34,
       34,   32,  193,   34,   35,   35,  193,  246,   35,  245,
       33,   34,   36,   36,  244,   34,   36,   37,   37,  243,
       35,   37,  242,   38,   38,  241,  240,   38,   36,   38,
      239,   39,   39,   37,   35,   39,   40,   40,   37,   38,

       40,  238,   41,   41,   41,   41,  237,   39,   41,   42,
       42,  236,   40,   42,  235,   44,   44,  234,   40,   44,
       41,   43,   43,   43,   43,   42,  165,   43,   45,   45,
      165,   44,   45,   46,   46,  233,  165,   46,  230,   43,
      229,   47,   47,   48,   45,   47,  228,   48,   48,   46,
      225,   48,   49,   49,   50,   50,   49,   47,   50,   46,
       47,  224,   50,   48,   49,   51,   51,  222,   49,   51,
       50,   52,   52,   53,   53,   52,  170,   53,   54,   54,
      170,   51,   54,  221,   56,   56,  170,   52,   56,   53,
       55,   55,   55,   55,   54,  176,   55,   57,   57,  176,

       56,   57,   58,   58,  220,  176,   58,  216,   55,  215,
       59,   59,  214,   57,   59,  213,   61,   61,   58,   62,
       61,   64,   64,   62,   62,   64,   59,   62,   58,  212,
      211,   59,   61,   63,   63,   63,  210,   64,   63,   62,
       61,   65,   65,   66,   66,   65,   64,   66,   67,  208,
       63,  207,   67,   67,   68,   68,   67,   65,   68,   66,
      206,   70,  205,  202,  201,   70,   70,  200,   67,   70,
       68,   72,  199,   72,  198,   72,   72,  197,  196,   73,
       73,   70,   68,   73,   75,   75,  195,  190,   75,   72,
       72,   73,   79,  189,   79,   73,   79,   79,  188,   81,

       75,   81,  187,   81,  186,   75,  185,  184,   83,   83,
       79,   79,   83,  181,  179,  178,  175,   81,   81,  174,
      173,   85,   86,  172,   83,   85,   85,   86,  171,   85,
      180,   86,   86,  169,  180,   83,  168,   86,   90,   90,
      180,   85,   90,  101,  101,  113,  167,  101,  166,  113,
      113,  182,  191,  113,   90,  182,  191,  164,  101,  101,
      194,  182,  191,  203,  194,  113,  163,  203,  209,  162,
      194,  217,  209,  203,  160,  217,  219,  159,  209,  223,
      219,  217,  158,  223,  226,  157,  219,  231,  226,  223,
      156,  231,  248,  155,  226,  253,  248,  231,  154,  253,

      255,  153,  248,  259,  255,  253,  152,  259,  276,  151,
      255,  278,  276,  259,  150,  278,  280,  148,  276,  281,
      280,  278,  147,  281,  146,  145,  280,  144,  143,  281,
      284,  142,  141,  284,  140,  284,  284,  285,  139,  285,
      285,  138,  285,  286,  286,  137,  286,  136,  286,  286,
      287,  135,  134,  133,  132,  131,  287,  288,  288,  130,
      129,  128,  288,  288,  289,  289,  127,  289,  126,  289,
      289,  290,  290,  125,  124,  123,  290,  290,  291,  291,
      122,  291,  121,  291,  291,  292,  292,  120,  119,  118,
      292,  292,  293,  293,  117,  116,  115,  293,  293,  114,

      112,  111,  110,  109,  108,  107,  106,  105,  104,  103,
      102,  100,   99,   98,   97,   96,   95,   94,   93,   91,
       89,   88,   87,   84,   78,   76,   74,   71,   69,   60,
       23,    7,    3,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
//#line 1 "kr_pat_scan.l"
#define INITIAL 0
//#line 2 "kr_pat_scan.l"
/*****************************************************************************
  FILE           : $Source: /projects/higgs1/SNNS/CVS/SNNS/kernel/sources/kr_pat_scan.c,v $
  SHORTNAME      : pattern scanner
  SNNS VERSION   : 4.2

  PURPOSE        : pattern file scanner, lex file
  NOTES          : preliminary

  AUTHOR         : Michael Vogt
  DATE           : 10.9.93

  CHANGED BY     : 
  RCS VERSION    : $Revision: 2.7 $
  LAST CHANGE    : $Date: 1998/04/08 09:16:54 $

    Copyright (c) 1990-1998  SNNS Group, IPVR, Univ. Stuttgart, Germany

******************************************************************************/

#include "y.tab.h"
#include <stdlib.h>
#include <string.h>

#include "SnnsCLib.h"

/*
#include "glob_typ.h"
#include "kr_typ.h"
#include "kernel.h"
#include "kr_newpattern.h"
#include "kr_pat_parse.h"
#include "kr_pat_scan.ph"
*/

//#line 653 "lex.yy.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

/* 
#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif*/

int yywrap() { return 1; }

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

//#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
//#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
//#define ECHO unsigned int xx_res_not_used = fwrite( yytext, yyleng, 1, yyout )
//#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

//YY_DECL
int SnnsCLib::yylex YY_PROTO(( void ))
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

        unsigned int xx_res_not_used;
//#line 56 "kr_pat_scan.l"


//#line 807 "lex.yy.c"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 284 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 634 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
//#line 59 "kr_pat_scan.l"
case 2:
YY_RULE_SETUP
//#line 59 "kr_pat_scan.l"
;
	YY_BREAK
case 3:
//#line 62 "kr_pat_scan.l"
case 4:
//#line 63 "kr_pat_scan.l"
case 5:
YY_RULE_SETUP
//#line 63 "kr_pat_scan.l"
lineno++;
	YY_BREAK
case 6:
YY_RULE_SETUP
//#line 65 "kr_pat_scan.l"
return(0); /* end of text */
	YY_BREAK
case 7:
YY_RULE_SETUP
//#line 67 "kr_pat_scan.l"
return(L_BRACKET);
	YY_BREAK
case 8:
YY_RULE_SETUP
//#line 69 "kr_pat_scan.l"
return(R_BRACKET);
	YY_BREAK
case 9:
YY_RULE_SETUP
//#line 71 "kr_pat_scan.l"
{
					s_dotpos = strchr((char *) yytext, '.');
					*s_dotpos = '\0';
					yylval.version.v = 
						atoi((char *) yytext+1);
					yylval.version.r =
						atoi((char *) s_dotpos+1);
					return(V_NUMBER);
				        }
	YY_BREAK
case 10:
//#line 82 "kr_pat_scan.l"
case 11:
//#line 83 "kr_pat_scan.l"
case 12:
//#line 84 "kr_pat_scan.l"
case 13:
YY_RULE_SETUP
//#line 84 "kr_pat_scan.l"
{
                                                    if (numbers_as_names)
						    {
							yylval.name = strdup(yytext);
							return(NAME);
						    }
						    else
						    {
							yylval.value=atof((char *) yytext);
							return(NUMBER);
						    }
						}
	YY_BREAK
case 14:
YY_RULE_SETUP
//#line 97 "kr_pat_scan.l"
return(VERSION_HEADER);
	YY_BREAK
case 15:
YY_RULE_SETUP
//#line 99 "kr_pat_scan.l"
return(GENERATED_AT);
	YY_BREAK
case 16:
YY_RULE_SETUP
//#line 101 "kr_pat_scan.l"
return(NO_OF_PATTERN);
	YY_BREAK
case 17:
YY_RULE_SETUP
//#line 103 "kr_pat_scan.l"
return(NO_OF_INPUT);
	YY_BREAK
case 18:
YY_RULE_SETUP
//#line 105 "kr_pat_scan.l"
return(NO_OF_OUTPUT);
	YY_BREAK
case 19:
YY_RULE_SETUP
//#line 107 "kr_pat_scan.l"
return(NO_OF_VAR_IDIM);
	YY_BREAK
case 20:
YY_RULE_SETUP
//#line 109 "kr_pat_scan.l"
return(NO_OF_VAR_ODIM);
	YY_BREAK
case 21:
YY_RULE_SETUP
//#line 111 "kr_pat_scan.l"
return(MAXIMUM_IDIM);
	YY_BREAK
case 22:
YY_RULE_SETUP
//#line 113 "kr_pat_scan.l"
return(MAXIMUM_ODIM);
	YY_BREAK
case 23:
YY_RULE_SETUP
//#line 115 "kr_pat_scan.l"
return(NO_OF_CLASSES);
	YY_BREAK
case 24:
YY_RULE_SETUP
//#line 117 "kr_pat_scan.l"
return(CLASS_REDISTRIB);
	YY_BREAK
case 25:
YY_RULE_SETUP
//#line 119 "kr_pat_scan.l"
return(REMAPFUNCTION);
	YY_BREAK
case 26:
YY_RULE_SETUP
//#line 121 "kr_pat_scan.l"
return(REMAP_PARAM);
	YY_BREAK
case 27:
YY_RULE_SETUP
//#line 123 "kr_pat_scan.l"
{
                                                    yylval.name = strdup(yytext);
                                                    return(NAME);
                                                }
	YY_BREAK
case 28:
YY_RULE_SETUP
//#line 128 "kr_pat_scan.l"
return(ERROR);
	YY_BREAK
case 29:
YY_RULE_SETUP
//#line 130 "kr_pat_scan.l"
//ECHO;
        xx_res_not_used = fwrite( yytext, yyleng, 1, yyout );
        xx_res_not_used++;
	YY_BREAK
//#line 1039 "lex.yy.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 284 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 284 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 283);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
//SnnsCLib: this was removed to avoid an error of "gcc -pedantic"
//extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
           SNNSpanic(msg);
	//(void) fprintf( stderr, "%s\n", msg );
	//exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
//#line 130 "kr_pat_scan.l"


int SnnsCLib::pplex(void)
{
    int scanned;

    if (scanner_pattern_end_flag)
    {
	scanner_pattern_end_flag = 0;
	yylval.value = 0.0;
	return PATTERNEND;
    }
    else if (scanner_no_class_flag)
    {
	scanner_no_class_flag = 0;
	yylval.value = 0.0;
	return PATTERNNOCLASS;
    }
    else
    {
	scanned = yylex();
	numbers_as_names = 0;
	return scanned;
    }
}

void SnnsCLib::scanner_await_pattern_end(void)
{
    scanner_pattern_end_flag = 1;
}

void SnnsCLib::scanner_await_no_class(void)
{
    scanner_no_class_flag = 1;
}

void SnnsCLib::scanner_await_class(void)
{
    numbers_as_names = 1;
}

void SnnsCLib::scanner_init_scanner(FILE *in_file)
{
    yyin = in_file;
#ifdef FLEX_SCANNER
    yyrestart(yyin);
#endif
    scanner_pattern_end_flag = 0;
    scanner_no_class_flag = 0;
    numbers_as_names = 0;
}
