% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym_regression.R
\name{sym.gbm}
\alias{sym.gbm}
\title{Generalized Boosted Symbolic Regression}
\usage{
sym.gbm(
  formula,
  sym.data,
  method = c("cm", "crm"),
  distribution = "gaussian",
  interaction.depth = 1,
  n.trees = 500,
  shrinkage = 0.1
)
}
\arguments{
\item{formula}{A symbolic description of the model to be fit. The formula may include an offset term (e.g. y~offset(n)+x). If keep.data = FALSE in the initial call to gbm then it is the user's responsibility to resupply the offset to gbm.more.}

\item{sym.data}{symbolic data table}

\item{method}{cm crm}

\item{distribution}{distribution}

\item{interaction.depth}{Integer specifying the maximum depth of each tree (i.e., the highest level of variable interactions allowed). A value of 1 implies an additive model, a value of 2 implies a model with up to 2-way interactions, etc. Default is 1.}

\item{n.trees}{Integer specifying the total number of trees to fit. This is equivalent to the number of iterations and the number of basis functions in the additive expansion. Default is 100.}

\item{shrinkage}{A shrinkage parameter applied to each tree in the expansion. Also known as the learning rate or step-size reduction; 0.001 to 0.1 usually work, but a smaller learning rate typically requires more trees. Default is 0.1.}
}
\description{
Generalized Boosted Symbolic Regression
}
\references{
Lima-Neto, E.A., De Carvalho, F.A.T., (2008). Centre and range method to fitting a linear regression model on symbolic interval data. Computational Statistics and Data Analysis52, 1500-1515


Lima-Neto, E.A., De Carvalho, F.A.T., (2010). Constrained linear regression models for symbolic interval-valued variables.  Computational Statistics and Data Analysis 54, 333-347


Lima Neto, E.d.A., de Carvalho, F.d.A.T. Nonlinear regression applied to interval-valued data. Pattern Anal Applic 20, 809–824 (2017). https://doi.org/10.1007/s10044-016-0538-y


Rodriguez, O. (2018). Shrinkage linear regression for symbolic interval-valued variables.Journal MODULAD 2018, vol. Modulad 45, pp.19-38
}
