% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRlog.R
\name{anova.RRlog}
\alias{anova.RRlog}
\title{Analysis of Deviance for Logistic RR Regression Models}
\usage{
\method{anova}{RRlog}(object, ...)
}
\arguments{
\item{object}{object of class \code{RRlog}, that is, logistic RR regression models fitted with the function \code{\link{RRlog}}.}

\item{...}{a second \code{RRlog} model}
}
\description{
Compute an analysis of deviance table for two logistic RR regression models.
}
\examples{
# generate data
n <- 500
x <- data.frame(x1 = rnorm(n))
pi.true <- 1 / (1 + exp(.3 + 1.5 * x$x1))
true <- rbinom(n, 1, plogis(pi.true))
dat <- RRgen(n, trueState = true, model = "Warner", p = .1)
x$response <- dat$response

# fit and plot RR logistic regression
mod1 <- RRlog(response ~ x1, data = x, model = "Warner", p = .1)
mod0 <- RRlog(response ~ 1, data = x, model = "Warner", p = .1)
anova(mod1, mod0)

}
\author{
Daniel W. Heck
}
