% Generated by roxygen2 (4.0.2): do not edit by hand
\name{RRcor}
\alias{RRcor}
\title{Bivariate correlations including randomized response variables}
\usage{
RRcor(x, y = NULL, models, p.list, group = NULL, bs.n = 0,
  bs.type = c("n", "p"), nCPU = 1)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{\code{NULL} (default) or a vector, matrix or data frame with compatible dimensions to \code{x}.}

\item{models}{a vector defining which RR design is used for each variable. Must be in the same order as variables appear in \code{x} and \code{y} (by columns). Available models: \code{Warner}, \code{Kuk}, \code{FR}, \code{Mangat}, \code{UQTknown}, \code{UQTunknown}, \code{Crosswise}, \code{SLD} and \code{direct} (i.e., no randomized response design)}

\item{p.list}{a \code{list} containing the randomization probabilities of the RR models defined in \code{models}. Either, all \code{direct}-variables (i.e., no randomized response) in \code{models} can be excluded in \code{p.list}; or, if specified, randomization probabilities \code{p} are ignored for \code{direct}-variables.}

\item{group}{a matrix defining the group membership of each participant (values 1 and 2) for all multiple group models(\code{SLD}, \code{UQTunknown}). If only one of these models is included in \code{models}, a vector can be used. For more than one model, each column should contain one grouping variable}

\item{bs.n}{number of samples used to get bootstrapped standard errors}

\item{bs.type}{Choose between parametric (\code{p}) and/or nonparametric (\code{n}) bootstrap to obtain standard errors (note: \code{bs.n} has to be larger than 0). The parametric bootstrap is based on the assumption, that the continuous variable is normally distributed within each group defined by the true state of the RR variable. For polytomous forced response (FR) designs, the RR variable is assumed to have equally spaced distances between categories (i.e., that it is interval scaled)}

\item{nCPU}{number of CPUs used for the bootstrap}
}
\value{
an object \code{RRcor}, can be analyzed by means of \code{\link{summary}}. Use \code{object$r} to get the correlation matrix only.
}
\description{
\code{RRcor} calculates bivariate Pearson correlations of variables measured with or without RR.
}
\details{
Correlations of RR variables are calculated by the method of Fox & Tracy (1984) by interpreting the variance induced by the RR procedure as uncorrelated measurement error. Since the error is independent, the correlation can be corrected to obtain an unbiased estimator.
}
\examples{
# generate first RR variable
n <-1000
p1 <- c(.4,.6)
gData <- RRgen(n,pi=.3,model="Kuk",p1)
n1 <- table(gData$true)[1]
gData[gData$true==0,4] <-  rnorm(n1)
gData[gData$true==1,4] <-  rnorm(n-n1,mean=0.7)

# generate second RR variable
p2 <- c(.7,.4)
temp <- RRgen(n1,pi=.2,model="UQTknown",p2)
gData$uqtResponse[gData$true==0] <- temp$response
gData$uqtTrue[gData$true==0] <- temp$true
temp <- RRgen(n-n1,pi=.7,model="Kuk",p2)
gData$uqtResponse[gData$true==1] <- temp$response
gData$uqtTrue[gData$true==1] <- temp$true

# show true correlation
cor(gData[,c("true","V4","uqtTrue")])
# estimated correlation
RRcor(x=gData[,c("response","V4","uqtTrue")],models=c("Kuk","d","UQTknown"),p.list= list(p1,p2) )
}
\references{
Fox, J. A., & Tracy, P. E. (1984). Measuring associations with randomized response. \emph{Social Science Research, 13}, 188-197.
}
\seealso{
\code{vignette('RRreg')} or \url{https://dl.dropboxusercontent.com/u/21456540/RRreg/index.html} for a detailed description of the RR models and the appropriate definition of \code{p}
}

