% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{norm_finder}
\alias{norm_finder}
\title{norm_finder}
\usage{
norm_finder(
  data,
  candidates,
  save.to.txt = FALSE,
  name.txt = "NormFinder_results"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() functions.}

\item{candidates}{Character: vector of names of genes - candidates for reference gene.}

\item{save.to.txt}{Logical: if TRUE, returned table with results will be saved to .txt file. Default to FALSE.}

\item{name.txt}{Character: name of saved .txt file, without ".txt" name of extension. Default to "norm_finder_results".}
}
\value{
Table with calculated stability score; the lowest value the best candidate for reference gene.
}
\description{
This function calculates stability scores using NormFinder algorithm (https://www.moma.dk/software/normfinder)
published in https://aacrjournals.org/cancerres/article/64/15/5245/511517/Normalization-of-Real-Time-Quantitative-Reverse.
This function is internally used by other RQdeltaCT package function, find_ref_gene(); therefore norm_finder() function does not need to be used separately.
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
reference.stability.nF <- norm_finder(data.CtF.ready,
                                      candidates = c("Gene4",
                                                     "Gene8",
                                                     "Gene10",
                                                     "Gene16",
                                                     "Gene17",
                                                     "Gene18"))
}
