#' @title RQGIS: Integrating R with QGIS
#'   
#' @description RQGIS establishes an interface between R and 'QGIS', i.e. it 
#'   allows the user to access 'QGIS' functionalities from the R console. It 
#'   achieves this by using the QGIS' Python API via the command line. Hence, 
#'   RQGIS extends R's statistical power by the incredible vast 
#'   geo-functionality of 'QGIS' (including also 'GDAL', 'SAGA'- and 'GRASS'-GIS
#'   among other third-party providers). This in turn creates a powerful 
#'   environment for advanced and innovative (geo-)statistical geocomputing. 
#'   'QGIS' is licensed under GPL version 2 or greater and is available from 
#'   <http://www.qgis.org/en/site/>. Before running RQGIS you need to make sure 
#'   to have installed correctly all external software such as QGIS, GRASS and 
#'   SAGA.
#' @details Our vignette helps to correctly install all third-party 
#'   dependencies (e.g., QGIS, GRASS, SAGA):\cr\cr
#'   `vignette("install_guide", package = "RQGIS")` \cr\cr
#'   To get started with RQGIS, have a peak at the example on our github
#'   page:\cr\cr
#'   <https://github.com/jannes-m/RQGIS>
"_PACKAGE"