% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{updateNifti}
\alias{updateNifti}
\title{Update an internal NIfTI-1 object using a template}
\usage{
updateNifti(image, template = NULL)
}
\arguments{
\item{image}{A numeric array.}

\item{template}{An image, in any acceptable form (see
\code{\link{retrieveNifti}}), or a named list of NIfTI-1 properties like
that produced by \code{\link{dumpNifti}}. The default of \code{NULL} will
have no effect.}
}
\value{
A copy of the original \code{image}, with its internal image
  attribute set or updated appropriately.
}
\description{
This function adds or updates the internal NIfTI-1 object for an array,
using metadata from the template. The dimensions and, if available, pixel
dimensions, from the \code{image} will replace those from the template.
}
\author{
Jon Clayden <code@clayden.org>
}
