/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed;

import gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed.ExtensionMapper;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed.ObjectTypeSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;

public class ObjectType
implements ADBBean {
    protected ObjectTypeSequence[] localObjectTypeSequence;
    protected boolean localObjectTypeSequenceTracker = false;
    protected String localType;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed")) {
            return "ns1";
        }
        return BeanUtil.getUniquePrefix();
    }

    public ObjectTypeSequence[] getObjectTypeSequence() {
        return this.localObjectTypeSequence;
    }

    protected void validateObjectTypeSequence(ObjectTypeSequence[] param) {
    }

    public void setObjectTypeSequence(ObjectTypeSequence[] param) {
        this.validateObjectTypeSequence(param);
        this.localObjectTypeSequenceTracker = param != null;
        this.localObjectTypeSequence = param;
    }

    public void addObjectTypeSequence(ObjectTypeSequence param) {
        if (this.localObjectTypeSequence == null) {
            this.localObjectTypeSequence = new ObjectTypeSequence[0];
        }
        this.localObjectTypeSequenceTracker = true;
        List list = ConverterUtil.toList((Object[])this.localObjectTypeSequence);
        list.add(param);
        this.localObjectTypeSequence = list.toArray(new ObjectTypeSequence[list.size()]);
    }

    public String getType() {
        return this.localType;
    }

    public void setType(String param) {
        this.localType = param;
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    public OMElement getOMElement(QName parentQName, final OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName){

            public void serialize(MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
                ObjectType.this.serialize(this.parentQName, factory, xmlWriter);
            }
        };
        return new OMSourcedElementImpl(parentQName, factory, (OMDataSource)dataSource);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, factory, xmlWriter, false);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = null;
        String namespace = null;
        prefix = parentQName.getPrefix();
        namespace = parentQName.getNamespaceURI();
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = ObjectType.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        if (serializeType) {
            String namespacePrefix = this.registerPrefix((XMLStreamWriter)xmlWriter, "http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":ObjectType", (XMLStreamWriter)xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "ObjectType", (XMLStreamWriter)xmlWriter);
            }
        }
        if (this.localType == null) {
            throw new ADBException("required attribute localType is null");
        }
        this.writeAttribute("", "Type", ConverterUtil.convertToString((String)this.localType), (XMLStreamWriter)xmlWriter);
        if (this.localObjectTypeSequenceTracker) {
            if (this.localObjectTypeSequence != null) {
                for (int i = 0; i < this.localObjectTypeSequence.length; ++i) {
                    if (this.localObjectTypeSequence[i] == null) continue;
                    this.localObjectTypeSequence[i].serialize(null, factory, xmlWriter);
                }
            } else {
                throw new ADBException("ObjectTypeSequence cannot be null!!");
            }
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = ObjectType.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString((QName)qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = ObjectType.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString((QName)qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = ObjectType.generatePrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    public XMLStreamReader getPullParser(QName qName) throws ADBException {
        ArrayList<Object> elementList = new ArrayList<Object>();
        ArrayList<Object> attribList = new ArrayList<Object>();
        if (this.localObjectTypeSequenceTracker) {
            if (this.localObjectTypeSequence != null) {
                for (int i = 0; i < this.localObjectTypeSequence.length; ++i) {
                    if (this.localObjectTypeSequence[i] == null) continue;
                    elementList.add(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "ObjectTypeSequence"));
                    elementList.add(this.localObjectTypeSequence[i]);
                }
            } else {
                throw new ADBException("ObjectTypeSequence cannot be null!!");
            }
        }
        attribList.add(new QName("", "Type"));
        attribList.add(ConverterUtil.convertToString((String)this.localType));
        return new ADBXMLStreamReaderImpl(qName, elementList.toArray(), attribList.toArray());
    }

    public static class Factory {
        public static ObjectType parse(XMLStreamReader reader) throws Exception {
            ObjectType object = new ObjectType();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                String fullTypeName;
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                    String nsPrefix = null;
                    if (fullTypeName.indexOf(":") > -1) {
                        nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                    }
                    nsPrefix = nsPrefix == null ? "" : nsPrefix;
                    String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                    if (!"ObjectType".equals(type)) {
                        String nsUri = reader.getNamespaceContext().getNamespaceURI(nsPrefix);
                        return (ObjectType)ExtensionMapper.getTypeObject(nsUri, type, reader);
                    }
                }
                Vector<String> handledAttributes = new Vector<String>();
                String tempAttribType = reader.getAttributeValue(null, "Type");
                if (tempAttribType == null) {
                    throw new ADBException("Required attribute Type is missing");
                }
                String content = tempAttribType;
                object.setType(ConverterUtil.convertToString((String)tempAttribType));
                handledAttributes.add("Type");
                reader.next();
                ArrayList<ObjectTypeSequence> list1 = new ArrayList<ObjectTypeSequence>();
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                try {
                    if (reader.isStartElement()) {
                        list1.add(ObjectTypeSequence.Factory.parse(reader));
                        boolean loopDone1 = false;
                        while (!loopDone1) {
                            while (!reader.isStartElement() && !reader.isEndElement()) {
                                reader.next();
                            }
                            if (reader.isEndElement()) {
                                loopDone1 = true;
                                continue;
                            }
                            list1.add(ObjectTypeSequence.Factory.parse(reader));
                        }
                        object.setObjectTypeSequence((ObjectTypeSequence[])ConverterUtil.convertToArray(ObjectTypeSequence.class, list1));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement()) {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

