% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbBind_MariaDBResult.R,
%   R/dbClearResult_MariaDBResult.R, R/dbFetch_MariaDBResult.R,
%   R/dbGetStatement_MariaDBResult.R,
%   R/dbSendQuery_MariaDBConnection_character.R,
%   R/dbSendStatement_MariaDBConnection_character.R
\name{query}
\alias{query}
\alias{dbBind_MariaDBResult}
\alias{dbBind,MariaDBResult-method}
\alias{dbClearResult_MariaDBResult}
\alias{dbClearResult,MariaDBResult-method}
\alias{dbFetch_MariaDBResult}
\alias{dbFetch,MariaDBResult-method}
\alias{dbGetStatement_MariaDBResult}
\alias{dbGetStatement,MariaDBResult-method}
\alias{dbSendQuery_MariaDBConnection_character}
\alias{dbSendQuery,MariaDBConnection,character-method}
\alias{dbSendStatement_MariaDBConnection_character}
\alias{dbSendStatement,MariaDBConnection,character-method}
\title{Execute a SQL statement on a database connection.}
\usage{
\S4method{dbBind}{MariaDBResult}(res, params, ...)

\S4method{dbClearResult}{MariaDBResult}(res, ...)

\S4method{dbFetch}{MariaDBResult}(res, n = -1, ..., row.names = FALSE)

\S4method{dbGetStatement}{MariaDBResult}(res, ...)

\S4method{dbSendQuery}{MariaDBConnection,character}(conn, statement, params = NULL, ..., immediate = FALSE)

\S4method{dbSendStatement}{MariaDBConnection,character}(conn, statement, params = NULL, ..., immediate = FALSE)
}
\arguments{
\item{res}{A \linkS4class{MariaDBResult} object.}

\item{params}{A list of query parameters to be substituted into
a parameterised query.}

\item{...}{Unused. Needed for compatibility with generic.}

\item{n}{Number of rows to retrieve. Use -1 to retrieve all rows.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{conn}{A \linkS4class{MariaDBConnection} object.}

\item{statement}{A character vector of length one specifying the SQL
statement that should be executed.  Only a single SQL statement should be
provided.}

\item{immediate}{If TRUE, uses the \code{mysql_real_query()} API
instead of \code{mysql_stmt_init()}.
This allows passing multiple statements (with \link{CLIENT_MULTI_STATEMENTS})
and turns off the ability to pass parameters.}
}
\description{
To retrieve results a chunk at a time, use \code{\link[=dbSendQuery]{dbSendQuery()}},
\code{\link[=dbFetch]{dbFetch()}}, then \code{\link[=dbClearResult]{dbClearResult()}}. Alternatively, if you want all the
results (and they'll fit in memory) use \code{\link[=dbGetQuery]{dbGetQuery()}} which sends,
fetches and clears for you. For data manipulation queries (i.e. queries
that do not return data, such as \code{UPDATE}, \code{DELETE}, etc.),
\code{\link[=dbSendStatement]{dbSendStatement()}} serves as a counterpart to \code{\link[=dbSendQuery]{dbSendQuery()}}, while
\code{\link[=dbExecute]{dbExecute()}} corresponds to \code{\link[=dbGetQuery]{dbGetQuery()}}.
}
\examples{
if (mariadbHasDefault()) {
  con <- dbConnect(RMariaDB::MariaDB(), dbname = "test")
  dbWriteTable(con, "arrests", datasets::USArrests, temporary = TRUE)

  # Run query to get results as dataframe
  dbGetQuery(con, "SELECT * FROM arrests limit 3")

  # Send query to pull requests in batches
  res <- dbSendQuery(con, "SELECT * FROM arrests")
  data <- dbFetch(res, n = 2)
  data
  dbHasCompleted(res)

  dbClearResult(res)
  dbDisconnect(con)
}
}
