\name{getDailyMean}
\alias{getDailyMean}
\title{getDailyMean}
\usage{getDailyMean(data, year_min=1961, year_max=1990, station=c("T0001",
    "T0010"), origin="1961-1-1", lag=5)}
\description{Calculates the daily means of a data frame corresponding to a period between \code{year_min} and \code{year_max}  for stations listed in \code{station}}
\author{Emanuele Cordano, Emanuele Eccel}
\value{a matrix containing the requested daily mean data where each day corresponds to a row and each station corresponds to a column}
\seealso{\code{\link{extractyears}}}
\note{The input data frame \code{data} must have the following fields: \code{year,month,day,variables_ID1,variables_ID2,...} 
where the fields \code{,variables_ID1,variables_ID2,...} contain the daily variables referred to the respective stations and the field names are replaced with the respective station ID.}
\arguments{\item{data}{a data frame containing daily data.}
\item{year_min}{start year}
\item{year_max}{end year}
\item{station}{character vector of the IDs of the station where the data are requested}
\item{origin}{origin date of time-series}
\item{lag}{lag (number of days) on which daily mean is calculated. The mean is calculated considereing \code{lag} days before and after each day.}}
