/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.ICache;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.ResultSetTripleIterator;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.db.impl.SimpleCache;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PSet_TripleStore_RDB
implements IPSet {
    public String m_tblName = null;
    protected String ID_SQL_TYPE = null;
    protected boolean SKIP_DUPLICATE_CHECK = false;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected SQLCache m_sql = null;
    protected static final int DEFAULT_CACHE = 1000;
    protected ICache literalCache = new SimpleCache(1000);
    protected ICache resourceCache = new SimpleCache(1000);
    protected IRDBDriver m_driver = null;
    protected static Log logger = LogFactory.getLog((Class)PSet_TripleStore_RDB.class);

    public void setDriver(IRDBDriver driver) throws RDFRDBException {
        this.m_driver = driver;
    }

    public void setSQLType(String value) {
        this.ID_SQL_TYPE = value;
    }

    public void setSkipDuplicateCheck(boolean value) {
        this.SKIP_DUPLICATE_CHECK = value;
    }

    public void setSQLCache(SQLCache cache) {
        this.m_sql = cache;
    }

    public SQLCache getSQLCache() {
        return this.m_sql;
    }

    public void setCachePreparedStatements(boolean value) {
        this.CACHE_PREPARED_STATEMENTS = value;
    }

    public void setTblName(String tblName) {
        this.m_tblName = tblName;
    }

    public String getTblName() {
        return this.m_tblName;
    }

    public void close() {
    }

    public IRDBDriver driver() {
        return this.m_driver;
    }

    public void cleanDB() {
        try {
            this.m_sql.runSQLGroup("dropStatementTable", this.getTblName());
        }
        catch (SQLException e) {
            logger.warn((Object)("Problem dropping table " + this.getTblName()), (Throwable)e);
            throw new RDFRDBException("Failed to drop table ", e);
        }
    }

    public String toString() {
        return this.getClass().getPackage().getName();
    }

    public Node_Literal getLiteralFromCache(IDBID id) {
        return (Node_Literal)this.literalCache.get(id);
    }

    public IDBID wrapDBID(Object id) throws RDFRDBException {
        if (id instanceof Number) {
            return new DBIDInt(((Number)id).intValue());
        }
        if (id == null) {
            return null;
        }
        throw new RDFRDBException("Unexpected DB identifier type: " + id);
    }

    public int rowCount(int gid) {
        String tName = this.getTblName();
        int result = 0;
        ResultSet rs = null;
        try {
            String op = "getRowCount";
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement(op, tName);
            ps.setInt(1, gid);
            rs = ps.executeQuery();
            while (rs.next()) {
                result = rs.getInt(1);
            }
            this.m_sql.returnPreparedSQLStatement(ps);
        }
        catch (SQLException e) {
            logger.debug((Object)("tried to count rows in " + tName));
            logger.debug((Object)"Caught exception: ", (Throwable)e);
            throw new JenaException("Exception during database access", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e1) {
                    throw new RDFRDBException("Failed to get last inserted ID: " + e1);
                }
            }
        }
        return result;
    }

    public Triple extractTripleFromRowData(String subj, String pred, String obj) {
        Node subjNode = subj == null ? null : this.m_driver.RDBStringToNode(subj);
        Node predNode = pred == null ? null : this.m_driver.RDBStringToNode(pred);
        Node objNode = obj == null ? null : this.m_driver.RDBStringToNode(obj);
        return Triple.create(subjNode, predNode, objNode);
    }

    public Object wrapFlag(boolean flag) {
        return flag ? new Short(1) : new Short(0);
    }

    public void deleteTriple(Triple t, IDBID graphID) {
        this.deleteTriple(t, graphID, false, null);
    }

    public void deleteTriple(Triple t, IDBID graphID, boolean isBatch, Hashtable batchedPreparedStatements) {
        this.deleteTripleAR(t, graphID, null, isBatch, batchedPreparedStatements);
    }

    public void deleteTripleAR(Triple t, IDBID graphID, Node reifNode, boolean isBatch, Hashtable batchedPreparedStatements) {
        boolean isReif = reifNode != null;
        String subj = t.getSubject().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(t.getSubject(), false);
        String pred = t.getPredicate().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(t.getPredicate(), false);
        String obj = t.getObject() == Node.ANY ? null : this.m_driver.nodeToRDBString(t.getObject(), false);
        int gid = ((DBIDInt)graphID).getIntID();
        int argc = 1;
        if (subj == null || pred == null || obj == null) {
            return;
        }
        PreparedStatement ps = null;
        String stmtStr = isReif ? "deleteReified" : "deleteStatement";
        try {
            ps = this.getPreparedStatement(stmtStr, this.getTblName(), isBatch, batchedPreparedStatements);
        }
        catch (SQLException e1) {
            logger.debug((Object)("SQLException caught " + e1.getErrorCode()), (Throwable)e1);
            throw new JenaException("Exception during database access", e1);
        }
        try {
            ps.setString(argc++, subj);
            ps.setString(argc++, pred);
            ps.setString(argc++, obj);
            ps.setInt(argc++, gid);
            if (isReif) {
                String stmtURI = this.m_driver.nodeToRDBString(reifNode, false);
                ps.setString(argc++, stmtURI);
                ps.setString(argc++, "T");
            }
        }
        catch (SQLException e1) {
            logger.debug((Object)"(in delete) SQLException caught ", (Throwable)e1);
            throw new JenaException("Exception during database access", e1);
        }
        try {
            if (isBatch) {
                ps.addBatch();
            } else {
                ps.executeUpdate();
                this.m_sql.returnPreparedSQLStatement(ps);
            }
        }
        catch (SQLException e1) {
            logger.error((Object)"Exception executing delete: ", (Throwable)e1);
            throw new JenaException("Exception during database access", e1);
        }
    }

    public void storeTriple(Triple t, IDBID graphID) {
        this.storeTriple(t, graphID, false, null);
    }

    public PreparedStatement getPreparedStatement(String op, String tableName, boolean isBatch, Hashtable batchedPreparedStatements) throws SQLException {
        PreparedStatement ps = null;
        String opname = SQLCache.concatOpName(op, tableName);
        if (isBatch) {
            ps = (PreparedStatement)batchedPreparedStatements.get(opname);
            if (ps == null) {
                ps = this.m_sql.getPreparedSQLStatement(op, tableName);
                batchedPreparedStatements.put(opname, ps);
            }
        } else {
            ps = this.m_sql.getPreparedSQLStatement(op, tableName);
        }
        if (ps == null) {
            logger.error((Object)("prepared statement not found for " + opname));
        }
        return ps;
    }

    public void storeTriple(Triple t, IDBID graphID, boolean isBatch, Hashtable batchedPreparedStatements) {
        this.storeTripleAR(t, graphID, null, false, isBatch, batchedPreparedStatements);
    }

    public void storeTripleAR(Triple t, IDBID graphID, Node reifNode, boolean hasType, boolean isBatch, Hashtable batchedPreparedStatements) {
        block19: {
            boolean isReif;
            boolean bl = isReif = reifNode != null;
            if (!this.SKIP_DUPLICATE_CHECK && !isReif && this.statementTableContains(graphID, t)) {
                return;
            }
            String subj = t.getSubject().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(t.getSubject(), true);
            String pred = t.getPredicate().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(t.getPredicate(), true);
            String obj = t.getObject().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(t.getObject(), true);
            int gid = ((DBIDInt)graphID).getIntID();
            int argc = 1;
            if (!(subj != null && pred != null && obj != null || isReif)) {
                throw new JenaException("Attempt to assert triple with missing values");
            }
            PreparedStatement ps = null;
            String stmtStr = isReif ? "insertReified" : "insertStatement";
            try {
                ps = this.getPreparedStatement(stmtStr, this.getTblName(), isBatch, batchedPreparedStatements);
            }
            catch (SQLException e1) {
                logger.debug((Object)("SQLException caught " + e1.getErrorCode()), (Throwable)e1);
                throw new JenaException("Exception during database access", e1);
            }
            try {
                if (subj == null) {
                    ps.setNull(argc++, 12);
                } else {
                    ps.setString(argc++, subj);
                }
                if (pred == null) {
                    ps.setNull(argc++, 12);
                } else {
                    ps.setString(argc++, pred);
                }
                if (obj == null) {
                    ps.setNull(argc++, 12);
                } else {
                    ps.setString(argc++, obj);
                }
                ps.setInt(argc++, gid);
                if (isReif) {
                    String stmtURI = this.m_driver.nodeToRDBString(reifNode, true);
                    ps.setString(argc++, stmtURI);
                    if (hasType) {
                        ps.setString(argc++, "T");
                    } else {
                        ps.setString(argc++, " ");
                    }
                }
            }
            catch (SQLException e1) {
                logger.debug((Object)("SQLException caught " + e1.getErrorCode()), (Throwable)e1);
                throw new JenaException("Exception during database access", e1);
            }
            try {
                if (isBatch) {
                    ps.addBatch();
                } else {
                    ps.executeUpdate();
                    this.m_sql.returnPreparedSQLStatement(ps);
                }
            }
            catch (SQLException e1) {
                if (e1.getErrorCode() == 1 && this.m_driver.getDatabaseType().equalsIgnoreCase("oracle")) break block19;
                logger.error((Object)("SQLException caught during insert" + e1.getErrorCode()), (Throwable)e1);
                throw new JenaException("Exception during database access", e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void storeTripleList(List triples, IDBID my_GID) {
        autoState = false;
        drvr = (DriverRDB)this.m_driver;
        it = triples.iterator();
        batchedPreparedStatements = null;
        if (!this.SKIP_DUPLICATE_CHECK) {
            while (it.hasNext()) {
                t = (Triple)it.next();
                this.storeTriple(t, my_GID, false, null);
            }
        } else {
            try {
                autoState = drvr.xactOp(4);
                batchedPreparedStatements = new Hashtable<K, V>();
                while (it.hasNext()) {
                    t = (Triple)it.next();
                    this.storeTriple(t, my_GID, true, batchedPreparedStatements);
                }
                en = batchedPreparedStatements.keys();
                while (en.hasMoreElements()) {
                    op = (String)en.nextElement();
                    p = (PreparedStatement)batchedPreparedStatements.get(op);
                    p.executeBatch();
                    batchedPreparedStatements.remove(op);
                    this.m_sql.returnPreparedSQLStatement(p);
                }
                if (autoState) {
                    drvr.xactOp(1);
                    drvr.xactOp(5);
                }
                batchedPreparedStatements = null;
            }
            catch (BatchUpdateException b) {
                System.err.println("SQLException: " + b.getMessage());
                System.err.println("SQLState: " + b.getSQLState());
                System.err.println("Message: " + b.getMessage());
                System.err.println("Vendor: " + b.getErrorCode());
                System.err.print("Update counts: ");
                updateCounts = b.getUpdateCounts();
                for (i = 0; i < updateCounts.length; ++i) {
                    System.err.print(updateCounts[i] + " ");
                }
                if (autoState) {
                    drvr.xactOp(5);
                }
            }
            catch (SQLException ex) {
                System.err.println("SQLException: " + ex.getMessage());
                System.err.println("SQLState: " + ex.getSQLState());
                System.err.println("Message: " + ex.getMessage());
                System.err.println("Vendor: " + ex.getErrorCode());
                if (autoState) {
                    drvr.xactOp(5);
                }
            }
            finally {
                if (batchedPreparedStatements == null) ** GOTO lbl68
                en = batchedPreparedStatements.keys();
                while (en.hasMoreElements()) {
                    op = (String)en.nextElement();
                    p = (PreparedStatement)batchedPreparedStatements.get(op);
                    batchedPreparedStatements.remove(op);
                    this.m_sql.returnPreparedSQLStatement(p);
                }
            }
        }
lbl68:
        // 4 sources

        c = new ArrayList<E>(triples);
        triples.removeAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void deleteTripleList(List triples, IDBID my_GID) {
        batchedPreparedStatements = null;
        autoState = false;
        drvr = (DriverRDB)this.m_driver;
        it = triples.iterator();
        if (!this.SKIP_DUPLICATE_CHECK) {
            while (it.hasNext()) {
                t = (Triple)it.next();
                this.deleteTriple(t, my_GID, false, null);
            }
        } else {
            try {
                autoState = drvr.xactOp(4);
                batchedPreparedStatements = new Hashtable<K, V>();
                while (it.hasNext()) {
                    t = (Triple)it.next();
                    this.deleteTriple(t, my_GID, true, batchedPreparedStatements);
                }
                en = batchedPreparedStatements.keys();
                while (en.hasMoreElements()) {
                    op = (String)en.nextElement();
                    p = (PreparedStatement)batchedPreparedStatements.get(op);
                    p.executeBatch();
                    batchedPreparedStatements.remove(op);
                    this.m_sql.returnPreparedSQLStatement(p);
                }
                if (autoState) {
                    drvr.xactOp(1);
                    drvr.xactOp(5);
                }
                batchedPreparedStatements = null;
            }
            catch (BatchUpdateException b) {
                System.err.println("SQLException: " + b.getMessage());
                System.err.println("SQLState: " + b.getSQLState());
                System.err.println("Message: " + b.getMessage());
                System.err.println("Vendor: " + b.getErrorCode());
                System.err.print("Update counts: ");
                updateCounts = b.getUpdateCounts();
                for (i = 0; i < updateCounts.length; ++i) {
                    System.err.print(updateCounts[i] + " ");
                }
                if (autoState) {
                    drvr.xactOp(5);
                }
            }
            catch (SQLException ex) {
                System.err.println("SQLException: " + ex.getMessage());
                System.err.println("SQLState: " + ex.getSQLState());
                System.err.println("Message: " + ex.getMessage());
                System.err.println("Vendor: " + ex.getErrorCode());
                if (autoState) {
                    drvr.xactOp(5);
                }
            }
            finally {
                if (batchedPreparedStatements == null) ** GOTO lbl68
                en = batchedPreparedStatements.keys();
                while (en.hasMoreElements()) {
                    op = (String)en.nextElement();
                    p = (PreparedStatement)batchedPreparedStatements.get(op);
                    batchedPreparedStatements.remove(op);
                    this.m_sql.returnPreparedSQLStatement(p);
                }
            }
        }
lbl68:
        // 4 sources

        c = new ArrayList<E>(triples);
        triples.removeAll(c);
    }

    public int tripleCount(IDBID graphId) {
        int gid = ((DBIDInt)graphId).getIntID();
        return this.rowCount(gid);
    }

    public boolean statementTableContains(IDBID graphID, Triple t) {
        ExtendedIterator it = this.find(t, graphID);
        boolean res = it.hasNext();
        it.close();
        return res;
    }

    public ExtendedIterator find(TripleMatch t, IDBID graphID) {
        String astName = this.getTblName();
        Node subj_node = t.getMatchSubject();
        Node pred_node = t.getMatchPredicate();
        Node obj_node = t.getMatchObject();
        int gid = ((DBIDInt)graphID).getIntID();
        boolean notFound = false;
        boolean hack = false;
        ResultSetTripleIterator result = new ResultSetTripleIterator(this, graphID);
        PreparedStatement ps = null;
        String subj = null;
        String pred = null;
        String obj = null;
        String op = "selectStatement";
        String qual = "";
        int args = 1;
        if (hack) {
            obj_node = null;
            pred_node = null;
            subj_node = null;
        }
        if (subj_node != null) {
            subj = this.m_driver.nodeToRDBString(subj_node, false);
            if (subj == null) {
                notFound = true;
            } else {
                qual = qual + "S";
            }
        }
        if (pred_node != null) {
            pred = this.m_driver.nodeToRDBString(pred_node, false);
            if (pred == null) {
                notFound = true;
            } else {
                qual = qual + "P";
            }
        }
        if (obj_node != null) {
            obj = this.m_driver.nodeToRDBString(obj_node, false);
            if (obj == null) {
                notFound = true;
            } else {
                qual = qual + "O";
            }
        }
        if (!notFound) {
            try {
                op = op + qual;
                ps = this.m_sql.getPreparedSQLStatement(op, this.getTblName());
                if (obj != null) {
                    ps.setString(args++, obj);
                }
                if (subj != null) {
                    ps.setString(args++, subj);
                }
                if (pred != null) {
                    ps.setString(args++, pred);
                }
                ps.setInt(args++, gid);
                this.m_sql.executeSQL(ps, op, result);
            }
            catch (Exception e) {
                notFound = true;
                logger.debug((Object)("find encountered exception: args=" + args + " err: "), (Throwable)e);
                throw new JenaException("Exception during database access", e);
            }
        }
        if (notFound) {
            result.close();
        }
        return new TripleMatchIterator(t.asTriple(), (Iterator)result);
    }

    public void removeStatementsFromDB(IDBID graphID) {
        String gid = graphID.getID().toString();
        try {
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement("removeRowsFromTable", this.getTblName());
            ps.clearParameters();
            ps.setString(1, gid);
            ps.executeUpdate();
            this.m_sql.returnPreparedSQLStatement(ps);
        }
        catch (SQLException e) {
            logger.error((Object)"Problem removing statements from table: ", (Throwable)e);
            throw new JenaException("Exception during database access", e);
        }
    }
}

