/*
 * Decompiled with CFR 0.152.
 */
package kea.vocab;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import kea.stemmers.Stemmer;
import kea.stopwords.Stopwords;

public class Vocabulary
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static File SKOS;
    public static File EN;
    public static File USE;
    public static File REL;
    private boolean useSkos;
    private HashMap VocabularyEN = null;
    private HashMap VocabularyENrev = null;
    private HashMap VocabularyUSE = null;
    private HashMap VocabularyREL = null;
    private HashMap VocabularyRT = null;
    private String m_language;
    private Stemmer m_Stemmer;
    private Stopwords m_Stopwords;

    public Vocabulary(String vocabularyName, String vocabularyFormat, String documentLanguage) {
        this.m_language = documentLanguage;
        if (vocabularyFormat.equals("skos")) {
            SKOS = new File("VOCABULARIES/" + vocabularyName + ".rdf");
            if (!SKOS.exists()) {
                System.err.println("File VOCABULARIES/" + vocabularyName + ".rdf does not exist.");
                System.exit(1);
            }
            this.useSkos = true;
        } else if (vocabularyFormat.equals("text")) {
            EN = new File("VOCABULARIES/" + vocabularyName + ".en");
            USE = new File("VOCABULARIES/" + vocabularyName + ".use");
            REL = new File("VOCABULARIES/" + vocabularyName + ".rel");
            if (!EN.exists()) {
                System.err.println("File VOCABULARIES/" + vocabularyName + ".en does not exist.");
                System.exit(1);
            }
            if (!USE.exists()) {
                System.err.println("File VOCABULARIES/" + vocabularyName + ".list.use does not exist.");
                System.exit(1);
            }
            if (!REL.exists()) {
                System.err.println("File VOCABULARIES/" + vocabularyName + ".rel.p1 does not exist.");
                System.exit(1);
            }
        }
    }

    public void initialize() {
        System.err.println("-- Loading the Index...");
        if (this.useSkos) {
            try {
                this.buildSKOS();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            try {
                this.build();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public void setStemmer(Stemmer newStemmer) {
        this.m_Stemmer = newStemmer;
    }

    public void setStopwords(Stopwords newM_Stopwords) {
        this.m_Stopwords = newM_Stopwords;
    }

    public void buildSKOS() throws Exception {
        System.err.println("-- Building the Vocabulary index from SKOS file");
        this.VocabularyEN = new HashMap();
        this.VocabularyENrev = new HashMap();
        this.VocabularyUSE = new HashMap();
        this.VocabularyREL = new HashMap();
        this.VocabularyRT = new HashMap();
        Model model = ModelFactory.createDefaultModel();
        try {
            model.read((Reader)new InputStreamReader((InputStream)new FileInputStream(SKOS), "UTF-8"), "");
            int count = 1;
            StmtIterator iter = model.listStatements();
            while (iter.hasNext()) {
                Vector rt;
                String[] val_components;
                Statement stmt = iter.nextStatement();
                Resource concept = stmt.getSubject();
                String id = concept.getURI();
                Property relation = stmt.getPredicate();
                String rel = relation.getLocalName();
                RDFNode value = stmt.getObject();
                String val = value.toString();
                if (rel.equals("prefLabel")) {
                    String descriptor;
                    if (val.contains("@")) {
                        val_components = val.split("@");
                        if (!val_components[1].equals(this.m_language)) continue;
                        descriptor = val_components[0];
                    } else {
                        descriptor = val;
                    }
                    String avterm = this.pseudoPhrase(descriptor);
                    if (avterm == null) {
                        avterm = descriptor;
                    }
                    if (avterm.length() <= 1) continue;
                    this.VocabularyEN.put(avterm, id);
                    this.VocabularyENrev.put(id, descriptor);
                    continue;
                }
                if (rel.equals("altLabel") || rel.equals("hiddenLabel")) {
                    String non_descriptor;
                    if (val.contains("@")) {
                        val_components = val.split("@");
                        if (!val_components[1].equals(this.m_language)) continue;
                        non_descriptor = val_components[0];
                    } else {
                        non_descriptor = val;
                    }
                    this.addNonDescriptor(count, id, non_descriptor);
                    ++count;
                    continue;
                }
                if (!rel.equals("broader") && !rel.equals("narrower") && !rel.equals("composite") && !rel.equals("compositeOf") && !rel.equals("hasTopConcept") && !rel.equals("related")) continue;
                String id_related = val;
                if (this.VocabularyREL.get(id) == null) {
                    rt = new Vector();
                    rt.add(id_related);
                    this.VocabularyREL.put(id, rt);
                } else {
                    rt = (Vector)this.VocabularyREL.get(id);
                    rt.add(id_related);
                    this.VocabularyREL.put(id, rt);
                }
                this.VocabularyRT.put(String.valueOf(id) + "-" + id_related, rel);
                if (!rel.equals("related")) continue;
                this.VocabularyRT.put(String.valueOf(id_related) + "-" + id, rel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addNonDescriptor(int count, String id_descriptor, String non_descriptor) {
        String id_non_descriptor = "d_" + count;
        ++count;
        String avterm = this.pseudoPhrase(non_descriptor);
        if (avterm.length() > 2) {
            this.VocabularyEN.put(avterm, id_non_descriptor);
            this.VocabularyENrev.put(id_non_descriptor, non_descriptor);
        }
        this.VocabularyUSE.put(id_non_descriptor, id_descriptor);
    }

    public String remove(String[] words, int i) {
        String result = "";
        int j = 0;
        while (j < words.length) {
            if (j != i && !this.m_Stopwords.isStopword(words[j])) {
                result = String.valueOf(result) + words[j];
                if (j + 1 != words.length) {
                    result = String.valueOf(result) + " ";
                }
            }
            ++j;
        }
        return result;
    }

    public void build() throws Exception {
        System.err.println("-- Building the Vocabulary index");
        this.VocabularyEN = new HashMap();
        this.VocabularyENrev = new HashMap();
        try {
            String readline;
            InputStreamReader is = new InputStreamReader(new FileInputStream(EN));
            BufferedReader br = new BufferedReader(is);
            while ((readline = br.readLine()) != null) {
                int i = readline.indexOf(32);
                String term = readline.substring(i + 1);
                String avterm = this.pseudoPhrase(term);
                if (avterm.length() <= 2) continue;
                String id = readline.substring(0, i);
                this.VocabularyEN.put(avterm, id);
                this.VocabularyENrev.put(id, term);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildUSE() throws Exception {
        if (!this.useSkos) {
            this.VocabularyUSE = new HashMap();
            try {
                String readline;
                InputStreamReader is = new InputStreamReader(new FileInputStream(USE));
                BufferedReader br = new BufferedReader(is);
                while ((readline = br.readLine()) != null) {
                    String[] entry = this.split(readline, "\t");
                    if (entry[1].indexOf(" ") != -1) continue;
                    this.VocabularyUSE.put(entry[0], entry[1]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void buildREL() throws Exception {
        if (!this.useSkos) {
            System.err.println("-- Building the Vocabulary index with related pairs");
            this.VocabularyREL = new HashMap();
            try {
                String readline;
                InputStreamReader is = new InputStreamReader(new FileInputStream(REL));
                BufferedReader br = new BufferedReader(is);
                while ((readline = br.readLine()) != null) {
                    String[] entry = this.split(readline, "\t");
                    String[] temp = this.split(entry[1], " ");
                    Vector<String> rt = new Vector<String>();
                    int i = 0;
                    while (i < temp.length) {
                        rt.add(temp[i]);
                        ++i;
                    }
                    this.VocabularyREL.put(entry[0], rt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean containsEntry(String phrase) {
        return this.VocabularyEN.containsKey(phrase);
    }

    public String getID(String phrase) {
        String pseudo = this.pseudoPhrase(phrase);
        String id = null;
        if (pseudo != null && this.VocabularyUSE.containsKey(id = (String)this.VocabularyEN.get(pseudo))) {
            id = (String)this.VocabularyUSE.get(id);
        }
        return id;
    }

    public String getOrig(String id) {
        return (String)this.VocabularyENrev.get(id);
    }

    public String getDescriptor(String id) {
        return (String)this.VocabularyUSE.get(id);
    }

    public Vector getRelated(String id) {
        return (Vector)this.VocabularyREL.get(id);
    }

    public Vector getRelated(String id, String relation) {
        Vector<String> related = new Vector<String>();
        Vector all_related = (Vector)this.VocabularyREL.get(id);
        if (all_related != null) {
            int d = 0;
            while (d < all_related.size()) {
                String rel_id = (String)all_related.elementAt(d);
                String rel = (String)this.VocabularyRT.get(String.valueOf(id) + "-" + rel_id);
                if (rel != null) {
                    if (rel.equals(relation)) {
                        related.add(rel_id);
                    }
                } else {
                    System.err.println("Problem with " + this.getOrig(id) + " and " + this.getOrig(rel_id));
                }
                ++d;
            }
        }
        return related;
    }

    public String[] split(String str, String separator) {
        ArrayList<String> lst = new ArrayList<String>();
        String word = "";
        int i = 0;
        while (i < str.length()) {
            int j = i + 1;
            String letter = str.substring(i, j);
            if (!letter.equalsIgnoreCase(separator)) {
                word = String.valueOf(word) + str.charAt(i);
            } else {
                lst.add(word);
                word = "";
            }
            ++i;
        }
        if (word != "") {
            lst.add(word);
        }
        String[] result = lst.toArray(new String[lst.size()]);
        return result;
    }

    public String pseudoPhrase(String str) {
        String[] elements;
        if ((str = str.toLowerCase()).matches(".+?/.+?")) {
            elements = str.split("/");
            str = elements[0];
        }
        if (str.matches(".+?\\(.+?")) {
            elements = str.split("\\(");
            str = elements[0];
        }
        str = str.replace('-', ' ');
        str = str.replace('&', ' ');
        str = str.replaceAll("\\*", "");
        str = str.replaceAll("\\, ", " ");
        str = str.replaceAll("\\. ", " ");
        str = str.replaceAll("\\:", "");
        str = str.trim();
        String[] words = str.split(" ");
        String str_nostop = "";
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (!this.m_Stopwords.isStopword(word)) {
                if (word.matches(".+?\\'.+?")) {
                    String[] elements2 = word.split("\\'");
                    word = elements2[1];
                }
                str_nostop = str_nostop.equals("") ? word : String.valueOf(str_nostop) + " " + word;
            }
            ++i;
        }
        String stemmed = this.m_Stemmer.stemString(str_nostop);
        String[] pseudophrase = Vocabulary.sort(stemmed.split(" "));
        return Vocabulary.join(pseudophrase);
    }

    private static String join(String[] str) {
        String result = "";
        int i = 0;
        while (i < str.length) {
            result = result != "" ? String.valueOf(result) + " " + str[i] : str[i];
            ++i;
        }
        return result;
    }

    public static void swap(int loc1, int loc2, String[] a) {
        String temp = a[loc1];
        a[loc1] = a[loc2];
        a[loc2] = temp;
    }

    public static String[] sort(String[] a) {
        int i = 0;
        while (i < a.length - 1) {
            int firstAt = i;
            int j = i + 1;
            while (j < a.length) {
                if (a[j].toUpperCase().compareTo(a[firstAt].toUpperCase()) < 0) {
                    firstAt = j;
                }
                if (a[j].toUpperCase().compareTo(a[firstAt].toUpperCase()) == 0 && a[j].compareTo(a[firstAt]) < 0) {
                    firstAt = j;
                }
                ++j;
            }
            if (firstAt != i) {
                Vocabulary.swap(i, firstAt, a);
            }
            ++i;
        }
        return a;
    }
}

