% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset01}
\alias{dataset01}
\title{TONY FROC dataset}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1:2, 1:5, 1:185, 1:3], of non-lesion localizations, NLs}
\item{\code{LL}}{ Ratings array [1:2, 1:5, 1:89, 1:2], of lesion localizations, LLs}
\item{\code{lesionNum}}{ array [1:89], number of lesions per diseased case}
\item{\code{lesionID}}{ array [1:89, 1:2], labels of lesions on diseased cases}
\item{\code{lesionWeight}}{ array [1:89, 1:2], weights (or clinical importance) of lesions}
\item{\code{dataType}}{ "FROC", the data type}
\item{\code{modalityID}}{ [1:2] "BT" "DM", treatment labels}
\item{\code{readerID}}{ [1:5] "1" "2" "3" "4" ..., reader labels}
}}
\usage{
dataset01
}
\description{
This is referred to in the book as the "TONY" dataset. It consists of 185 cases, 
89 of which are diseased, interpreted in two treatments
("BT" = breast tomosynthesis and "DM" = digital mammography) by five radiologists using the FROC paradigm. 
The diseased cases had at most two cancers (lesions) per case while the maximum number of 
non-lesion localizations (NLs) per case, over the entire dataset, was 3. The example below displays
the wAFROC plot for the first treatment and first reader.
}
\examples{
str(dataset01)
PlotEmpiricalOperatingCharacteristics(dataset = dataset01, opChType = "wAFROC")$Plot

}
\references{
Chakraborty DP, Svahn T (2011) Estimating the parameters of a model 
of visual search from ROC data: an alternate method for fitting proper ROC curves. 
PROC SPIE 7966.
}
\keyword{datasets}
