% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsFROCPowerGivenJK.R
\name{SsFROCPowerGivenJK}
\alias{SsFROCPowerGivenJK}
\title{Statistical power in ROC and FROC paradigms from an ROC/FROC/LROC NH binned dataset}
\usage{
SsFROCPowerGivenJK(dataset, trts, rdrs, effectSizeROC, J, K)
}
\arguments{
\item{dataset}{The pilot dataset to be analyzed, see \link{RJafroc-package},
for variability information. The dataType can be "ROC", "FROC", or "LROC".}

\item{trts}{The indices of the modalities in the pilot dataset that
will be regarded as representative of null hypothesis modalities. 
Two or more modalities, specified by indices, e.g., c(1,2,3).}

\item{rdrs}{The indices of the readers  in the pilot dataset
that will be regarded as representative of the NH readers;
this can be used for example to exclude an atypical reader.}

\item{effectSizeROC}{Array, the range of expected ROC effect sizes
to scan; see book Chapter 11 for guidelines, e.g., seq(0.01, 0.09, 0.005).}

\item{J}{The number of readers in the pivotal study.}

\item{K}{The number of cases in the pivotal study.}
}
\value{
The returned list contains following items.

\item{powerROC}{Array, length(effectSizeROC), the statistical 
   power using ROC methodology.}

\item{powerwAFROC}{Array, length(effectSizeROC), the statistical 
   power using wAFROC methodology.}

## potential project for summer student
}
\description{
Compares statistical power using ROC and FROC paradigms, 
   over a range of ROC effect sizes, from variability information obtained 
   from a null hypothesis \strong{binned} dataset, which can be in 
   ROC/FROC/LROC paradigms, 
   for J readers and K cases in the pivotal study.
}
\note{
The pilot dataset must have at least 2 modalities; this is a
   temporary limitation to be removed in a future update
}
\examples{
\dontrun{
SsFROCPowerGivenJK(dataset04, trts = c(1,2), rdrs = c(1,2,3,4), 
   effectSizeROC = seq(0.01, 0.09, 0.005), J = 5, K = 200)

##SsFROCPowerGivenJK(datasetCadLroc, trts = 1, rdrs = seq(2,9), 
##    effectSizeROC = seq(0.01, 0.09, 0.005), J = 5, K = 200)
   
}  

}
\references{
Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 
\url{https://www.crcpress.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}
}
