% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilAucBinormal.R
\name{UtilAucBinormal}
\alias{UtilAucBinormal}
\title{Binormal model AUC function}
\usage{
UtilAucBinormal (a, b)
}
\arguments{
\item{a}{The \code{a} parameter of the binormal model (separation of 
non-diseased and disesed pdfs)}

\item{b}{The \code{b} parameter of the binormal model (std. dev. of 
non-diseased disesed pdf; diseased pdf has unit std. dev)}
}
\value{
Binormal model-predicted ROC-AUC
}
\description{
{Returns the Binormal model ROC-AUC corresponding to 
   specified parameters. See also \link{UtilAucsRSM}, \link{UtilAucPROPROC} 
   and \link{UtilAucCBM}}
}
\examples{
a <- 2;b <- 0.7
UtilAucBinormal(a,b)

}
\references{
Dorfman DD, Alf E (1969) Maximum-Likelihood Estimation of Parameters of Signal-Detection Theory and 
Determination of Confidence Intervals - Rating-Method Data, Journal of Mathematical Psychology. 6:487-496.
}
