/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class RestQueryBuilder<T extends RestQueryBuilder<T>> {
    protected final URI entryPoint;
    protected final List<String> paths = new ArrayList<String>();
    protected final Map<String, String> params = new LinkedHashMap<String, String>();
    protected String filter = null;

    protected RestQueryBuilder(URI uRI) {
        this.entryPoint = uRI;
    }

    public T addPath(String string) {
        this.paths.add(Objects.requireNonNull(string, "Null path element"));
        return this.self();
    }

    public T withParam(String string, String string2) {
        if (string2 != null && !string2.isEmpty()) {
            this.params.put(Objects.requireNonNull(string, "Null query parameter name"), string2);
        }
        return this.self();
    }

    public T withFilter(String string) {
        if (string != null) {
            this.filter = string;
        }
        return this.self();
    }

    public T withHistory(boolean bl) {
        if (bl) {
            this.withParam("includeHistory", "true");
        }
        return this.self();
    }

    public T withDetail(boolean bl) {
        if (bl) {
            this.withParam("detail", "serieskeysonly");
        }
        return this.self();
    }

    public URL build() throws SdmxException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.entryPoint);
        for (String object : this.paths) {
            stringBuilder.append('/').append(object);
        }
        boolean bl = true;
        if (this.filter != null) {
            stringBuilder.append(bl ? (char)'?' : '&');
            stringBuilder.append(this.filter);
            bl = false;
        }
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            stringBuilder.append(bl ? (char)'?' : '&');
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
            bl = false;
        }
        try {
            return new URL(stringBuilder.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new SdmxInvalidParameterException("Invalid generated url: " + stringBuilder);
        }
    }

    public T withRef(String string, String string2, String string3) {
        if (string != null) {
            this.addPath(string);
        }
        this.addPath(string2);
        if (string3 != null) {
            this.addPath(string3);
        }
        return this.self();
    }

    private T self() {
        return (T)this;
    }
}

