/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.SDMXClientFactory;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.helper.AboutContentFrame;
import it.bancaditalia.oss.sdmx.helper.CheckboxListTableModel;
import it.bancaditalia.oss.sdmx.helper.EnumedListTableModel;
import it.bancaditalia.oss.sdmx.helper.HelperHandler;
import it.bancaditalia.oss.sdmx.helper.ListTableModel;
import it.bancaditalia.oss.sdmx.helper.Mapper;
import it.bancaditalia.oss.sdmx.helper.NewProviderDialog;
import it.bancaditalia.oss.sdmx.helper.ProgressViewer;
import it.bancaditalia.oss.sdmx.helper.ResultsFrame;
import it.bancaditalia.oss.sdmx.helper.ToolCommandsFrame;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.DefaultEditorKit;

public class SDMXHelper
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Configuration.getSdmxLogger();
    private static final String[] help = new String[]{"Obtains a token for accessing Thomson Reuters Datastream Webservices, and print it to standard output.", "", "java " + SDMXHelper.class.getName() + " [-s <provider>]", "", "    -s    Enable \"print query\" button and lock SDMXHelper on the specified provider."};
    static final Action copyAction = new DefaultEditorKit.CopyAction();
    private final JLabel queryLabel;
    private final JTextField sdmxQueryTextField;
    private final JTextField codesFilterTextField;
    private final JTextField dataflowFilterTextField;
    private final JTable dataflowsTable;
    private final JLabel codelistLabel;
    private final JTable dimensionsTable;
    private final JTable codesTable;
    private final JButton checkQueryButton;
    private final JButton btnPrintQuery;
    private final ButtonGroup selectedProviderGroup = new ButtonGroup();
    private final ListTableModel<Dataflow> dataflowsTableModel = new ListTableModel("Dataflow", "Description");
    private final EnumedListTableModel<Dimension> dimensionsTableModel = new EnumedListTableModel("Dimension", "Description");
    private final HashMap<String, TableRowSorter<CheckboxListTableModel<String>>> codelistSortersMap = new HashMap();

    public static void main(String[] stringArray) {
        String string = null;
        if (!(stringArray.length <= 0 || stringArray.length != 1 && stringArray.length <= 2 && "-s".equals(stringArray[0]))) {
            for (String string2 : help) {
                System.err.println(string2);
            }
            System.exit(1);
        } else if (stringArray.length == 2) {
            string = stringArray[1];
        }
        SDMXHelper.start(true, string);
    }

    private SDMXHelper() {
        this(false, null);
    }

    public static void start() {
        SDMXHelper.start(false);
    }

    public static void start(boolean bl) {
        SDMXHelper.start(bl, null);
    }

    public static void start(boolean bl, String string) {
        new SDMXHelper(bl, string);
    }

    public SDMXHelper(boolean bl, String string) {
        if (string != null) {
            if ("".equals(string.trim())) {
                string = null;
            } else {
                logger.info("Picking provider " + string);
            }
        }
        this.setSize(new java.awt.Dimension(1024, 768));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        if (bl) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(1);
        }
        this.setTitle("SDMX Helper Tool");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        final JMenu jMenu = new JMenu("Providers");
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Actions");
        jMenu2.setMnemonic(65);
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem(copyAction);
        jMenuItem.setActionCommand("Copy selection");
        jMenuItem.setMnemonic(65485);
        jMenuItem.setText("Copy selection");
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Build commands");
        jMenuItem2.setMnemonic(66);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SDMXHelper.this.selectedProviderGroup.getSelection() != null) {
                        new ToolCommandsFrame(SDMXHelper.this.sdmxQueryTextField.getText(), SDMXHelper.this.selectedProviderGroup.getSelection().getActionCommand());
                    }
                }
                catch (SdmxException sdmxException) {
                    logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                    logger.log(Level.FINER, "", sdmxException);
                }
            }
        });
        jMenu2.add(jMenuItem2);
        JSeparator jSeparator = new JSeparator();
        jMenu2.add(jSeparator);
        JMenuItem jMenuItem3 = new JMenuItem("Add provider...");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewProviderDialog newProviderDialog = new NewProviderDialog();
                if (newProviderDialog.getResult() == 0) {
                    try {
                        String string = newProviderDialog.getName();
                        String string2 = newProviderDialog.getDescription();
                        URI uRI = new URI(newProviderDialog.getURL());
                        SDMXClientFactory.addProvider(string, uRI, false, false, true, string2, false);
                        jMenu.removeAll();
                        SDMXHelper.this.providersSetup(jMenu);
                    }
                    catch (SdmxException sdmxException) {
                        sdmxException.printStackTrace();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uRISyntaxException.printStackTrace();
                    }
                }
            }
        });
        jMenuItem3.setMnemonic(80);
        jMenu2.add(jMenuItem3);
        JMenu jMenu3 = new JMenu("Help");
        jMenuBar.add(jMenu3);
        JMenuItem jMenuItem4 = new JMenuItem("About SDMX Connectors...");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new AboutContentFrame();
            }
        });
        jMenu3.add(jMenuItem4);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.setLayout(new BorderLayout(0, 0));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setMaximumSize(new java.awt.Dimension(Short.MAX_VALUE, 60));
        jPanel3.setMinimumSize(new java.awt.Dimension(10, 60));
        jPanel3.setPreferredSize(new java.awt.Dimension(10, 60));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "Query", 4, 2, null, new Color(0, 0, 0)), new EmptyBorder(5, 5, 5, 5)));
        jPanel2.add(jPanel3);
        this.queryLabel = new JLabel();
        this.queryLabel.setHorizontalAlignment(4);
        this.queryLabel.setPreferredSize(new java.awt.Dimension(150, 14));
        this.queryLabel.setMinimumSize(new java.awt.Dimension(200, 14));
        this.queryLabel.setMaximumSize(new java.awt.Dimension(200, 14));
        this.queryLabel.setSize(new java.awt.Dimension(200, 14));
        jPanel3.add(this.queryLabel);
        Component component = Box.createHorizontalStrut(10);
        jPanel3.add(component);
        this.sdmxQueryTextField = new JTextField();
        this.queryLabel.setLabelFor(this.sdmxQueryTextField);
        this.sdmxQueryTextField.setFont(new Font(null, 1, 16));
        this.sdmxQueryTextField.setEditable(false);
        jPanel3.add(this.sdmxQueryTextField);
        Component component2 = Box.createHorizontalStrut(10);
        jPanel3.add(component2);
        this.checkQueryButton = new JButton("Check query");
        this.checkQueryButton.setEnabled(false);
        this.checkQueryButton.setPreferredSize(new java.awt.Dimension(120, 23));
        this.checkQueryButton.setMinimumSize(new java.awt.Dimension(120, 23));
        this.checkQueryButton.setMaximumSize(new java.awt.Dimension(120, 23));
        this.checkQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDMXHelper.this.displayQueryResults();
            }
        });
        jPanel3.add(this.checkQueryButton);
        Component component3 = Box.createHorizontalStrut(10);
        this.btnPrintQuery = new JButton("Print query & exit");
        this.btnPrintQuery.setEnabled(false);
        this.btnPrintQuery.setPreferredSize(new java.awt.Dimension(120, 23));
        this.btnPrintQuery.setMinimumSize(new java.awt.Dimension(120, 23));
        this.btnPrintQuery.setMaximumSize(new java.awt.Dimension(120, 23));
        this.btnPrintQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(SDMXHelper.this.sdmxQueryTextField.getText());
                System.exit(0);
            }
        });
        Component component4 = Box.createVerticalStrut(20);
        component4.setPreferredSize(new java.awt.Dimension(0, 10));
        component4.setMinimumSize(new java.awt.Dimension(0, 10));
        component4.setMaximumSize(new java.awt.Dimension(Short.MAX_VALUE, 10));
        jPanel2.add(component4);
        JPanel jPanel4 = new JPanel();
        jPanel4.setPreferredSize(new java.awt.Dimension(10, 150));
        jPanel4.setMinimumSize(new java.awt.Dimension(10, 150));
        jPanel4.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "Dataflow selection", 4, 2, null, new Color(0, 0, 0)), new EmptyBorder(10, 10, 10, 10)));
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel4.add((Component)jPanel5, "North");
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JLabel jLabel = new JLabel("Filter flows by name or description:");
        jPanel5.add(jLabel);
        Component component5 = Box.createHorizontalStrut(10);
        jPanel5.add(component5);
        final TableRowSorter<ListTableModel<Dataflow>> tableRowSorter = new TableRowSorter<ListTableModel<Dataflow>>(this.dataflowsTableModel);
        tableRowSorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        this.dataflowFilterTextField = new JTextField();
        this.dataflowFilterTextField.setPreferredSize(new java.awt.Dimension(6, 25));
        this.dataflowFilterTextField.setMaximumSize(new java.awt.Dimension(Integer.MAX_VALUE, 25));
        this.dataflowFilterTextField.setFont(new Font(null, 1, 16));
        this.dataflowFilterTextField.setForeground(Color.RED);
        this.dataflowFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.filter();
            }

            private void filter() {
                String string = SDMXHelper.this.dataflowFilterTextField.getText();
                if (string != null) {
                    tableRowSorter.setRowFilter(RowFilter.regexFilter("(?i)" + Pattern.quote(string), new int[0]));
                }
            }
        });
        jPanel5.add(this.dataflowFilterTextField);
        Component component6 = Box.createVerticalStrut(10);
        component6.setPreferredSize(new java.awt.Dimension(0, 10));
        component6.setMinimumSize(new java.awt.Dimension(0, 10));
        component6.setMaximumSize(new java.awt.Dimension(Short.MAX_VALUE, 10));
        jPanel2.add(component6);
        Box box = Box.createHorizontalBox();
        jPanel2.add(box);
        JPanel jPanel6 = new JPanel();
        box.add(jPanel6);
        jPanel6.setPreferredSize(new java.awt.Dimension(400, 200));
        jPanel6.setMinimumSize(new java.awt.Dimension(200, 150));
        jPanel6.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "Dimension selection", 4, 2, null, new Color(0, 0, 0)), new EmptyBorder(10, 10, 10, 10)));
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        Box box2 = Box.createHorizontalBox();
        box2.setPreferredSize(new java.awt.Dimension(10, 25));
        box2.setMinimumSize(new java.awt.Dimension(10, 25));
        box2.setMaximumSize(new java.awt.Dimension(32768, 25));
        jPanel6.add(box2);
        JLabel jLabel2 = new JLabel("Dimension to edit:");
        box2.add(jLabel2);
        Component component7 = Box.createHorizontalStrut(10);
        component7.setPreferredSize(new java.awt.Dimension(10, 20));
        component7.setMinimumSize(new java.awt.Dimension(10, 20));
        component7.setMaximumSize(new java.awt.Dimension(10, 20));
        box2.add(component7);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new java.awt.Dimension(200, 23));
        jScrollPane.setMinimumSize(new java.awt.Dimension(200, 23));
        jPanel6.add(jScrollPane);
        JPanel jPanel7 = new JPanel();
        jPanel7.setSize(new java.awt.Dimension(10, 150));
        box.add(jPanel7);
        jPanel7.setPreferredSize(new java.awt.Dimension(400, 200));
        jPanel7.setMinimumSize(new java.awt.Dimension(200, 150));
        jPanel7.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "Codelist selection", 4, 2, null, new Color(0, 0, 0)), new EmptyBorder(10, 10, 10, 10)));
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        Box box3 = Box.createHorizontalBox();
        box3.setPreferredSize(new java.awt.Dimension(10, 25));
        box3.setMinimumSize(new java.awt.Dimension(10, 25));
        box3.setMaximumSize(new java.awt.Dimension(32768, 25));
        jPanel7.add(box3);
        this.codelistLabel = new JLabel("Filter codes:");
        box3.add(this.codelistLabel);
        Component component8 = Box.createHorizontalStrut(10);
        box3.add(component8);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setPreferredSize(new java.awt.Dimension(200, 23));
        jScrollPane2.setMinimumSize(new java.awt.Dimension(200, 23));
        jPanel7.add(jScrollPane2);
        this.codesFilterTextField = new JTextField();
        this.codesFilterTextField.setForeground(Color.RED);
        this.codesFilterTextField.setFont(new Font("Dialog", 1, 16));
        this.codesFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.filter();
            }

            private void filter() {
                String string = SDMXHelper.this.codesFilterTextField.getText();
                if (string != null) {
                    ((TableRowSorter)SDMXHelper.this.codesTable.getRowSorter()).setRowFilter(RowFilter.regexFilter("(?i)" + Pattern.quote(string), new int[0]));
                    SDMXHelper.this.updateCodelistCount();
                }
            }
        });
        box3.add(this.codesFilterTextField);
        JButton jButton = new JButton("Toggle unfiltered rows");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < SDMXHelper.this.codesTable.getRowCount(); ++i) {
                    SDMXHelper.this.codesTable.setValueAt((Boolean)SDMXHelper.this.codesTable.getValueAt(i, SDMXHelper.this.codesTable.convertColumnIndexToView(0)) == false, i, SDMXHelper.this.codesTable.convertColumnIndexToView(0));
                }
                SDMXHelper.this.updateCodelistCount();
            }
        });
        box3.add(jButton);
        this.codesTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                super.editingStopped(changeEvent);
                SDMXHelper.this.updateCodelistCount();
            }
        };
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[]{new TableColumn(0), new TableColumn(1), new TableColumn(2)};
        String[] stringArray = new String[]{"", "Code ID", "Code Description"};
        int[] nArray = new int[]{30, 100, 200};
        int[] nArray2 = new int[]{30, Integer.MAX_VALUE, Integer.MAX_VALUE};
        int[] nArray3 = new int[]{30, 100, 400};
        for (int i = 0; i < tableColumnArray.length; ++i) {
            tableColumnArray[i].setHeaderValue(stringArray[i]);
            tableColumnArray[i].setMinWidth(nArray[i]);
            tableColumnArray[i].setMaxWidth(nArray3[i]);
            tableColumnArray[i].setPreferredWidth(nArray2[i]);
            defaultTableColumnModel.addColumn(tableColumnArray[i]);
        }
        this.codesTable.setColumnModel(defaultTableColumnModel);
        this.codesTable.setAutoCreateColumnsFromModel(false);
        this.codesTable.getTableHeader().setReorderingAllowed(false);
        jScrollPane2.setViewportView(this.codesTable);
        final TableRowSorter<EnumedListTableModel<Dimension>> tableRowSorter2 = new TableRowSorter<EnumedListTableModel<Dimension>>(this.dimensionsTableModel);
        tableRowSorter2.setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        this.dimensionsTable = new JTable();
        this.dimensionsTable.setModel(this.dimensionsTableModel);
        this.dimensionsTable.getColumnModel().getColumn(0).setMinWidth(20);
        this.dimensionsTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this.dimensionsTable.getColumnModel().getColumn(1).setMinWidth(150);
        this.dimensionsTable.getColumnModel().getColumn(1).setMaxWidth(Integer.MAX_VALUE);
        this.dimensionsTable.getColumnModel().getColumn(2).setMinWidth(200);
        this.dimensionsTable.getColumnModel().getColumn(2).setMaxWidth(Integer.MAX_VALUE);
        this.dimensionsTable.getColumnModel().getColumn(2).setPreferredWidth(400);
        this.dimensionsTable.setRowSorter(tableRowSorter2);
        this.dimensionsTable.setSelectionMode(0);
        this.dimensionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                final String string = SDMXHelper.this.getSelectedDimension();
                final String string2 = SDMXHelper.this.getSelectedDataflow();
                if (!listSelectionEvent.getValueIsAdjusting() && string != null) {
                    Object object;
                    List<RowSorter.SortKey> list = SDMXHelper.this.codesTable.getRowSorter() == null ? null : SDMXHelper.this.codesTable.getRowSorter().getSortKeys();
                    final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                    if (!SDMXHelper.this.codelistSortersMap.containsKey(string)) {
                        object = new ProgressViewer((Component)SDMXHelper.this, new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                AtomicBoolean atomicBoolean2 = atomicBoolean;
                                synchronized (atomicBoolean2) {
                                    try {
                                        Map<String, String> map = SdmxClientHandler.getCodes(SDMXHelper.this.selectedProviderGroup.getSelection().getActionCommand(), string2, string);
                                        CheckboxListTableModel<String> checkboxListTableModel = new CheckboxListTableModel<String>("Code ID", "Code Description"){
                                            private static final long serialVersionUID = 1L;

                                            @Override
                                            public void setValueAt(Object object, int n, int n2) {
                                                super.setValueAt(object, n, n2);
                                                try {
                                                    SDMXHelper.this.updateSDMXQuery(SDMXHelper.this.selectedProviderGroup.getSelection().getActionCommand(), SDMXHelper.this.getSelectedDataflow());
                                                }
                                                catch (Exception exception) {
                                                    logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                                                    logger.log(Level.FINER, "", exception);
                                                }
                                            }
                                        };
                                        checkboxListTableModel.setItems(map);
                                        if (!Thread.currentThread().isInterrupted()) {
                                            SDMXHelper.this.codelistSortersMap.put(string, new TableRowSorter<1>(checkboxListTableModel));
                                        }
                                    }
                                    catch (Exception exception) {
                                        logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                                        logger.log(Level.FINER, "", exception);
                                    }
                                    finally {
                                        if (Thread.currentThread().isInterrupted()) {
                                            atomicBoolean.set(true);
                                        }
                                    }
                                }
                            }
                        });
                        ((Dialog)object).setVisible(true);
                    }
                    if (!atomicBoolean.get()) {
                        object = (TableRowSorter)SDMXHelper.this.codelistSortersMap.get(string);
                        SDMXHelper.this.codesTable.setModel((TableModel)((DefaultRowSorter)object).getModel());
                        SDMXHelper.this.codesTable.setRowSorter((RowSorter<? extends TableModel>)object);
                        if (list == null || list.isEmpty()) {
                            ((DefaultRowSorter)object).setSortKeys(Collections.singletonList(new RowSorter.SortKey(1, SortOrder.ASCENDING)));
                        } else {
                            ((DefaultRowSorter)object).setSortKeys(list);
                        }
                        ((DefaultRowSorter)object).setSortable(SDMXHelper.this.codesTable.convertColumnIndexToView(0), false);
                        ((DefaultRowSorter)object).setRowFilter(null);
                        SDMXHelper.this.codesFilterTextField.setText("");
                        SDMXHelper.this.codesTable.revalidate();
                        SDMXHelper.this.updateCodelistCount();
                    }
                }
            }
        });
        jScrollPane.setViewportView(this.dimensionsTable);
        final JTextField jTextField = new JTextField();
        jTextField.setFont(new Font(null, 1, 16));
        jTextField.setForeground(Color.RED);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.filter();
            }

            private void filter() {
                String string = jTextField.getText();
                if (string != null) {
                    tableRowSorter2.setRowFilter(RowFilter.regexFilter("(?i)" + Pattern.quote(string), new int[0]));
                }
            }
        });
        box2.add(jTextField);
        this.dataflowsTable = new JTable();
        this.dataflowsTable.setModel(this.dataflowsTableModel);
        this.dataflowsTable.getColumnModel().getColumn(0).setMinWidth(200);
        this.dataflowsTable.getColumnModel().getColumn(0).setMaxWidth(Integer.MAX_VALUE);
        this.dataflowsTable.getColumnModel().getColumn(1).setMinWidth(200);
        this.dataflowsTable.getColumnModel().getColumn(1).setMaxWidth(Integer.MAX_VALUE);
        this.dataflowsTable.getColumnModel().getColumn(1).setPreferredWidth(800);
        this.dataflowsTable.setRowSorter(tableRowSorter);
        this.dataflowsTable.setSelectionMode(0);
        this.dataflowsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = SDMXHelper.this.getSelectedDataflow();
                if (!listSelectionEvent.getValueIsAdjusting() && string != null) {
                    SDMXHelper.this.updateDataflow(string);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jTextField.setText("");
                            tableRowSorter2.setRowFilter(null);
                            SDMXHelper.this.checkQueryButton.setEnabled(true);
                            SDMXHelper.this.btnPrintQuery.setEnabled(true);
                        }
                    });
                }
            }
        });
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setViewportView(this.dataflowsTable);
        jPanel4.add((Component)jScrollPane3, "Center");
        JButton jButton2 = new JButton("Clear selected dimension");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SDMXHelper.this.getSelectedDataflow() != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((CheckboxListTableModel)SDMXHelper.this.codesTable.getModel()).uncheckAll();
                            SDMXHelper.this.updateCodelistCount();
                        }
                    });
                }
            }
        });
        jButton2.setMaximumSize(new java.awt.Dimension(151, 32768));
        box2.add(jButton2);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(new EmptyBorder(0, 0, 0, 0));
        jTextArea.setBackground(Color.LIGHT_GRAY);
        Font font = new Font("Monospaced", 0, 12);
        jTextArea.setFont(font);
        jTextArea.setEditable(false);
        logger.addHandler(new HelperHandler(jTextArea));
        JScrollPane jScrollPane4 = new JScrollPane(jTextArea);
        jScrollPane4.setBorder(new EmptyBorder(0, 0, 0, 0));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(0);
        jSplitPane.setLeftComponent(jPanel2);
        jSplitPane.setRightComponent(jScrollPane4);
        jPanel.add(jSplitPane);
        this.providersSetup(jMenu);
        if (string != null) {
            for (AbstractButton abstractButton : Collections.list(this.selectedProviderGroup.getElements())) {
                if (!string.equalsIgnoreCase(abstractButton.getActionCommand())) continue;
                this.selectedProviderGroup.setSelected(abstractButton.getModel(), true);
                abstractButton.doClick();
            }
            jPanel3.add(component3);
            jPanel3.add(this.btnPrintQuery);
            jMenu.setEnabled(false);
            jMenu.setText(jMenu.getText() + ": " + string);
        }
        this.setVisible(true);
        jSplitPane.setDividerLocation(0.8);
    }

    private void updateCodelistCount() {
        int n = 0;
        for (int i = 0; i < this.codesTable.getRowCount(); ++i) {
            n += (Boolean)this.codesTable.getModel().getValueAt(this.codesTable.convertRowIndexToModel(i), 0) != false ? 1 : 0;
        }
        this.codelistLabel.setText("Filter codes (" + n + "/" + this.codesTable.getRowCount() + "):");
    }

    private void updateDataflow(final String string) {
        ProgressViewer progressViewer = new ProgressViewer((Component)this, new Runnable(){

            @Override
            public void run() {
                try {
                    List<Dimension> list = SdmxClientHandler.getDimensions(SDMXHelper.this.selectedProviderGroup.getSelection().getActionCommand(), string);
                    if (!Thread.currentThread().isInterrupted()) {
                        SDMXHelper.this.dimensionsTableModel.setItems(list, new Mapper<Dimension>(){

                            @Override
                            public String[] toMapEntry(Dimension dimension) {
                                return new String[]{dimension.getId(), dimension.getName()};
                            }
                        });
                        if (!Thread.currentThread().isInterrupted()) {
                            SDMXHelper.this.updateSDMXQuery(SDMXHelper.this.selectedProviderGroup.getSelection().getActionCommand(), string);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                    logger.log(Level.FINER, "", exception);
                }
            }
        });
        progressViewer.setVisible(true);
        progressViewer.setAlwaysOnTop(true);
    }

    private void displayQueryResults() {
        ProgressViewer progressViewer = new ProgressViewer((Component)this, new Runnable(){

            @Override
            public void run() {
                String string = SDMXHelper.this.sdmxQueryTextField.getText();
                ButtonModel buttonModel = SDMXHelper.this.selectedProviderGroup.getSelection();
                String string2 = SDMXHelper.this.getSelectedDataflow();
                String string3 = buttonModel.getActionCommand();
                try {
                    if (string2 != null && string != null && !string.isEmpty()) {
                        Dataflow dataflow = SdmxClientHandler.getFlow(string3, string2);
                        if (!Thread.currentThread().isInterrupted()) {
                            List<PortableTimeSeries<Double>> list = SdmxClientHandler.getTimeSeriesNames(string3, string);
                            if (!Thread.currentThread().isInterrupted()) {
                                ResultsFrame resultsFrame = new ResultsFrame(list);
                                resultsFrame.setTitle(list.size() + " results" + " - " + dataflow.getDescription());
                                resultsFrame.setVisible(true);
                            }
                        }
                    }
                }
                catch (SdmxException sdmxException) {
                    logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                    logger.log(Level.FINER, "", sdmxException);
                }
            }
        });
        progressViewer.setVisible(true);
    }

    private void providersSetup(JMenu jMenu) {
        for (Map.Entry entry : SDMXClientFactory.getProviders().entrySet()) {
            final String string = (String)entry.getKey();
            final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string + ": " + ((Provider)entry.getValue()).getDescription());
            jRadioButtonMenuItem.setActionCommand(string);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        jRadioButtonMenuItem.setSelected(true);
                        SDMXHelper.this.updateSource(string);
                        SDMXHelper.this.checkQueryButton.setEnabled(false);
                        SDMXHelper.this.btnPrintQuery.setEnabled(false);
                        SDMXHelper.this.sdmxQueryTextField.setText("");
                        SDMXHelper.this.dataflowFilterTextField.setText("");
                        SDMXHelper.this.queryLabel.setText("Provider: " + string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            jMenu.add(jRadioButtonMenuItem);
            this.selectedProviderGroup.add(jRadioButtonMenuItem);
        }
    }

    private void updateSource(final String string) {
        ProgressViewer progressViewer = new ProgressViewer((Component)this, new Runnable(){

            @Override
            public void run() {
                SDMXHelper.this.codelistSortersMap.clear();
                try {
                    final Map<String, String> map = SdmxClientHandler.getFlows(string, null);
                    if (!Thread.currentThread().isInterrupted()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SDMXHelper.this.dimensionsTableModel.setRowCount(0);
                                ((DefaultTableModel)SDMXHelper.this.codesTable.getModel()).setRowCount(0);
                                SDMXHelper.this.dataflowsTableModel.setItems(map);
                            }
                        });
                    }
                }
                catch (SdmxException sdmxException) {
                    logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                    logger.log(Level.FINER, "", sdmxException);
                }
            }
        });
        progressViewer.setVisible(true);
    }

    private void updateSDMXQuery(String string, String string2) throws SdmxException {
        String string3 = string2 + "/";
        StringBuffer stringBuffer = new StringBuffer("");
        List<Dimension> list = SdmxClientHandler.getDimensions(string, string2);
        boolean bl = true;
        for (Dimension dimension : list) {
            if (!bl) {
                stringBuffer.append(".");
            }
            if (this.codelistSortersMap.containsKey(dimension.getId())) {
                CheckboxListTableModel checkboxListTableModel = (CheckboxListTableModel)this.codelistSortersMap.get(dimension.getId()).getModel();
                bl = true;
                for (String string4 : checkboxListTableModel.getCheckedCodes()) {
                    if (!bl) {
                        stringBuffer.append("+");
                    }
                    stringBuffer.append(string4);
                    bl = false;
                }
            }
            bl = false;
        }
        if (stringBuffer.toString().equals("..") && !string.equalsIgnoreCase("EUROSTAT")) {
            stringBuffer = new StringBuffer("all");
        }
        string3 = string3 + stringBuffer.toString();
        this.sdmxQueryTextField.setText(string3);
    }

    private String getSelectedDataflow() {
        int n = this.dataflowsTable.getSelectedRow();
        return n != -1 ? this.dataflowsTable.getValueAt(n, this.dataflowsTable.convertColumnIndexToView(0)).toString() : null;
    }

    private String getSelectedDimension() {
        int n = this.dimensionsTable.getSelectedRow();
        return n != -1 ? this.dimensionsTable.getValueAt(n, this.dimensionsTable.convertColumnIndexToView(1)).toString() : null;
    }
}

