/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxResponseException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.Sdmx21Queries;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

public class EUROSTAT
extends RestSdmxClient {
    private static final String EUROSTAT_PROVIDER = "http://ec.europa.eu/eurostat/SDMX/diss-web/rest";
    private int sleepTime = 6000;
    private int retries = Integer.parseInt(Configuration.getLateResponseRetries(10));
    private static final String ASYNC_DELIVERY_CODE = String.valueOf(413);

    public EUROSTAT() throws URISyntaxException {
        super("Eurostat", new URI(EUROSTAT_PROVIDER), false, false, false);
    }

    @Override
    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return Sdmx21Queries.createDataflowQuery(this.endpoint, string, "ESTAT", string3).buildSdmx21Query();
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        DataParsingResult dataParsingResult = this.getData(dataflow, dataFlowStructure, string, string2, string3, bl, string4, bl2);
        List<PortableTimeSeries> list = dataParsingResult.getData();
        if (list == null || list.size() == 0) {
            Message message = dataParsingResult.getMessage();
            if (EUROSTAT.isAsyncDelivery(message)) {
                String string5 = message.getUrl();
                CompactDataParser compactDataParser = new CompactDataParser(dataFlowStructure, dataflow, !bl);
                for (int i = 1; i <= this.retries; ++i) {
                    logger.info("Trying late retrieval with URL: " + string5 + ". Attempt n: " + i);
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        return this.runQuery(compactDataParser, new URL(message.getUrl()), null).getData();
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.info("Late retrieval attempt " + i + " failed with exception " + malformedURLException.getClass().getSimpleName() + ": " + malformedURLException.getMessage());
                        continue;
                    }
                    catch (SdmxResponseException sdmxResponseException) {
                        logger.info("Late retrieval attempt " + i + " failed with exception " + sdmxResponseException.getClass().getSimpleName() + ": " + sdmxResponseException.getMessage());
                    }
                }
            }
        } else {
            return list;
        }
        throw new SdmxXmlContentException("Late retrieval failed.");
    }

    private static boolean isAsyncDelivery(Message message) {
        return message != null && ASYNC_DELIVERY_CODE.equals(message.getCode()) && message.getUrl() != null;
    }
}

