/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.api;

import it.bancaditalia.oss.sdmx.api.Observation;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

final class ObservationIterator
implements Iterator<Observation> {
    private final PortableTimeSeries series;
    private final int size;
    private int position = -1;

    ObservationIterator(PortableTimeSeries portableTimeSeries) {
        this.series = portableTimeSeries;
        this.size = this.series.getObservations().size();
    }

    private void checkConcurrentModificationException() {
        if (this.series.getObservations().size() != this.size) {
            throw new ConcurrentModificationException("PortableTimeSeries modified while iterating over it.");
        }
    }

    @Override
    public boolean hasNext() {
        this.checkConcurrentModificationException();
        return this.position + 1 < this.size;
    }

    @Override
    public Observation next() {
        this.checkConcurrentModificationException();
        if (!this.hasNext()) {
            throw new NoSuchElementException("Time series has " + this.size + " elements, but " + this.position + "th was requested.");
        }
        ++this.position;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.series.obsLevelAttributes.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().get(this.position));
        }
        Observation observation = new Observation(this.series.getTimeSlots().get(this.position), this.series.getObservations().get(this.position).toString(), hashMap);
        return observation;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Delete operation not permitted");
    }
}

