/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.api;

import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.exceptions.DataStructureException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;

public class PortableDataSet {
    public static final String TIME_LABEL = "TIME_PERIOD";
    public static final String OBS_LABEL = "OBS_VALUE";
    public static final String ID_LABEL = "ID";
    private static final String sourceClass = PortableDataSet.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    private DefaultTableModel model = new DefaultTableModel();

    public PortableDataSet() {
    }

    public PortableDataSet(List<PortableTimeSeries> list) throws DataStructureException {
        this();
        this.putTimeSeries(list);
    }

    public int getColumnIndex(String string) throws DataStructureException {
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!this.model.getColumnName(i).equals(string)) continue;
            return i;
        }
        throw new DataStructureException("Error: column " + string + " does not exist.");
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int n) throws DataStructureException {
        if (n < this.getColumnCount()) {
            return this.model.getColumnName(n);
        }
        throw new DataStructureException("Error: index exceeds number of actual columns");
    }

    public Object getValueAt(int n, int n2) throws DataStructureException {
        if (n < this.getRowCount() && n2 < this.getColumnCount()) {
            return this.model.getValueAt(n, n2);
        }
        throw new DataStructureException("Error: index exceeds number of actual rows or columns");
    }

    public String[] getTimeStamps() throws DataStructureException {
        int n = this.getRowCount();
        String[] stringArray = new String[n];
        int n2 = this.getColumnIndex(TIME_LABEL);
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.getValueAt(i, n2);
        }
        return stringArray;
    }

    public Double[] getObservations() throws DataStructureException {
        int n = this.getRowCount();
        Double[] doubleArray = new Double[n];
        int n2 = this.getColumnIndex(OBS_LABEL);
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = (Double)this.getValueAt(i, n2);
        }
        return doubleArray;
    }

    public String[] getMetadata(String string) {
        int n = this.getRowCount();
        String[] stringArray = new String[n];
        try {
            int n2 = this.getColumnIndex(string);
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)this.getValueAt(i, n2);
            }
        }
        catch (DataStructureException dataStructureException) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[] getMetadataNames() throws DataStructureException {
        int n = this.getColumnCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string = this.getColumnName(i);
            if (string.equals(OBS_LABEL) || string.equals(TIME_LABEL)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public void putTimeSeries(List<PortableTimeSeries> list) throws DataStructureException {
        logger.entering(sourceClass, "putTimeSeries");
        for (PortableTimeSeries portableTimeSeries : list) {
            this.putTimeSeries(portableTimeSeries);
        }
        logger.exiting(sourceClass, "putTimeSeries");
    }

    public void putTimeSeries(PortableTimeSeries portableTimeSeries) throws DataStructureException {
        logger.entering(sourceClass, "putTimeSeries");
        int n = this.model.getRowCount();
        List<String> list = portableTimeSeries.getDimensions();
        List<String> list2 = portableTimeSeries.getAttributes();
        List<Double> list3 = portableTimeSeries.getObservations();
        List<String> list4 = portableTimeSeries.getTimeSlots();
        List<String> list5 = portableTimeSeries.getObsLevelAttributesNames();
        String string = portableTimeSeries.getName();
        int n2 = list3.size();
        for (int i = 0; i < n2; ++i) {
            String string2;
            String string3;
            String[] stringArray;
            Object object;
            Double d = list3.get(i);
            if (list4 != null && (object = list4.get(i)) != null) {
                this.addValue(n, TIME_LABEL, object);
            }
            this.addValue(n, OBS_LABEL, d);
            if (string != null && !string.isEmpty()) {
                this.addValue(n, ID_LABEL, string);
            }
            for (String string4 : list5) {
                String string5 = portableTimeSeries.getObsLevelAttributes(string4).get(i);
                this.addValue(n, string4, string5);
            }
            object = "=";
            for (String string5 : list) {
                stringArray = string5.split((String)object);
                string3 = stringArray[0];
                string2 = stringArray[1];
                this.addValue(n, string3, string2);
            }
            for (String string5 : list2) {
                stringArray = string5.split((String)object);
                string3 = stringArray[0];
                string2 = stringArray[1];
                this.addValue(n, string3, string2);
            }
            ++n;
        }
        logger.exiting(sourceClass, "putTimeSeries");
    }

    public void addValue(int n, String string, Object object) throws DataStructureException {
        if (n >= this.model.getRowCount()) {
            this.model.setRowCount(n + 1);
        }
        int n2 = -1;
        try {
            n2 = this.getColumnIndex(string);
        }
        catch (DataStructureException dataStructureException) {
            this.model.addColumn(string);
            try {
                n2 = this.getColumnIndex(string);
            }
            catch (DataStructureException dataStructureException2) {
                logger.severe(dataStructureException2.getMessage());
                throw new DataStructureException("Unexpected error while adding column: " + string);
            }
        }
        this.model.setValueAt(object, n, n2);
    }

    public String toString() {
        int n;
        int n2 = this.model.getRowCount();
        int n3 = this.model.getColumnCount();
        String string = "";
        for (n = 0; n < n3; ++n) {
            if (n != 0) {
                string = string + ";";
            }
            string = string + this.model.getColumnName(n);
        }
        string = string + "\n";
        for (n = 0; n < n2; ++n) {
            if (n != 0) {
                string = string + "\n";
            }
            for (int i = 0; i < n3; ++i) {
                if (i != 0) {
                    string = string + ";";
                }
                string = string + this.model.getValueAt(n, i);
            }
        }
        return string;
    }
}

