/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.helper.CodeSelectionListener;
import it.bancaditalia.oss.sdmx.helper.FlowFilterListener;
import it.bancaditalia.oss.sdmx.helper.FlowSelectionListener;
import it.bancaditalia.oss.sdmx.helper.GetQueryContentTask;
import it.bancaditalia.oss.sdmx.helper.KeyValueTableModel;
import it.bancaditalia.oss.sdmx.helper.ProgressViewer;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableRowSorter;

public class QueryPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static JLabel queryLab = new JLabel();
    static JTextArea sdmxQuery = new JTextArea();
    static JScrollPane flowsPane = new JScrollPane();
    static JScrollPane dimensionsPane = new JScrollPane();
    static JScrollPane codesPane = new JScrollPane();
    static TableRowSorter<KeyValueTableModel> sorter = null;
    static Hashtable<String, JTable> codeTables = new Hashtable();
    static JTextField flowFilter = new JTextField("");
    static String selectedProvider = null;
    static String selectedDataflow = null;
    static String selectedDimension = null;

    public QueryPanel() {
        super(new BorderLayout());
        sdmxQuery.setLineWrap(true);
        sdmxQuery.setFont(new Font(null, 1, 16));
        sdmxQuery.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(sdmxQuery);
        JButton jButton = new JButton("Check Query");
        jButton.addActionListener(this);
        KeyValueTableModel keyValueTableModel = new KeyValueTableModel("Flow ID", "Flow Description", null);
        JTable jTable = new JTable(keyValueTableModel);
        sorter = new TableRowSorter<KeyValueTableModel>(keyValueTableModel);
        jTable.setRowSorter(sorter);
        jTable.setSelectionMode(0);
        jTable.getSelectionModel().addListSelectionListener(new FlowSelectionListener(this));
        flowsPane.getViewport().add(jTable);
        JLabel jLabel = new JLabel("Filter flows:");
        flowFilter.getDocument().addDocumentListener(new FlowFilterListener());
        flowFilter.setFont(new Font(null, 1, 16));
        flowFilter.setForeground(Color.RED);
        JSplitPane jSplitPane = new JSplitPane(1, jLabel, flowFilter);
        jSplitPane.setResizeWeight(0.05);
        jSplitPane.setEnabled(false);
        JSplitPane jSplitPane2 = new JSplitPane(0, flowsPane, jSplitPane);
        jSplitPane2.setResizeWeight(0.95);
        JTable jTable2 = new JTable(new KeyValueTableModel("Code ID", "Code Description", null));
        jTable2.setAutoCreateRowSorter(true);
        jTable2.getSelectionModel().addListSelectionListener(new CodeSelectionListener());
        codesPane.getViewport().add(jTable2);
        JSplitPane jSplitPane3 = new JSplitPane(1, queryLab, jScrollPane);
        jSplitPane3.setResizeWeight(0.4);
        JSplitPane jSplitPane4 = new JSplitPane(1, jSplitPane3, jButton);
        jSplitPane4.setResizeWeight(0.8);
        JLabel jLabel2 = new JLabel("Select Dimensions");
        JSplitPane jSplitPane5 = new JSplitPane(0, jLabel2, dimensionsPane);
        jSplitPane5.setEnabled(false);
        JLabel jLabel3 = new JLabel("Select Codes");
        JSplitPane jSplitPane6 = new JSplitPane(0, jLabel3, codesPane);
        jSplitPane6.setEnabled(false);
        JSplitPane jSplitPane7 = new JSplitPane(1, jSplitPane5, jSplitPane6);
        jSplitPane7.setResizeWeight(0.2);
        JSplitPane jSplitPane8 = new JSplitPane(0, jSplitPane2, jSplitPane7);
        jSplitPane8.setResizeWeight(0.5);
        JSplitPane jSplitPane9 = new JSplitPane(0, jSplitPane4, jSplitPane8);
        this.add(jSplitPane9);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final ProgressViewer progressViewer = new ProgressViewer(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GetQueryContentTask getQueryContentTask = new GetQueryContentTask(progressViewer);
                getQueryContentTask.execute();
            }
        });
        progressViewer.setVisible(true);
        progressViewer.setAlwaysOnTop(true);
    }

    public static void clearAllViews() {
        QueryPanel.clearFlows();
        QueryPanel.clearDimensions();
        QueryPanel.clearCodes();
        sdmxQuery.setText("");
    }

    public static void clearFlows() {
        JTable jTable = (JTable)flowsPane.getViewport().getComponent(0);
        KeyValueTableModel keyValueTableModel = new KeyValueTableModel("Flow ID", "Flow Description", null);
        jTable.setModel(keyValueTableModel);
        jTable.getSelectionModel().clearSelection();
        sorter = new TableRowSorter<KeyValueTableModel>(keyValueTableModel);
        jTable.setRowSorter(sorter);
    }

    public static void clearDimensions() {
        codeTables = new Hashtable();
        dimensionsPane.getViewport().add(new JList());
    }

    public static void clearCodes() {
        codesPane.getViewport().removeAll();
        codesPane.getViewport().repaint();
    }

    public static String getSDMXQuery() throws SdmxException {
        String string = selectedDataflow + "/";
        StringBuffer stringBuffer = new StringBuffer("");
        List<Dimension> list = SdmxClientHandler.getDimensions(selectedProvider, selectedDataflow);
        int n = 0;
        Iterator<Dimension> iterator = list.iterator();
        while (iterator.hasNext()) {
            Dimension dimension;
            JTable jTable;
            if (n != 0) {
                stringBuffer.append(".");
            }
            if ((jTable = codeTables.get((dimension = iterator.next()).getId())) != null) {
                int[] nArray = jTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    if (i != 0) {
                        stringBuffer.append("+");
                    }
                    int n2 = jTable.convertRowIndexToModel(nArray[i]);
                    String string2 = jTable.getModel().getValueAt(n2, 0).toString();
                    stringBuffer.append(string2);
                }
            }
            ++n;
        }
        if (stringBuffer.toString().equals("..") && !selectedProvider.equalsIgnoreCase("EUROSTAT")) {
            stringBuffer = new StringBuffer("all");
        }
        string = string + stringBuffer.toString();
        return string;
    }
}

