/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.client.custom;

import it.bankitalia.reri.sia.sdmx.api.DSDIdentifier;
import it.bankitalia.reri.sia.sdmx.api.DataFlowStructure;
import it.bankitalia.reri.sia.sdmx.api.Dataflow;
import it.bankitalia.reri.sia.sdmx.client.custom.RestSdmx20Client;
import it.bankitalia.reri.sia.sdmx.parser.v20.DataStructureParser;
import it.bankitalia.reri.sia.util.Configuration;
import it.bankitalia.reri.sia.util.SdmxException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OECD
extends RestSdmx20Client {
    protected static Logger logger = Configuration.getSdmxLogger();

    public OECD() throws MalformedURLException {
        super("OECD", new URL("http://stats.oecd.org/restsdmx/sdmx.ashx/"), false, true);
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        String string4 = null;
        String string5 = null;
        Dataflow dataflow = null;
        string4 = this.buildFlowQuery(this.wsEndpoint, string, "all", "latest");
        string5 = this.runQuery(string4, null);
        if (string5 != null && !string5.isEmpty()) {
            logger.finest(string5);
            try {
                List<DataFlowStructure> list = DataStructureParser.parse(string5);
                if (list.size() <= 0) {
                    throw new SdmxException("The query returned zero dataflows");
                }
                DataFlowStructure dataFlowStructure = list.get(0);
                dataflow = new Dataflow();
                dataflow.setAgency(dataFlowStructure.getAgency());
                dataflow.setId(dataFlowStructure.getId());
                dataflow.setVersion(dataFlowStructure.getVersion());
                dataflow.setName(dataFlowStructure.getName());
                DSDIdentifier dSDIdentifier = new DSDIdentifier();
                dSDIdentifier.setAgency(dataFlowStructure.getAgency());
                dSDIdentifier.setId(dataFlowStructure.getId());
                dSDIdentifier.setVersion(dataFlowStructure.getVersion());
                dataflow.setDsdIdentifier(dSDIdentifier);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return dataflow;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap;
        block5: {
            String string = null;
            String string2 = null;
            hashMap = new HashMap<String, Dataflow>();
            string = this.buildFlowQuery(this.wsEndpoint, "ALL", "all", "latest");
            string2 = this.runQuery(string, null);
            if (string2 != null && !string2.isEmpty()) {
                logger.finest(string2);
                try {
                    List<DataFlowStructure> list = DataStructureParser.parse(string2);
                    if (list.size() > 0) {
                        hashMap = new HashMap();
                        for (DataFlowStructure dataFlowStructure : list) {
                            Dataflow dataflow = new Dataflow();
                            dataflow.setAgency(dataFlowStructure.getAgency());
                            dataflow.setId(dataFlowStructure.getId());
                            dataflow.setVersion(dataFlowStructure.getVersion());
                            dataflow.setName(dataFlowStructure.getName());
                            DSDIdentifier dSDIdentifier = new DSDIdentifier();
                            dSDIdentifier.setAgency(dataFlowStructure.getAgency());
                            dSDIdentifier.setId(dataFlowStructure.getId());
                            dSDIdentifier.setVersion(dataFlowStructure.getVersion());
                            dataflow.setDsdIdentifier(dSDIdentifier);
                            hashMap.put(dataFlowStructure.getId(), dataflow);
                        }
                        break block5;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
            }
            throw new SdmxException("The query returned an empty result");
        }
        return hashMap;
    }

    @Override
    protected String buildDataQuery(URL uRL, Dataflow dataflow, String string, String string2, String string3) {
        if (uRL != null && dataflow != null && string != null && !string.isEmpty()) {
            String string4 = uRL + "/GetData/" + dataflow.getId() + "/";
            string4 = string4 + string;
            if (string2 != null && string2.isEmpty()) {
                string2 = null;
            }
            if (string3 != null && string3.isEmpty()) {
                string3 = null;
            }
            if (string2 != null || string3 != null) {
                string4 = string4 + "?";
                if (string2 != null) {
                    string4 = string4 + "startPeriod=" + string2;
                }
                if (string2 != null && string3 != null) {
                    string4 = string4 + "&";
                }
                if (string3 != null) {
                    string4 = string4 + "endPeriod=" + string3;
                }
            }
            return string4;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + uRL);
    }

    @Override
    protected String buildDSDQuery(URL uRL, String string, String string2, String string3) {
        if (uRL != null && string != null && !string.isEmpty()) {
            String string4 = uRL + "/GetDataStructure/" + string;
            return string4;
        }
        throw new RuntimeException("Invalid query parameters: dsd=" + string + " endpoint=" + uRL);
    }

    @Override
    protected String buildFlowQuery(URL uRL, String string, String string2, String string3) throws SdmxException {
        return this.buildDSDQuery(uRL, string, string2, string3);
    }
}

